/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.MustacheException;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionWrapper
implements Wrapper {
    protected int scopeIndex;
    protected Wrapper[] wrappers;
    protected final Method method;
    protected final Field field;
    protected final Object[] arguments;
    protected final Class[] guard;

    public ReflectionWrapper(int scopeIndex, Wrapper[] wrappers, Class[] guard, AccessibleObject method, Object[] arguments) {
        this.wrappers = wrappers;
        if (method instanceof Field) {
            this.method = null;
            this.field = (Field)method;
        } else {
            this.method = (Method)method;
            this.field = null;
        }
        this.arguments = arguments;
        this.guard = guard;
        this.scopeIndex = scopeIndex;
    }

    public ReflectionWrapper(ReflectionWrapper rw) {
        this(rw.scopeIndex, rw.wrappers, rw.guard, rw.method == null ? rw.field : rw.method, rw.arguments);
    }

    @Override
    public Object call(Object[] scopes) throws GuardException {
        try {
            this.guardCall(scopes);
            Object scope = this.unwrap(scopes);
            if (scope == null) {
                return null;
            }
            if (this.method == null) {
                return this.field.get(scope);
            }
            return this.method.invoke(scope, this.arguments);
        }
        catch (InvocationTargetException e) {
            throw new MustacheException("Failed to execute method: " + this.method, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new MustacheException("Failed to execute method: " + this.method, e);
        }
    }

    protected Object unwrap(Object[] scopes) throws GuardException {
        Object scope = scopes[this.scopeIndex];
        if (this.wrappers != null) {
            for (int i = 0; i < this.wrappers.length; ++i) {
                scope = this.wrappers[i].call(new Object[]{scope});
            }
        }
        return scope;
    }

    protected void guardCall(Object[] scopes) throws GuardException {
        int length = scopes.length;
        if (this.guard.length != length) {
            throw new GuardException();
        }
        for (int j = 0; j < length; ++j) {
            Class guardClass = this.guard[j];
            if (guardClass == null || guardClass.isInstance(scopes[j])) continue;
            throw new GuardException();
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

