/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.Code;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;

public class DefaultCode
implements Code {
    private StringBuilder sb = new StringBuilder();
    protected String appended;
    protected final ObjectHandler oh;
    protected final String name;
    protected TemplateContext tc;
    protected final Mustache mustache;
    protected final String type;
    protected Wrapper wrapper;
    protected boolean inited;
    private static boolean debug = Boolean.getBoolean("mustache.debug");
    protected Logger logger = Logger.getLogger("mustache");
    protected boolean notfound = false;
    protected boolean returnThis = false;
    private ThreadLocal<Object[]> localScopes = new ThreadLocal();

    public DefaultCode() {
        this(null, null, null, null, null);
    }

    public DefaultCode(TemplateContext tc, ObjectHandler oh, Mustache mustache, String name, String type) {
        this.oh = oh;
        this.mustache = mustache;
        this.type = type;
        this.name = name;
        this.tc = tc;
        if (".".equals(name)) {
            this.returnThis = true;
        }
    }

    @Override
    public Code[] getCodes() {
        return this.mustache == null ? null : this.mustache.getCodes();
    }

    @Override
    public synchronized void init() {
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                code.init();
            }
        }
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.mustache.setCodes(newcodes);
    }

    public Object get(String name, Object[] scopes) {
        if (this.notfound) {
            return null;
        }
        if (this.returnThis) {
            return scopes[scopes.length - 1];
        }
        if (this.wrapper == null && this.getWrapper(name, scopes)) {
            return null;
        }
        try {
            return this.oh.coerce(this.wrapper.call(scopes));
        }
        catch (GuardException e) {
            this.wrapper = null;
            return this.get(name, scopes);
        }
    }

    private boolean getWrapper(String name, Object[] scopes) {
        this.wrapper = this.oh.find(name, scopes);
        if (this.wrapper == null) {
            this.notfound = true;
            if (debug && !(this instanceof PartialCode)) {
                StringBuilder sb = new StringBuilder("Failed to find: ");
                sb.append(name).append(" (").append(this.tc.file()).append(":").append(this.tc.line()).append(") ").append("in");
                for (Object scope : scopes) {
                    if (scope == null) continue;
                    sb.append(" ").append(scope.getClass().getSimpleName());
                }
                this.logger.warning(sb.toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public Writer execute(Writer writer, Object scope) {
        return this.execute(writer, new Object[]{scope});
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        return this.appendText(this.runCodes(writer, scopes));
    }

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                this.tag(writer, this.type);
                if (this.getCodes() != null) {
                    this.runIdentity(writer);
                    this.tag(writer, "/");
                }
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
    }

    protected void runIdentity(Writer writer) {
        int length = this.getCodes().length;
        for (int i = 0; i < length; ++i) {
            this.getCodes()[i].identity(writer);
        }
    }

    private void tag(Writer writer, String tag) throws IOException {
        writer.write(this.tc.startChars());
        writer.write(tag);
        writer.write(this.name);
        writer.write(this.tc.endChars());
    }

    protected Writer appendText(Writer writer) {
        if (this.appended != null) {
            try {
                writer.write(this.appended);
            }
            catch (IOException e) {
                throw new MustacheException(e);
            }
        }
        return writer;
    }

    protected Writer runCodes(Writer writer, Object[] scopes) {
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                writer = code.execute(writer, scopes);
            }
        }
        return writer;
    }

    @Override
    public void append(String text) {
        this.sb.append(text);
        this.appended = this.sb.toString();
    }

    protected Object[] addScope(Object next, Object[] scopes) {
        Object[] iteratorScopes = scopes;
        if (next != null) {
            int srcPos;
            iteratorScopes = this.localScopes.get();
            if (iteratorScopes == null) {
                iteratorScopes = new Object[scopes.length + 1];
                this.localScopes.set(iteratorScopes);
            } else if (iteratorScopes.length < scopes.length + 1) {
                iteratorScopes = new Object[scopes.length + 1];
                this.localScopes.set(iteratorScopes);
            }
            System.arraycopy(scopes, 0, iteratorScopes, srcPos, scopes.length);
            for (srcPos = iteratorScopes.length - scopes.length - 1; srcPos > 0; --srcPos) {
                iteratorScopes[srcPos - 1] = null;
            }
            iteratorScopes[iteratorScopes.length - 1] = next;
        }
        return iteratorScopes;
    }
}

