/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.util.LatchedWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class PartialCode
extends DefaultCode {
    protected Mustache partial;
    private final String variable;
    protected final String extension;
    private DefaultMustacheFactory cf;
    private final ExecutorService les;

    protected PartialCode(TemplateContext tc, DefaultMustacheFactory cf, Mustache mustache, String type, String variable) {
        super(tc, cf.getObjectHandler(), mustache, variable, type);
        this.cf = cf;
        this.variable = variable;
        int index = tc.file().lastIndexOf(".");
        this.extension = index == -1 ? "" : tc.file().substring(index);
        this.les = cf.getExecutorService();
    }

    public PartialCode(TemplateContext tc, DefaultMustacheFactory cf, String variable) {
        this(tc, cf, null, ">", variable);
    }

    @Override
    public Code[] getCodes() {
        return this.partial.getCodes();
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.partial.setCodes(newcodes);
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        return this.partialExecute(writer, scopes);
    }

    @Override
    public synchronized void init() {
        this.partial = this.cf.compile(this.variable + this.extension);
        if (this.partial == null) {
            throw new MustacheException("Failed to compile partial: " + this.variable);
        }
    }

    protected Writer partialExecute(Writer writer, final Object[] scopes) {
        Object object = this.get(this.variable, scopes);
        if (object instanceof Callable) {
            final Callable callable = (Callable)object;
            if (this.les == null) {
                try {
                    object = callable.call();
                }
                catch (Exception e) {
                    throw new MustacheException(e);
                }
            } else {
                final LatchedWriter latchedWriter = new LatchedWriter(writer);
                final Writer finalWriter = writer;
                this.les.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PartialCode.this.execute(finalWriter, callable.call(), scopes);
                            latchedWriter.done();
                        }
                        catch (Throwable e) {
                            latchedWriter.failed(e);
                        }
                    }
                });
                return latchedWriter;
            }
        }
        return this.execute(writer, object, scopes);
    }

    protected Writer execute(Writer writer, Object scope, Object[] scopes) {
        Object[] newscopes = this.addScope(scope, scopes);
        return this.appendText(this.partial.execute(writer, newscopes));
    }
}

