/*
 * Decompiled with CFR 0.152.
 */
package mustachejava.benchmarks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheResolver;
import com.github.mustachejavabenchmarks.NullWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mustachejava.benchmarks.Tweet;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Benchmark)
public class TweetBench {
    Mustache tweetMustache = new DefaultMustacheFactory().compile("tweet.mustache");
    Mustache timelineMustache = new DefaultMustacheFactory().compile("timeline.mustache");
    Tweet tweet = new Tweet();
    NullWriter nullWriter = new NullWriter();
    List<Object> tweetScope = new ArrayList<Tweet>(Collections.singletonList(this.tweet));
    List<Object> timelineScope = new ArrayList<Object>();
    List<Object> jsonScope;
    Map<String, String> cache;
    MustacheResolver cached;

    private String readResource(String name) {
        StringWriter sw = new StringWriter();
        InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream(name));
        char[] chars = new char[1024];
        try {
            int read;
            while ((read = reader.read(chars)) != -1) {
                sw.write(chars, 0, read);
            }
            sw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public TweetBench() {
        final ArrayList<Tweet> tweetList = new ArrayList<Tweet>();
        for (int i = 0; i < 20; ++i) {
            tweetList.add(new Tweet());
        }
        this.timelineScope.add(new Object(){
            List<Tweet> tweets;
            {
                this.tweets = tweetList;
            }
        });
        this.cache = new HashMap<String, String>();
        this.cache.put("tweet.mustache", this.readResource("tweet.mustache"));
        this.cache.put("entities.mustache", this.readResource("entities.mustache"));
        this.cached = resourceName -> new StringReader(this.cache.get(resourceName));
        try {
            MappingJsonFactory jf = new MappingJsonFactory();
            InputStream json = TweetBench.class.getClassLoader().getResourceAsStream("tweet.json");
            this.jsonScope = new ArrayList<JsonMap>(Collections.singletonList(new JsonMap((JsonNode)jf.createParser(json).readValueAsTree())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void testCompilation() {
        DefaultMustacheFactory dmf = new DefaultMustacheFactory(this.cached);
        Mustache m = dmf.compile("tweet.mustache");
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void testExecution() throws IOException {
        this.tweetMustache.execute((Writer)this.nullWriter, this.tweetScope).close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void testTimeline() throws IOException {
        this.timelineMustache.execute((Writer)this.nullWriter, this.timelineScope).close();
    }

    public static void main(String[] args) throws IOException {
        DefaultMustacheFactory dmf = new DefaultMustacheFactory();
        Mustache m = dmf.compile("tweet.mustache");
        StringWriter sw = new StringWriter();
        m.execute((Writer)sw, (Object)new Tweet()).close();
        System.out.println(sw);
        InputStream json = TweetBench.class.getClassLoader().getResourceAsStream("tweet.json");
        MappingJsonFactory jf = new MappingJsonFactory();
        JsonNode jsonNode = (JsonNode)jf.createParser(json).readValueAsTree();
        sw = new StringWriter();
        m.execute((Writer)sw, (Object)new JsonMap(jsonNode)).close();
        System.out.println(sw);
        TweetBench tb = new TweetBench();
        while (true) {
            tb.testCompilation();
        }
    }

    private static class JsonMap
    extends HashMap {
        private final JsonNode test;

        public JsonMap(JsonNode test) {
            this.test = test;
        }

        @Override
        public Object get(Object key) {
            JsonNode value = this.test.get(key.toString());
            return this.convert(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.test.has(key.toString());
        }

        private Object convert(final JsonNode value) {
            if (value == null || value.isNull()) {
                return null;
            }
            if (value.isBoolean()) {
                return value.booleanValue();
            }
            if (value.isValueNode()) {
                return value.asText();
            }
            if (value.isArray()) {
                return () -> new Iterator(){
                    private Iterator iterator;
                    {
                        this.iterator = value.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    public Object next() {
                        return this.convert((JsonNode)this.iterator.next());
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return new JsonMap(value);
        }
    }
}

