/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.assertion;

import com.github.springtestdbunit.assertion.DatabaseAssertion;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NonStrictDatabaseAssertion
implements DatabaseAssertion {
    NonStrictDatabaseAssertion() {
    }

    @Override
    public void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet, List<IColumnFilter> columnFilters) throws DatabaseUnitException {
        for (String tableName : expectedDataSet.getTableNames()) {
            ITable expectedTable = expectedDataSet.getTable(tableName);
            ITable actualTable = actualDataSet.getTable(tableName);
            this.assertEquals(expectedTable, actualTable, columnFilters);
        }
    }

    @Override
    public void assertEquals(ITable expectedTable, ITable actualTable, List<IColumnFilter> columnFilters) throws DatabaseUnitException {
        Set<String> ignoredColumns = this.getColumnsToIgnore(expectedTable.getTableMetaData(), actualTable.getTableMetaData(), columnFilters);
        Assertion.assertEqualsIgnoreCols((ITable)expectedTable, (ITable)actualTable, (String[])ignoredColumns.toArray(new String[ignoredColumns.size()]));
    }

    private Set<String> getColumnsToIgnore(ITableMetaData expectedMetaData, ITableMetaData actualMetaData, List<IColumnFilter> columnFilters) throws DataSetException {
        if (columnFilters.size() == 0) {
            return this.getColumnsToIgnore(expectedMetaData, actualMetaData);
        }
        LinkedHashSet<String> ignoredColumns = new LinkedHashSet<String>();
        for (IColumnFilter filter : columnFilters) {
            FilteredTableMetaData filteredExpectedMetaData = new FilteredTableMetaData(expectedMetaData, filter);
            ignoredColumns.addAll(this.getColumnsToIgnore((ITableMetaData)filteredExpectedMetaData, actualMetaData));
        }
        return ignoredColumns;
    }

    protected Set<String> getColumnsToIgnore(ITableMetaData expectedMetaData, ITableMetaData actualMetaData) throws DataSetException {
        Column[] notSpecifiedInExpected = Columns.getColumnDiff((ITableMetaData)expectedMetaData, (ITableMetaData)actualMetaData).getActual();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Column column : notSpecifiedInExpected) {
            result.add(column.getColumnName());
        }
        return result;
    }
}

