/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import java.sql.SQLException;
import org.dbunit.database.IDatabaseConnection;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DatabaseConnections {
    private final String[] names;
    private final IDatabaseConnection[] connections;

    public DatabaseConnections(String[] names, IDatabaseConnection[] connections) {
        Assert.notEmpty((Object[])names, (String)"Names must not be empty");
        Assert.notEmpty((Object[])connections, (String)"Connections must not be empty");
        Assert.isTrue((names.length == connections.length ? 1 : 0) != 0, (String)"Names and Connections must have the same length");
        this.names = names;
        this.connections = connections;
    }

    public void closeAll() throws SQLException {
        for (IDatabaseConnection connection : this.connections) {
            connection.close();
        }
    }

    public IDatabaseConnection get(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return this.connections[0];
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            return this.connections[i];
        }
        throw new IllegalStateException("Unable to find connection named " + name);
    }
}

