/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class CountMatcher<T>
extends TypeSafeMatcher<Iterable<T>> {
    private final int count;
    private final Matcher<T> matcher;

    public CountMatcher(int count, Matcher<T> matcher) {
        this.count = count;
        this.matcher = matcher;
    }

    public static <T> Matcher<Iterable<T>> containsExactly(int count, Matcher<T> matcher) {
        return new CountMatcher<T>(count, matcher);
    }

    protected boolean matchesSafely(Iterable<T> iterable) {
        int numberOfmatches = 0;
        for (T item : iterable) {
            if (!this.matcher.matches(item)) continue;
            ++numberOfmatches;
        }
        return numberOfmatches == this.count;
    }

    public void describeTo(Description desc) {
        desc.appendText("Iterable containing exactly ").appendValue((Object)this.count).appendText(" ").appendDescriptionOf(this.matcher);
    }

    protected void describeMismatchSafely(Iterable<T> items, Description mismatchDescription) {
        if (!items.iterator().hasNext()) {
            mismatchDescription.appendText("The collection was empty");
        } else {
            for (T item : items) {
                mismatchDescription.appendText("\n");
                if (this.matcher.matches(item)) {
                    mismatchDescription.appendText("Match:   ");
                } else {
                    mismatchDescription.appendText("Mismatch:");
                }
                this.matcher.describeMismatch(item, mismatchDescription);
            }
        }
    }
}

