/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test.matcher;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.Confidence;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class BugInstanceMatcher
extends BaseMatcher<BugInstance> {
    private static final Pattern ANON_FUNCTION_SCALA_PATTERN = Pattern.compile("\\$\\$anonfun\\$([^\\$]+)\\$");
    private final String bugType;
    private final String className;
    private final String methodName;
    private final String fieldName;
    private final String variableName;
    private final Integer lineNumber;
    private final Integer lineNumberApprox;
    private final Confidence confidence;
    private final String jspFile;
    private final List<Integer> multipleChoicesLine;

    public BugInstanceMatcher(String bugType, String className, String methodName, String fieldName, String variableName, Integer lineNumber, Integer lineNumberApprox, Confidence confidence, String jspFile, List<Integer> multipleChoicesLine) {
        this.bugType = bugType;
        this.className = className;
        this.methodName = methodName;
        this.fieldName = fieldName;
        this.variableName = variableName;
        this.lineNumber = lineNumber;
        this.lineNumberApprox = lineNumberApprox;
        this.confidence = confidence;
        this.jspFile = jspFile;
        this.multipleChoicesLine = multipleChoicesLine;
    }

    public boolean matches(Object obj) {
        if (obj instanceof BugInstance) {
            SourceLineAnnotation srcAnn;
            String fullName;
            ClassAnnotation classAnn;
            BugInstance bugInstance = (BugInstance)obj;
            boolean criteriaMatches = true;
            if (this.bugType != null) {
                criteriaMatches &= bugInstance.getType().equals(this.bugType);
            }
            if (this.confidence != null) {
                criteriaMatches &= bugInstance.getPriority() == this.confidence.getConfidenceValue();
            }
            if (this.className != null) {
                classAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, ClassAnnotation.class);
                if (classAnn == null) {
                    return false;
                }
                fullName = classAnn.getClassName();
                int startDot = fullName.lastIndexOf(".") + 1;
                int endDollar = fullName.indexOf(36);
                String simpleName = fullName.substring(startDot != -1 ? startDot : 0, endDollar != -1 ? endDollar : fullName.length());
                String simpleNameInner = fullName.substring(startDot != -1 ? startDot : 0, fullName.length());
                criteriaMatches &= fullName.equals(this.className) || simpleName.equals(this.className) || simpleNameInner.equals(this.className);
            }
            if (this.methodName != null) {
                MethodAnnotation methodAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, MethodAnnotation.class);
                ClassAnnotation classAnn2 = BugInstanceMatcher.extractBugAnnotation(bugInstance, ClassAnnotation.class);
                String fullClassName = classAnn2.getClassName();
                if (methodAnn == null) {
                    return false;
                }
                if (methodAnn.getMethodName().startsWith("apply") && fullClassName != null) {
                    Matcher m = ANON_FUNCTION_SCALA_PATTERN.matcher(fullClassName);
                    if (m.find()) {
                        criteriaMatches &= methodAnn.getMethodName().equals(this.methodName) || this.methodName.equals(m.group(1));
                    }
                } else {
                    criteriaMatches &= methodAnn.getMethodName().equals(this.methodName);
                }
            }
            if (this.fieldName != null) {
                FieldAnnotation fieldAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, FieldAnnotation.class);
                if (fieldAnn == null) {
                    return false;
                }
                criteriaMatches &= fieldAnn.getFieldName().equals(this.fieldName);
            }
            if (this.variableName != null) {
                LocalVariableAnnotation localVarAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, LocalVariableAnnotation.class);
                if (localVarAnn == null) {
                    return false;
                }
                criteriaMatches &= localVarAnn.getName().equals(this.variableName);
            }
            if (this.lineNumber != null) {
                srcAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, SourceLineAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                criteriaMatches &= srcAnn.getStartLine() <= this.lineNumber && this.lineNumber <= srcAnn.getEndLine();
            }
            if (this.lineNumberApprox != null) {
                srcAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, SourceLineAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                criteriaMatches &= srcAnn.getStartLine() - 1 <= this.lineNumberApprox && this.lineNumberApprox <= srcAnn.getEndLine() + 1;
            }
            if (this.jspFile != null) {
                classAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, ClassAnnotation.class);
                fullName = classAnn.getClassName().replaceAll("\\.", "/").replaceAll("_005f", "_").replaceAll("_jsp", ".jsp");
                criteriaMatches &= fullName.endsWith(this.jspFile);
            }
            if (this.multipleChoicesLine != null) {
                srcAnn = BugInstanceMatcher.extractBugAnnotation(bugInstance, SourceLineAnnotation.class);
                if (srcAnn == null) {
                    return false;
                }
                boolean found = false;
                for (Integer potentialMatch : this.multipleChoicesLine) {
                    if (srcAnn.getStartLine() - 1 > potentialMatch || potentialMatch > srcAnn.getEndLine() + 1) continue;
                    found = true;
                }
                criteriaMatches &= found;
            }
            return criteriaMatches;
        }
        return false;
    }

    private static <T> T extractBugAnnotation(BugInstance bugInstance, Class<T> annotationType) {
        for (BugAnnotation annotation : bugInstance.getAnnotations()) {
            if (!annotation.getClass().equals(annotationType)) continue;
            return annotationType.cast(annotation);
        }
        return null;
    }

    public void describeTo(Description description) {
        description.appendText("BugInstance with:\n");
        if (this.bugType != null) {
            description.appendText("bugType=").appendValue((Object)this.bugType).appendText(",");
        }
        if (this.className != null) {
            description.appendText("className=").appendValue((Object)this.className).appendText(",");
        }
        if (this.methodName != null) {
            description.appendText("methodName=").appendValue((Object)this.methodName).appendText(",");
        }
        if (this.fieldName != null) {
            description.appendText("fieldName=").appendValue((Object)this.fieldName).appendText(",");
        }
        if (this.variableName != null) {
            description.appendText("variableName=").appendValue((Object)this.variableName).appendText(",");
        }
        if (this.lineNumber != null) {
            description.appendText("lineNumber=").appendValue((Object)this.lineNumber);
        }
    }
}

