/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test.matcher;

import edu.umd.cs.findbugs.annotations.Confidence;
import edu.umd.cs.findbugs.test.matcher.BugInstanceMatcher;
import edu.umd.cs.findbugs.test.service.ClassFileLocator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import org.sonar.plugins.findbugs.resource.SmapParser;

public class BugInstanceMatcherBuilder {
    private String bugType;
    private String className;
    private String methodName;
    private String fieldName;
    private Integer lineNumber;
    private Integer lineNumberApprox;
    private Confidence confidence;
    private String jspFile;
    private Integer jspLine;

    public BugInstanceMatcherBuilder bugType(String bugType) {
        this.bugType = bugType;
        return this;
    }

    public BugInstanceMatcherBuilder inClass(String className) {
        this.className = className;
        return this;
    }

    public BugInstanceMatcherBuilder inMethod(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public BugInstanceMatcherBuilder atField(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public BugInstanceMatcherBuilder atLine(int lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @Deprecated
    public BugInstanceMatcherBuilder atLineApprox(int lineNumberApprox) {
        this.lineNumberApprox = lineNumberApprox;
        return this;
    }

    public BugInstanceMatcherBuilder withConfidence(Confidence confidence) {
        this.confidence = confidence;
        return this;
    }

    public BugInstanceMatcherBuilder inJspFile(String jspFile) {
        this.jspFile = jspFile;
        return this;
    }

    public BugInstanceMatcherBuilder atJspLine(Integer jspLine) {
        this.jspLine = jspLine;
        return this;
    }

    public BugInstanceMatcher build() {
        List<Integer> multipleChoicesLine = null;
        if (this.jspLine != null) {
            if (this.jspFile != null) {
                multipleChoicesLine = BugInstanceMatcherBuilder.mapJspToJavaLine(this.jspFile, this.jspLine);
            } else {
                throw new RuntimeException("JSP file not set.");
            }
        }
        return new BugInstanceMatcher(this.bugType, this.className, this.methodName, this.fieldName, this.lineNumber, this.lineNumberApprox, this.confidence, this.jspFile, multipleChoicesLine);
    }

    private static List<Integer> mapJspToJavaLine(String jspFile, Integer jspLine) {
        ClassFileLocator locator = new ClassFileLocator();
        File smapFile = new File(locator.getJspFilePath(jspFile) + ".smap");
        if (!smapFile.exists()) {
            throw new RuntimeException("SMAP File are missing. (" + smapFile + ")");
        }
        try {
            String contents = new String(Files.readAllBytes(smapFile.toPath()), StandardCharsets.UTF_8);
            SmapParser smapParser = new SmapParser(contents);
            List<Integer> javaLineNumbers = smapParser.getJavaLineNumbers(jspLine);
            if (javaLineNumbers.isEmpty()) {
                throw new RuntimeException("Unable to find the mapping for the JSP line " + jspLine);
            }
            return javaLineNumbers;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open the smap file.", e);
        }
    }
}

