/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotBugsRunnerForJavaExec
extends SpotBugsRunner {
    private final Logger log = LoggerFactory.getLogger(SpotBugsRunnerForJavaExec.class);

    @Override
    public void run(@NonNull SpotBugsTask task) {
        try {
            task.getProject().javaexec(this.configureJavaExec(task)).rethrowFailure().assertNormalExitValue();
        }
        catch (ExecException e) {
            if (task.getIgnoreFailures()) {
                this.log.warn("SpotBugs reported failures", (Throwable)e);
            }
            String errorMessage = "Verification failed: SpotBugs execution thrown exception.";
            List reportPaths = task.getReportsDir().getAsFileTree().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList());
            if (!reportPaths.isEmpty()) {
                errorMessage = errorMessage + "SpotBugs report can be found in " + String.join((CharSequence)",", reportPaths);
            }
            throw new GradleException(errorMessage, (Throwable)e);
        }
    }

    private Action<? super JavaExecSpec> configureJavaExec(SpotBugsTask task) {
        return spec -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-exitcode");
            args.addAll(this.buildArguments(task));
            spec.classpath(new Object[]{task.getSpotbugsClasspath()});
            spec.setJvmArgs(this.buildJvmArguments(task));
            spec.setMain("edu.umd.cs.findbugs.FindBugs2");
            spec.setArgs(args);
            String maxHeapSize = (String)task.getMaxHeapSize().getOrNull();
            if (maxHeapSize != null) {
                spec.setMaxHeapSize(maxHeapSize);
            }
        };
    }
}

