/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0016\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunner;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "run", "", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "buildArguments", "", "", "createFileForAuxClasspath", "generateFile", "files", "Lorg/gradle/api/file/FileCollection;", "file", "Ljava/io/File;", "buildJvmArguments", "join", "", "spotbugs-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSpotBugsRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpotBugsRunner.kt\ncom/github/spotbugs/snom/internal/SpotBugsRunner\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1317#2,2:162\n1317#2,2:165\n1#3:164\n*S KotlinDebug\n*F\n+ 1 SpotBugsRunner.kt\ncom/github/spotbugs/snom/internal/SpotBugsRunner\n*L\n61#1:162,2\n141#1:165,2\n*E\n"})
public abstract class SpotBugsRunner {
    private final Logger log = LoggerFactory.getLogger(SpotBugsRunner.class);

    public abstract void run(@NotNull SpotBugsTask var1);

    @NotNull
    protected final List<String> buildArguments(@NotNull SpotBugsTask task) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        List $this$buildArguments_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ConfigurableFileCollection plugins = task.getPluginJarFiles();
        if (!plugins.isEmpty()) {
            $this$buildArguments_u24lambda_u242.add("-pluginList");
            Set set = plugins.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
            $this$buildArguments_u24lambda_u242.add(this.join(set));
        }
        $this$buildArguments_u24lambda_u242.add("-timestampNow");
        if (!task.getAuxClassPaths().isEmpty()) {
            boolean bl2;
            if (((Boolean)task.getUseAuxclasspathFile().get()).booleanValue()) {
                $this$buildArguments_u24lambda_u242.add("-auxclasspathFromFile");
                String auxClasspathFile = this.createFileForAuxClasspath(task);
                this.log.debug("Using auxclasspath file: {}", (Object)auxClasspathFile);
                bl2 = $this$buildArguments_u24lambda_u242.add(auxClasspathFile);
            } else {
                $this$buildArguments_u24lambda_u242.add("-auxclasspath");
                Set set = task.getAuxClassPaths().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                bl2 = $this$buildArguments_u24lambda_u242.add(this.join(set));
            }
        }
        if (!task.getSourceDirs().isEmpty()) {
            $this$buildArguments_u24lambda_u242.add("-sourcepath");
            String string = task.getSourceDirs().getAsPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsPath(...)");
            $this$buildArguments_u24lambda_u242.add(string);
        }
        if (((Boolean)task.getShowProgress().getOrElse((Object)false)).booleanValue()) {
            $this$buildArguments_u24lambda_u242.add("-progress");
        }
        Object $this$forEach$iv = task.getRequiredReports$spotbugs_gradle_plugin();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            SpotBugsReport report = (SpotBugsReport)element$iv;
            boolean bl3 = false;
            File reportFile = (File)report.getOutputLocation().getAsFile().get();
            File dir = reportFile.getParentFile();
            dir.mkdirs();
            $this$buildArguments_u24lambda_u242.add(report.getCommandLineOption() + "=" + reportFile.getAbsolutePath());
        }
        if (task.getEffort().isPresent()) {
            $this$forEach$iv = ((Effort)((Object)task.getEffort().get())).name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = ((String)$this$forEach$iv).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $this$buildArguments_u24lambda_u242.add("-effort:" + string);
        }
        if (task.getReportLevel().isPresent()) {
            String string = ((Confidence)((Object)task.getReportLevel().get())).getCommandLineOption$spotbugs_gradle_plugin();
            if (string != null) {
                String p0 = string;
                boolean bl4 = false;
                boolean $i$f$buildArguments$lambda$2$stub_for_inlining = false;
                $this$buildArguments_u24lambda_u242.add(p0);
            }
        }
        if (task.getVisitors().isPresent()) {
            Object object = task.getVisitors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (!((Collection)object).isEmpty()) {
                $this$buildArguments_u24lambda_u242.add("-visitors");
                Object object2 = task.getVisitors().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                $this$buildArguments_u24lambda_u242.add(CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (task.getOmitVisitors().isPresent()) {
            Object object = task.getOmitVisitors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (!((Collection)object).isEmpty()) {
                $this$buildArguments_u24lambda_u242.add("-omitVisitors");
                Object object3 = task.getOmitVisitors().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                $this$buildArguments_u24lambda_u242.add(CollectionsKt.joinToString$default((Iterable)((Iterable)object3), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (task.getChooseVisitors().isPresent()) {
            Object object = task.getChooseVisitors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (!((Collection)object).isEmpty()) {
                $this$buildArguments_u24lambda_u242.add("-chooseVisitors");
                Object object4 = task.getChooseVisitors().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                $this$buildArguments_u24lambda_u242.add(CollectionsKt.joinToString$default((Iterable)((Iterable)object4), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (task.getIncludeFilter().isPresent()) {
            $this$buildArguments_u24lambda_u242.add("-include");
            String string = ((RegularFile)task.getIncludeFilter().get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            $this$buildArguments_u24lambda_u242.add(string);
        }
        if (task.getExcludeFilter().isPresent()) {
            $this$buildArguments_u24lambda_u242.add("-exclude");
            String string = ((RegularFile)task.getExcludeFilter().get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            $this$buildArguments_u24lambda_u242.add(string);
        }
        if (task.getBaselineFile().isPresent()) {
            $this$buildArguments_u24lambda_u242.add("-excludeBugs");
            String string = ((RegularFile)task.getBaselineFile().get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            $this$buildArguments_u24lambda_u242.add(string);
        }
        if (task.getOnlyAnalyze().isPresent()) {
            Object object = task.getOnlyAnalyze().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (!((Collection)object).isEmpty()) {
                $this$buildArguments_u24lambda_u242.add("-onlyAnalyze");
                Object object5 = task.getOnlyAnalyze().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                $this$buildArguments_u24lambda_u242.add(CollectionsKt.joinToString$default((Iterable)((Iterable)object5), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
        $this$buildArguments_u24lambda_u242.add("-projectName");
        Object object = task.getProjectName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$buildArguments_u24lambda_u242.add(object);
        $this$buildArguments_u24lambda_u242.add("-release");
        Object object6 = task.getRelease().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        $this$buildArguments_u24lambda_u242.add(object6);
        File file = (File)task.getAnalyseClassFile().getAsFile().get();
        FileCollection fileCollection = task.getClasses();
        if (fileCollection != null) {
            FileCollection it = fileCollection;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)file);
            this.generateFile(it, file);
        }
        $this$buildArguments_u24lambda_u242.add("-analyzeFromFile");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        $this$buildArguments_u24lambda_u242.add(string);
        Object object7 = task.getExtraArgs().getOrElse((Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"getOrElse(...)");
        $this$buildArguments_u24lambda_u242.addAll((Collection)object7);
        this.log.debug("Arguments for SpotBugs are generated: {}", (Object)$this$buildArguments_u24lambda_u242);
        return CollectionsKt.build((List)list);
    }

    private final String createFileForAuxClasspath(SpotBugsTask task) {
        Set set = task.getAuxClassPaths().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        String auxClasspath = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), SpotBugsRunner::createFileForAuxClasspath$lambda$3), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Path auxClasspathFile = (Path)task.getAuxclasspathFile().map(arg_0 -> SpotBugsRunner.createFileForAuxClasspath$lambda$5(SpotBugsRunner::createFileForAuxClasspath$lambda$4, arg_0)).get();
        try {
            Path path = auxClasspathFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Path path2 = path;
            Object object = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
            Intrinsics.checkNotNull((Object)auxClasspathFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(auxClasspathFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(auxClasspathFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            }
            path2 = auxClasspathFile;
            object = auxClasspath;
            byte[] byArray = object.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = byArray;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE};
            Files.write(path2, (byte[])object, Arrays.copyOf(openOptionArray, openOptionArray.length));
            return ((Object)auxClasspathFile.normalize()).toString();
        }
        catch (IOException e) {
            throw new GradleException("Could not create auxiliary classpath file for SpotBugsTask at " + auxClasspathFile.normalize(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void generateFile(FileCollection files, File file) {
        try {
            Object object = file;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                void $this$forEach$iv;
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)files)), (Function1)generateFile.1.1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    writer.write(it.getAbsolutePath());
                    writer.newLine();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (IOException e) {
            throw new GradleException("Fail to generate the text file to list target .class files", (Throwable)e);
        }
    }

    @NotNull
    protected final List<String> buildJvmArguments(@NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        List args = (List)task.getJvmArgs().getOrElse((Object)CollectionsKt.emptyList());
        this.log.debug("Arguments for JVM process are generated: {}", (Object)args);
        Intrinsics.checkNotNull((Object)args);
        return args;
    }

    private final String join(Collection<? extends File> files) {
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)files), SpotBugsRunner::join$lambda$8);
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return SequencesKt.joinToString$default((Sequence)sequence, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    private static final String createFileForAuxClasspath$lambda$3(File obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getAbsolutePath();
    }

    private static final Path createFileForAuxClasspath$lambda$4(RegularFile it) {
        return it.getAsFile().toPath();
    }

    private static final Path createFileForAuxClasspath$lambda$5(Function1 $tmp0, Object in) {
        return (Path)$tmp0.invoke(in);
    }

    private static final String join$lambda$8(File obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getAbsolutePath();
    }
}

