/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsPlugin;
import com.github.spotbugs.snom.SpotBugsTask;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lcom/github/spotbugs/snom/SpotBugsBasePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "createExtension", "Lcom/github/spotbugs/snom/SpotBugsExtension;", "createConfiguration", "extension", "loadProperties", "Ljava/util/Properties;", "createPluginConfiguration", "configs", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "verifyGradleVersion", "version", "Lorg/gradle/util/GradleVersion;", "Companion", "spotbugs-gradle-plugin"})
public final class SpotBugsBasePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FEATURE_FLAG_WORKER_API = "com.github.spotbugs.snom.worker";
    @NotNull
    private static final String DEFAULT_REPORTS_DIR_NAME = "spotbugs";
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"7.1");

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"current(...)");
        this.verifyGradleVersion(gradleVersion);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        SpotBugsExtension extension = this.createExtension(project);
        this.createConfiguration(project, extension);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        this.createPluginConfiguration(configurationContainer);
        String enableWorkerApi = (String)project.getProviders().gradleProperty(FEATURE_FLAG_WORKER_API).getOrElse((Object)"true");
        project.getTasks().withType(SpotBugsTask.class).configureEach(arg_0 -> SpotBugsBasePlugin.apply$lambda$1(arg_0 -> SpotBugsBasePlugin.apply$lambda$0(extension, enableWorkerApi, arg_0), arg_0));
    }

    private final SpotBugsExtension createExtension(Project project) {
        Object object = project.getExtensions().create(DEFAULT_REPORTS_DIR_NAME, SpotBugsExtension.class, new Object[0]);
        SpotBugsExtension $this$createExtension_u24lambda_u246 = (SpotBugsExtension)object;
        boolean bl = false;
        $this$createExtension_u24lambda_u246.getIgnoreFailures().convention((Object)false);
        $this$createExtension_u24lambda_u246.getShowStackTraces().convention((Object)false);
        $this$createExtension_u24lambda_u246.getProjectName().convention(project.provider(() -> SpotBugsBasePlugin.createExtension$lambda$6$lambda$2(project)));
        $this$createExtension_u24lambda_u246.getRelease().convention(project.provider(() -> SpotBugsBasePlugin.createExtension$lambda$6$lambda$3(project)));
        DirectoryProperty baseReportsDir = ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory();
        $this$createExtension_u24lambda_u246.getReportsDir().convention(baseReportsDir.map(arg_0 -> SpotBugsBasePlugin.createExtension$lambda$6$lambda$5(SpotBugsBasePlugin::createExtension$lambda$6$lambda$4, arg_0)));
        $this$createExtension_u24lambda_u246.getUseAuxclasspathFile().convention((Object)true);
        $this$createExtension_u24lambda_u246.getUseJavaToolchains().convention((Object)true);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apply(...)");
        return (SpotBugsExtension)object2;
    }

    private final void createConfiguration(Project project, SpotBugsExtension extension) {
        Properties props = this.loadProperties();
        extension.getToolVersion().convention((Object)props.getProperty("spotbugs-version"));
        ConfigurationContainer configs = project.getConfigurations();
        configs.register(DEFAULT_REPORTS_DIR_NAME, arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$10(arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$9(project, extension, arg_0), arg_0));
        configs.register("spotbugsSlf4j", arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$14(arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$13(project, props, arg_0), arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Properties loadProperties() {
        URL url = SpotBugsPlugin.class.getClassLoader().getResource("spotbugs-gradle-plugin.properties");
        if (url == null) {
            throw new IllegalStateException("spotbugs-gradle-plugin.properties not found".toString());
        }
        try {
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Properties prop = new Properties();
                prop.load(it);
                Properties properties = prop;
                return properties;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final void createPluginConfiguration(ConfigurationContainer configs) {
        configs.register("spotbugsPlugins", arg_0 -> SpotBugsBasePlugin.createPluginConfiguration$lambda$17(SpotBugsBasePlugin::createPluginConfiguration$lambda$16, arg_0));
    }

    public final void verifyGradleVersion(@NotNull GradleVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!(version.compareTo(SUPPORTED_VERSION) >= 0)) {
            boolean bl = false;
            String string = "Gradle version " + version + " is unsupported. Please use " + SUPPORTED_VERSION + " or later.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit apply$lambda$0(SpotBugsExtension $extension, String $enableWorkerApi, SpotBugsTask it) {
        it.init($extension, Boolean.parseBoolean($enableWorkerApi));
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final String createExtension$lambda$6$lambda$2(Project $project) {
        return $project.getName();
    }

    private static final String createExtension$lambda$6$lambda$3(Project $project) {
        return $project.getVersion().toString();
    }

    private static final Directory createExtension$lambda$6$lambda$4(Directory it) {
        return it.dir(DEFAULT_REPORTS_DIR_NAME);
    }

    private static final Directory createExtension$lambda$6$lambda$5(Function1 $tmp0, Object in) {
        return (Directory)$tmp0.invoke(in);
    }

    private static final Unit createConfiguration$lambda$9$lambda$7(Project $project, SpotBugsExtension $extension, DependencySet deps) {
        Dependency dep = $project.getDependencies().create((Object)("com.github.spotbugs:spotbugs:" + (String)$extension.getToolVersion().get()));
        deps.add((Object)dep);
        return Unit.INSTANCE;
    }

    private static final void createConfiguration$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createConfiguration$lambda$9(Project $project, SpotBugsExtension $extension, Configuration it) {
        it.setDescription("configuration for the SpotBugs engine");
        it.setVisible(false);
        it.setTransitive(true);
        it.defaultDependencies(arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$9$lambda$8(arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$9$lambda$7($project, $extension, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void createConfiguration$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createConfiguration$lambda$13$lambda$11(Project $project, Properties $props, DependencySet deps) {
        Dependency dep = $project.getDependencies().create((Object)("org.slf4j:slf4j-simple:" + $props.getProperty("slf4j-version")));
        deps.add((Object)dep);
        return Unit.INSTANCE;
    }

    private static final void createConfiguration$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createConfiguration$lambda$13(Project $project, Properties $props, Configuration it) {
        it.setDescription("configuration for the SLF4J provider to run SpotBugs");
        it.setVisible(false);
        it.setTransitive(true);
        it.defaultDependencies(arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$13$lambda$12(arg_0 -> SpotBugsBasePlugin.createConfiguration$lambda$13$lambda$11($project, $props, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void createConfiguration$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createPluginConfiguration$lambda$16(Configuration it) {
        it.setDescription("configuration for the external SpotBugs plugins");
        it.setVisible(false);
        it.setTransitive(false);
        return Unit.INSTANCE;
    }

    private static final void createPluginConfiguration$lambda$17(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u0012\u0004\b\n\u0010\u0003\u00a8\u0006\f"}, d2={"Lcom/github/spotbugs/snom/SpotBugsBasePlugin$Companion;", "", "<init>", "()V", "FEATURE_FLAG_WORKER_API", "", "DEFAULT_REPORTS_DIR_NAME", "SUPPORTED_VERSION", "Lorg/gradle/util/GradleVersion;", "kotlin.jvm.PlatformType", "getSUPPORTED_VERSION$annotations", "Lorg/gradle/util/GradleVersion;", "spotbugs-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getSUPPORTED_VERSION$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

