/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.OutputScanner;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForHybrid;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid;", "Lcom/github/spotbugs/snom/internal/SpotBugsRunner;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "javaLauncher", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/provider/Property;)V", "run", "", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "Companion", "SpotBugsExecutor", "SpotBugsWorkParameters", "spotbugs-gradle-plugin"})
public final class SpotBugsRunnerForHybrid
extends SpotBugsRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final Property<JavaLauncher> javaLauncher;
    private static final int MISSING_CLASS_FLAG = 2;

    public SpotBugsRunnerForHybrid(@NotNull WorkerExecutor workerExecutor, @NotNull Property<JavaLauncher> javaLauncher) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter(javaLauncher, (String)"javaLauncher");
        this.workerExecutor = workerExecutor;
        this.javaLauncher = javaLauncher;
    }

    @Override
    public void run(@NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        this.workerExecutor.noIsolation().submit(SpotBugsExecutor.class, arg_0 -> SpotBugsRunnerForHybrid.run$lambda$0((Function1)new Function1<SpotBugsWorkParameters, Unit>(this, task){
            final /* synthetic */ SpotBugsRunnerForHybrid this$0;
            final /* synthetic */ SpotBugsTask $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(SpotBugsWorkParameters it) {
                void $this$forEach$iv;
                List args = new ArrayList<E>();
                args.add("-exitcode");
                args.addAll((Collection)this.this$0.buildArguments(this.$task));
                it.getClasspath().setFrom((Iterable)this.$task.getSpotbugsClasspath());
                it.getJvmArgs().set((Iterable)this.this$0.buildJvmArguments(this.$task));
                it.getArgs().set((Iterable)args);
                String maxHeapSize = (String)this.$task.getMaxHeapSize().getOrNull();
                if (maxHeapSize != null) {
                    it.getMaxHeapSize().set((Object)maxHeapSize);
                }
                it.getIgnoreFailures().set((Object)this.$task.getIgnoreFailures());
                it.getShowStackTraces().set((Provider)this.$task.getShowStackTraces());
                Sequence sequence = SequencesKt.map(this.$task.getRequiredReports$spotbugs_gradle_plugin(), (Function1)run.1.INSTANCE);
                ListProperty<RegularFile> listProperty = it.getReports();
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Provider p0 = (Provider)element$iv;
                    boolean bl = false;
                    listProperty.add(p0);
                }
                if (SpotBugsRunnerForHybrid.access$getJavaLauncher$p(this.this$0).isPresent()) {
                    it.getJavaToolchainExecutablePath().set((Object)((JavaLauncher)SpotBugsRunnerForHybrid.access$getJavaLauncher$p(this.this$0).get()).getExecutablePath().getAsFile().getAbsolutePath());
                }
            }
        }, arg_0));
    }

    private static final void run$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Property access$getJavaLauncher$p(SpotBugsRunnerForHybrid $this) {
        return $this.javaLauncher;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$Companion;", "", "()V", "MISSING_CLASS_FLAG", "", "getMISSING_CLASS_FLAG$annotations", "spotbugs-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getMISSING_CLASS_FLAG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$SpotBugsExecutor;", "Lorg/gradle/workers/WorkAction;", "Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$SpotBugsWorkParameters;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/process/ExecOperations;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "stderrOutputScanner", "Lcom/github/spotbugs/snom/internal/OutputScanner;", "configureJavaExec", "Lorg/gradle/api/Action;", "Lorg/gradle/process/JavaExecSpec;", "params", "execute", "", "ignoreMissingClassFlag", "", "exitValue", "spotbugs-gradle-plugin"})
    public static abstract class SpotBugsExecutor
    implements WorkAction<SpotBugsWorkParameters> {
        @NotNull
        private final ExecOperations execOperations;
        private final Logger log;
        private OutputScanner stderrOutputScanner;

        @Inject
        public SpotBugsExecutor(@NotNull ExecOperations execOperations) {
            Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
            this.execOperations = execOperations;
            this.log = LoggerFactory.getLogger(this.getClass());
        }

        public void execute() {
            StringBuilder stringBuilder;
            WorkParameters workParameters = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)workParameters, (String)"getParameters(...)");
            int exitValue = this.execOperations.javaexec(this.configureJavaExec((SpotBugsWorkParameters)workParameters)).rethrowFailure().getExitValue();
            Boolean ignoreFailures = (Boolean)((SpotBugsWorkParameters)this.getParameters()).getIgnoreFailures().getOrElse((Object)false);
            if (this.ignoreMissingClassFlag(exitValue) == 0) {
                OutputScanner outputScanner = this.stderrOutputScanner;
                if (outputScanner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stderrOutputScanner");
                    outputScanner = null;
                }
                if (outputScanner.isFailedToReport() && !ignoreFailures.booleanValue()) {
                    throw new GradleException("SpotBugs analysis succeeded but report generation failed");
                }
                return;
            }
            Intrinsics.checkNotNull((Object)ignoreFailures);
            if (ignoreFailures.booleanValue()) {
                this.log.warn("SpotBugs ended with exit code " + exitValue);
                return;
            }
            StringBuilder $this$execute_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$execute_u24lambda_u240.append("Verification failed: SpotBugs ended with exit code " + exitValue + '.');
            Object object = ((SpotBugsWorkParameters)this.getParameters()).getReports().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            List reportPaths2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)execute.errorMessage.1.reportPaths.1.INSTANCE), (Function1)execute.errorMessage.1.reportPaths.2.INSTANCE), (Function1)execute.errorMessage.1.reportPaths.3.INSTANCE), (Function1)execute.errorMessage.1.reportPaths.4.INSTANCE));
            if (!((Collection)reportPaths2).isEmpty()) {
                $this$execute_u24lambda_u240.append(" See the report at: ");
                $this$execute_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)reportPaths2, null, null, null, (int)0, null, null, (int)63, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String errorMessage2 = string;
            throw new GradleException(errorMessage2);
        }

        private final int ignoreMissingClassFlag(int exitValue) {
            if ((exitValue & 2) == 0) {
                return exitValue;
            }
            this.log.debug("MISSING_CLASS_FLAG (2) was set to the exit code, but ignore it to keep the task result stable.");
            return exitValue ^ 2;
        }

        private final Action<JavaExecSpec> configureJavaExec(SpotBugsWorkParameters params) {
            return arg_0 -> SpotBugsExecutor.configureJavaExec$lambda$1(params, this, arg_0);
        }

        private static final void configureJavaExec$lambda$1(SpotBugsWorkParameters $params, SpotBugsExecutor this$0, JavaExecSpec it) {
            Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            it.setJvmArgs((List)$params.getJvmArgs().get());
            Object[] objectArray = new Object[]{$params.getClasspath()};
            it.classpath(objectArray);
            it.setArgs((List)$params.getArgs().get());
            it.getMainClass().set((Object)"edu.umd.cs.findbugs.FindBugs2");
            String maxHeapSize = (String)$params.getMaxHeapSize().getOrNull();
            if (maxHeapSize != null) {
                it.setMaxHeapSize(maxHeapSize);
            }
            if ($params.getJavaToolchainExecutablePath().isPresent()) {
                this$0.log.info("Spotbugs will be executed using Java Toolchain configuration: {}", $params.getJavaToolchainExecutablePath().get());
                it.setExecutable((String)$params.getJavaToolchainExecutablePath().get());
            }
            it.setIgnoreExitValue(true);
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
            this$0.stderrOutputScanner = new OutputScanner(printStream);
            OutputScanner outputScanner = this$0.stderrOutputScanner;
            if (outputScanner == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stderrOutputScanner");
                outputScanner = null;
            }
            it.setErrorOutput((OutputStream)outputScanner);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\b\u0010\u0005\u001a\u00020\u0006H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\bH&J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\bH&J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H&J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bH&\u00a8\u0006\u0010"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForHybrid$SpotBugsWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "getArgs", "Lorg/gradle/api/provider/ListProperty;", "", "getClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getIgnoreFailures", "Lorg/gradle/api/provider/Property;", "", "getJavaToolchainExecutablePath", "getJvmArgs", "getMaxHeapSize", "getReports", "Lorg/gradle/api/file/RegularFile;", "getShowStackTraces", "spotbugs-gradle-plugin"})
    public static interface SpotBugsWorkParameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getClasspath();

        @NotNull
        public Property<String> getMaxHeapSize();

        @NotNull
        public ListProperty<String> getArgs();

        @NotNull
        public ListProperty<String> getJvmArgs();

        @NotNull
        public Property<Boolean> getIgnoreFailures();

        @NotNull
        public Property<Boolean> getShowStackTraces();

        @NotNull
        public Property<String> getJavaToolchainExecutablePath();

        @NotNull
        public ListProperty<RegularFile> getReports();
    }
}

