/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpotBugsRunnerForWorker
extends SpotBugsRunner {
    private final Logger log = LoggerFactory.getLogger(SpotBugsRunnerForWorker.class);
    private final WorkerExecutor workerExecutor;
    private final Property<JavaLauncher> javaLauncher;

    public SpotBugsRunnerForWorker(@NonNull WorkerExecutor workerExecutor, Property<JavaLauncher> javaLauncher) {
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
        this.javaLauncher = javaLauncher;
    }

    @Override
    public void run(@NonNull SpotBugsTask task) {
        Objects.requireNonNull(task);
        WorkQueue workerQueue = this.workerExecutor.processIsolation(this.configureWorkerSpec(task));
        workerQueue.submit(SpotBugsExecutor.class, this.configureWorkParameters(task));
    }

    private Action<ProcessWorkerSpec> configureWorkerSpec(SpotBugsTask task) {
        return spec -> {
            spec.getClasspath().setFrom((Iterable)task.getSpotbugsClasspath());
            spec.forkOptions(option -> {
                option.jvmArgs(this.buildJvmArguments(task));
                String maxHeapSize = (String)task.getMaxHeapSize().getOrNull();
                if (maxHeapSize != null) {
                    option.setMaxHeapSize(maxHeapSize);
                }
                if (this.javaLauncher.isPresent()) {
                    this.log.info("Spotbugs will be executed using Java Toolchain configuration: Vendor: {} | Version: {}", (Object)((JavaLauncher)this.javaLauncher.get()).getMetadata().getVendor(), (Object)((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().asInt());
                    option.setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
                }
            });
        };
    }

    private Action<SpotBugsWorkParameters> configureWorkParameters(SpotBugsTask task) {
        return params -> {
            params.getArguments().addAll(this.buildArguments(task));
            params.getIgnoreFailures().set((Object)task.getIgnoreFailures());
            params.getShowStackTraces().set((Object)task.getShowStackTraces());
            task.getEnabledReports().stream().map(SpotBugsReport::getOutputLocation).forEach(arg_0 -> params.getReports().add(arg_0));
        };
    }

    public static abstract class SpotBugsExecutor
    implements WorkAction<SpotBugsWorkParameters> {
        private final Logger log = LoggerFactory.getLogger(SpotBugsExecutor.class);

        public void execute() {
            block14: {
                SpotBugsWorkParameters params = (SpotBugsWorkParameters)this.getParameters();
                String[] args = ((List)params.getArguments().get()).toArray(new String[0]);
                DetectorFactoryCollection.resetInstance((DetectorFactoryCollection)new DetectorFactoryCollection());
                try {
                    Version.printVersion((boolean)false);
                    try (FindBugs2 findBugs2 = new FindBugs2();){
                        TextUICommandLine commandLine = new TextUICommandLine();
                        FindBugs.processCommandLine((TextUICommandLine)commandLine, (String[])args, (IFindBugsEngine)findBugs2);
                        findBugs2.execute();
                        StringBuilder message = new StringBuilder();
                        if (findBugs2.getErrorCount() > 0) {
                            message.append(findBugs2.getErrorCount()).append(" SpotBugs errors were found.");
                        }
                        if (findBugs2.getBugCount() > 0) {
                            if (message.length() > 0) {
                                message.append(' ');
                            }
                            message.append(findBugs2.getBugCount()).append(" SpotBugs violations were found.");
                        }
                        if (message.length() <= 0) break block14;
                        List reportPaths = ((List)params.getReports().get()).stream().map(RegularFile::getAsFile).map(File::toPath).map(Path::toUri).map(URI::toString).collect(Collectors.toList());
                        if (!reportPaths.isEmpty()) {
                            message.append("See the report at: ").append(String.join((CharSequence)", ", reportPaths));
                        }
                        GradleException e = new GradleException(message.toString());
                        if (((Boolean)params.getIgnoreFailures().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                            this.log.warn(message.toString());
                            if (((Boolean)params.getShowStackTraces().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                                this.log.warn("", (Throwable)e);
                            }
                            break block14;
                        }
                        throw e;
                    }
                }
                catch (GradleException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new GradleException("Verification failed: SpotBugs execution thrown exception", (Throwable)e);
                }
            }
        }
    }

    static interface SpotBugsWorkParameters
    extends WorkParameters {
        public ListProperty<String> getArguments();

        public Property<Boolean> getIgnoreFailures();

        public Property<Boolean> getShowStackTraces();

        public ListProperty<RegularFile> getReports();
    }
}

