/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.SpotBugsTask;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Closure;
import java.io.File;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.CustomizableHtmlReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public abstract class SpotBugsReport
implements SingleFileReport,
CustomizableHtmlReport {
    private final RegularFileProperty destination;
    private final Property<Boolean> isRequired;
    private final SpotBugsTask task;

    @Inject
    public SpotBugsReport(ObjectFactory objects, SpotBugsTask task) {
        this.destination = objects.fileProperty();
        this.isRequired = objects.property(Boolean.class).convention((Object)Boolean.TRUE);
        this.task = task;
    }

    @NonNull
    public abstract String toCommandLineOption();

    @Deprecated
    @Internal
    public File getDestination() {
        return ((RegularFile)this.destination.get()).getAsFile();
    }

    public RegularFileProperty getOutputLocation() {
        return this.destination;
    }

    @Internal(value="This property returns always same value")
    public Report.OutputType getOutputType() {
        return Report.OutputType.FILE;
    }

    @Input
    public Property<Boolean> getRequired() {
        return this.isRequired;
    }

    @Deprecated
    @Internal
    public boolean isEnabled() {
        return (Boolean)this.isRequired.get();
    }

    @Deprecated
    public void setEnabled(boolean b) {
        this.isRequired.set((Object)b);
    }

    @Deprecated
    public void setEnabled(Provider<Boolean> provider) {
        this.isRequired.set(provider);
    }

    @Deprecated
    public void setDestination(File file) {
        this.destination.set(file);
    }

    @Deprecated
    public void setDestination(Provider<File> provider) {
        this.destination.set(this.task.getProject().getLayout().file(provider));
    }

    public Report configure(Closure closure) {
        return this.configure((Action<? super Report>)((Action)report -> {
            closure.setDelegate(report);
            closure.call(report);
        }));
    }

    public Report configure(Action<? super Report> action) {
        action.execute((Object)this);
        return this;
    }

    @Internal(value="This property provides only a human readable name.")
    public String getDisplayName() {
        return String.format("%s type report generated by the task %s", this.getName(), this.getTask().getPath());
    }

    @CheckForNull
    public TextResource getStylesheet() {
        return null;
    }

    public void setStylesheet(@Nullable TextResource textResource) {
        throw new UnsupportedOperationException(String.format("stylesheet property is not available in the %s type report", this.getName()));
    }

    public void setStylesheet(@Nullable String path) {
        throw new UnsupportedOperationException(String.format("stylesheet property is not available in the %s type report", this.getName()));
    }

    @Internal
    @NonNull
    protected final SpotBugsTask getTask() {
        return this.task;
    }
}

