/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.github.spotbugs.snom.SpotBugsTask;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotBugsTaskFactory {
    private final Logger log = LoggerFactory.getLogger(SpotBugsTaskFactory.class);

    public void generate(Project project) {
        this.generateForJava(project);
        this.generateForAndroid(project);
    }

    private SourceSetContainer getSourceSetContainer(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) < 0) {
            return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        }
        return ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
    }

    private void generateForJava(Project project) {
        project.getPlugins().withType(JavaBasePlugin.class).configureEach(javaBasePlugin -> this.getSourceSetContainer(project).all(sourceSet -> {
            String name = sourceSet.getTaskName("spotbugs", null);
            this.log.debug("Creating SpotBugsTask for {}", sourceSet);
            project.getTasks().register(name, SpotBugsTask.class, task -> {
                task.setSourceDirs(sourceSet.getAllSource().getSourceDirectories());
                task.setClassDirs((FileCollection)sourceSet.getOutput());
                task.setAuxClassPaths(sourceSet.getCompileClasspath());
                String description = String.format("Run SpotBugs analysis for the source set '%s'", sourceSet.getName());
                task.setDescription(description);
            });
        }));
    }

    static String toLowerCamelCase(String head, String tail) {
        if (tail == null || tail.isEmpty()) {
            return head;
        }
        StringBuilder builder = new StringBuilder(head.length() + tail.length());
        builder.append(head).append(Character.toUpperCase(tail.charAt(0))).append(tail.substring(1));
        return builder.toString();
    }

    private void generateForAndroid(Project project) {
        Action action = plugin -> {
            DomainObjectSet variants;
            BaseExtension baseExtension = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
            if (baseExtension instanceof AppExtension) {
                variants = ((AppExtension)baseExtension).getApplicationVariants();
            } else if (baseExtension instanceof LibraryExtension) {
                variants = ((LibraryExtension)baseExtension).getLibraryVariants();
            } else {
                throw new GradleException("Unrecognized Android extension " + baseExtension);
            }
            variants.all(variant -> {
                String spotbugsTaskName = SpotBugsTaskFactory.toLowerCamelCase("spotbugs", variant.getName());
                this.log.debug("Creating SpotBugsTask for {}", (Object)variant.getName());
                project.getTasks().register(spotbugsTaskName, SpotBugsTask.class, spotbugsTask -> {
                    JavaCompile javaCompile = (JavaCompile)variant.getJavaCompileProvider().get();
                    spotbugsTask.setSourceDirs((FileCollection)javaCompile.getSource());
                    spotbugsTask.setClassDirs((FileCollection)project.files(new Object[]{javaCompile.getDestinationDir()}));
                    spotbugsTask.setAuxClassPaths(javaCompile.getClasspath());
                    spotbugsTask.dependsOn(new Object[]{javaCompile});
                });
            });
        };
        project.getPlugins().withId("com.android.application", action);
        project.getPlugins().withId("com.android.library", action);
    }
}

