/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.TextResource;

public abstract class SpotBugsHtmlReport
extends SpotBugsReport {
    private final Property<TextResource> stylesheet;
    private final Property<String> stylesheetPath;

    @Inject
    public SpotBugsHtmlReport(ObjectFactory objects, SpotBugsTask task) {
        super(objects, task);
        this.getOutputLocation().convention(task.getReportsDir().file(task.getBaseName() + ".html"));
        this.stylesheet = objects.property(TextResource.class);
        this.stylesheetPath = objects.property(String.class);
    }

    @Override
    @NonNull
    public String toCommandLineOption() {
        TextResource stylesheet = this.getStylesheet();
        if (stylesheet == null) {
            return "-html";
        }
        return "-html:" + stylesheet.asFile().getAbsolutePath();
    }

    @Override
    public TextResource getStylesheet() {
        if (this.stylesheet.isPresent()) {
            return (TextResource)this.stylesheet.get();
        }
        if (this.stylesheetPath.isPresent()) {
            return this.resolve((String)this.stylesheetPath.get());
        }
        return null;
    }

    private TextResource resolve(String path) {
        Optional spotbugsJar = this.getTask().getProject().getConfigurations().getByName("spotbugs").files(dependency -> dependency.getGroup().equals("com.github.spotbugs") && dependency.getName().equals("spotbugs")).stream().findFirst();
        if (spotbugsJar.isPresent()) {
            return this.getTask().getProject().getResources().getText().fromArchiveEntry(spotbugsJar.get(), path);
        }
        throw new InvalidUserDataException("The dependency on SpotBugs not found in 'spotbugs' configuration");
    }

    @Override
    public void setStylesheet(@Nullable TextResource textResource) {
        this.stylesheet.set((Object)textResource);
    }

    @Override
    public void setStylesheet(@Nullable String path) {
        this.stylesheetPath.set((Object)path);
    }
}

