/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotBugsRunnerForWorker
extends SpotBugsRunner {
    private final WorkerExecutor workerExecutor;

    public SpotBugsRunnerForWorker(@NonNull WorkerExecutor workerExecutor) {
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
    }

    @Override
    public void run(@NonNull SpotBugsTask task) {
        Objects.requireNonNull(task);
        WorkQueue workerQueue = this.workerExecutor.processIsolation(this.configureWorkerSpec(task));
        workerQueue.submit(SpotBugsExecutor.class, this.configureWorkParameters(task));
    }

    private Action<ProcessWorkerSpec> configureWorkerSpec(SpotBugsTask task) {
        return spec -> {
            spec.getClasspath().setFrom((Iterable)task.getSpotbugsClasspath());
            spec.forkOptions(option -> {
                option.jvmArgs(this.buildJvmArguments(task));
                String maxHeapSize = (String)task.getMaxHeapSize().getOrNull();
                if (maxHeapSize != null) {
                    option.setMaxHeapSize(maxHeapSize);
                }
            });
        };
    }

    private Action<SpotBugsWorkParameters> configureWorkParameters(SpotBugsTask task) {
        return params -> {
            params.getArguments().addAll(this.buildArguments(task));
            params.getIgnoreFailures().set((Object)task.getIgnoreFailures());
            params.getShowStackTraces().set((Object)task.getShowStackTraces());
        };
    }

    public static abstract class SpotBugsExecutor
    implements WorkAction<SpotBugsWorkParameters> {
        private final Logger log = LoggerFactory.getLogger(SpotBugsExecutor.class);

        public void execute() {
            block14: {
                SpotBugsWorkParameters params = (SpotBugsWorkParameters)this.getParameters();
                String[] args = ((List)params.getArguments().get()).toArray(new String[0]);
                DetectorFactoryCollection.resetInstance((DetectorFactoryCollection)new DetectorFactoryCollection());
                try {
                    Version.printVersion((boolean)false);
                    try (FindBugs2 findBugs2 = new FindBugs2();){
                        TextUICommandLine commandLine = new TextUICommandLine();
                        FindBugs.processCommandLine((TextUICommandLine)commandLine, (String[])args, (IFindBugsEngine)findBugs2);
                        findBugs2.execute();
                        StringBuilder message = new StringBuilder();
                        if (findBugs2.getErrorCount() > 0) {
                            message.append(findBugs2.getErrorCount()).append(" SpotBugs errors were found.");
                        }
                        if (findBugs2.getBugCount() > 0) {
                            if (message.length() > 0) {
                                message.append(' ');
                            }
                            message.append(findBugs2.getBugCount()).append(" SpotBugs violations were found.");
                        }
                        if (message.length() <= 0) break block14;
                        String reportPath = this.findReportPath();
                        if (reportPath != null) {
                            message.append(" See the report at: ").append(Paths.get(reportPath, new String[0]).toUri());
                        }
                        GradleException e = new GradleException(message.toString());
                        if (((Boolean)params.getIgnoreFailures().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                            this.log.warn(message.toString());
                            if (((Boolean)params.getShowStackTraces().getOrElse((Object)Boolean.TRUE)).booleanValue()) {
                                this.log.warn("", (Throwable)e);
                            }
                            break block14;
                        }
                        throw e;
                    }
                }
                catch (GradleException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new GradleException("Verification failed: SpotBugs execution thrown exception", (Throwable)e);
                }
            }
        }

        @CheckForNull
        private String findReportPath() {
            List arguments = (List)((SpotBugsWorkParameters)this.getParameters()).getArguments().get();
            int outputFileParameterIndex = arguments.indexOf("-outputFile");
            if (outputFileParameterIndex > 0) {
                return (String)arguments.get(outputFileParameterIndex + 1);
            }
            return null;
        }
    }

    static interface SpotBugsWorkParameters
    extends WorkParameters {
        public ListProperty<String> getArguments();

        public Property<Boolean> getIgnoreFailures();

        public Property<Boolean> getShowStackTraces();
    }
}

