/*
 * Decompiled with CFR 0.152.
 */
package net.soroushjavdan.customfontwidgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.CheckBox;
import net.soroushjavdan.customfontwidgets.FontUtils;
import net.soroushjavdan.customfontwidgets.R;

public class CCheckBox
extends CheckBox {
    public CCheckBox(Context context) {
        super(context);
        this.setDefaultFont();
    }

    public CCheckBox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.readAttrs(context, attrs);
    }

    public CCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.readAttrs(context, attrs);
    }

    private void readAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CCheckBox);
        String customFont = a.getString(R.styleable.CButton_customFont);
        if (FontUtils.getFontsMap().containsKey(customFont)) {
            this.setTypeface(FontUtils.getFontsMap().get(customFont));
        } else {
            this.setDefaultFont();
        }
    }

    private void setDefaultFont() {
        if (FontUtils.getDefaultFont() != null) {
            this.setTypeface(FontUtils.getDefaultFont());
        }
    }
}

