/*
 * Decompiled with CFR 0.152.
 */
package net.soroushjavdan.customfontwidgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.Button;
import net.soroushjavdan.customfontwidgets.FontUtils;
import net.soroushjavdan.customfontwidgets.R;

public class CButton
extends Button {
    public CButton(Context context) {
        super(context);
        this.setDefaultFont();
    }

    public CButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.readAttrs(context, attrs);
        }
    }

    public CButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.readAttrs(context, attrs);
        }
    }

    private void readAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CButton);
        String customFont = a.getString(R.styleable.CButton_customFont);
        if (FontUtils.getFontsMap().containsKey(customFont)) {
            this.setTypeface(FontUtils.getFontsMap().get(customFont));
        } else {
            this.setDefaultFont();
        }
    }

    private void setDefaultFont() {
        if (FontUtils.getDefaultFont() != null) {
            this.setTypeface(FontUtils.getDefaultFont());
        }
    }
}

