/*
 * Decompiled with CFR 0.152.
 */
package com.sophoun.utils.billing;

import android.util.Base64;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sophoun/utils/billing/GooglePlayBillingSecurity;", "", "()V", "KEY_FACTORY_ALGORITHM", "", "SIGNATURE_ALGORITHM", "generatePublicKey", "Ljava/security/PublicKey;", "encodedPublicKey", "verify", "", "publicKey", "signedData", "signature", "verifyPurchase", "base64PublicKey", "library_release"})
public final class GooglePlayBillingSecurity {
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final GooglePlayBillingSecurity INSTANCE;

    public final boolean verifyPurchase(@Nullable String base64PublicKey, @NotNull String signedData, @Nullable String signature) {
        Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
        PublicKey key = this.generatePublicKey(base64PublicKey);
        return this.verify(key, signedData, signature);
    }

    private final PublicKey generatePublicKey(String encodedPublicKey) {
        PublicKey publicKey;
        try {
            byte[] byArray = Base64.decode((String)encodedPublicKey, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(encodedPublicKey, Base64.DEFAULT)");
            byte[] decodedKey = byArray;
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (Exception e) {
            publicKey = null;
        }
        return publicKey;
    }

    private final boolean verify(PublicKey publicKey, String signedData, String signature) {
        boolean bl;
        Signature sig = null;
        try {
            Signature signature2 = Signature.getInstance(SIGNATURE_ALGORITHM);
            Intrinsics.checkExpressionValueIsNotNull((Object)signature2, (String)"Signature.getInstance(SIGNATURE_ALGORITHM)");
            sig = signature2;
            sig.initVerify(publicKey);
            String string = signedData;
            Signature signature3 = sig;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            signature3.update(byArray2);
            bl = sig.verify(Base64.decode((String)signature, (int)0));
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private GooglePlayBillingSecurity() {
    }

    static {
        GooglePlayBillingSecurity googlePlayBillingSecurity;
        INSTANCE = googlePlayBillingSecurity = new GooglePlayBillingSecurity();
    }
}

