/*
 * Decompiled with CFR 0.152.
 */
package com.sophoun.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J9\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\b0\u000e\u00a8\u0006\u0013"}, d2={"Lcom/sophoun/utils/NetworkUtils;", "", "()V", "isNetworkConnected", "", "context", "Landroid/content/Context;", "saveResponseBodyToFile", "", "filePath", "", "responseBody", "Lokhttp3/ResponseBody;", "progress", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "percent", "library_release"})
public final class NetworkUtils {
    public static final NetworkUtils INSTANCE;

    public final boolean isNetworkConnected(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager networkService = (ConnectivityManager)object;
        NetworkInfo networkInfo = networkService.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public final void saveResponseBodyToFile(@NotNull String filePath, @NotNull ResponseBody responseBody, @NotNull Function1<? super Long, Unit> progress) {
        int byteRead;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)responseBody, (String)"responseBody");
        Intrinsics.checkParameterIsNotNull(progress, (String)"progress");
        ResponseBody responseBody2 = responseBody;
        boolean bl = false;
        boolean bl2 = false;
        ResponseBody body = responseBody2;
        boolean bl3 = false;
        File file = new File(filePath);
        boolean bl4 = false;
        boolean bl5 = false;
        File file2 = file;
        boolean bl6 = false;
        FileOutputStream outputStream = new FileOutputStream(file2);
        BufferedSource bufferedSource = body.source();
        boolean bl7 = false;
        boolean bl8 = false;
        BufferedSource it = bufferedSource;
        boolean bl9 = false;
        byte[] buffer = new byte[4096];
        long totalBytesRead = 0L;
        while ((byteRead = it.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, byteRead);
            long percent = (totalBytesRead += (long)byteRead) * (long)100 / body.contentLength();
            progress.invoke((Object)percent);
        }
        outputStream.flush();
        outputStream.close();
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
    }
}

