/*
 * Decompiled with CFR 0.152.
 */
package com.sophoun.utils;

import android.content.Context;
import androidx.biometric.BiometricPrompt;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.sophoun.utils.DLog;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012Jo\u0010\u0013\u001a\u00020\u000e26\u0010\u0014\u001a2\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u000e0\u001fJ>\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020$2\b\b\u0002\u0010'\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020$2\b\b\u0002\u0010)\u001a\u00020\u0012R\u000e\u0010\b\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/sophoun/utils/BiometricManager;", "", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "activity", "biometricPrompt", "Landroidx/biometric/BiometricPrompt;", "promptInfo", "Landroidx/biometric/BiometricPrompt$PromptInfo;", "authenticate", "", "getContext", "Landroid/content/Context;", "isAvailable", "", "setBiometricCallback", "onAuthenticationError", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "errorCode", "", "errString", "onAuthenticationFailed", "Lkotlin/Function0;", "onAuthenticationSucceeded", "Lkotlin/Function1;", "Landroidx/biometric/BiometricPrompt$AuthenticationResult;", "result", "setPromptInfo", "title", "", "description", "subtitle", "credentialAllowed", "negativeButtonText", "confirmationRequired", "library_release"})
public final class BiometricManager {
    private BiometricPrompt biometricPrompt;
    private BiometricPrompt.PromptInfo promptInfo;
    private FragmentActivity activity;
    private Fragment fragment;

    private final Context getContext() {
        if (this.activity != null) {
            FragmentActivity fragmentActivity = this.activity;
            if (fragmentActivity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
            }
            Context context = fragmentActivity.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"activity.applicationContext");
            return context;
        }
        if (this.fragment != null) {
            Fragment fragment = this.fragment;
            if (fragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fragment");
            }
            Context context = fragment.requireContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"fragment.requireContext()");
            return context;
        }
        throw (Throwable)new Exception("No context provided.");
    }

    public final boolean isAvailable() {
        boolean returnFlag = false;
        androidx.biometric.BiometricManager biometricManager = androidx.biometric.BiometricManager.from((Context)this.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)biometricManager, (String)"BiometricManager.from(getContext())");
        androidx.biometric.BiometricManager biometricManager2 = biometricManager;
        switch (biometricManager2.canAuthenticate()) {
            case 1: {
                DLog.INSTANCE.i("BiometricManager: BIOMETRIC_ERROR_HW_UNAVAILABLE", new Object[0]);
                returnFlag = false;
                break;
            }
            case 11: {
                DLog.INSTANCE.i("BiometricManager: BIOMETRIC_ERROR_NONE_ENROLLED", new Object[0]);
                returnFlag = false;
                break;
            }
            case 12: {
                DLog.INSTANCE.i("BiometricManager: BIOMETRIC_ERROR_NO_HARDWARE", new Object[0]);
                returnFlag = false;
                break;
            }
            case 0: {
                DLog.INSTANCE.i("BiometricManager: BIOMETRIC_SUCCESS", new Object[0]);
                returnFlag = true;
                break;
            }
        }
        return returnFlag;
    }

    public final void setBiometricCallback(@NotNull Function2<? super Integer, ? super CharSequence, Unit> onAuthenticationError, @NotNull Function0<Unit> onAuthenticationFailed, @NotNull Function1<? super BiometricPrompt.AuthenticationResult, Unit> onAuthenticationSucceeded) {
        BiometricPrompt biometricPrompt;
        Intrinsics.checkParameterIsNotNull(onAuthenticationError, (String)"onAuthenticationError");
        Intrinsics.checkParameterIsNotNull(onAuthenticationFailed, (String)"onAuthenticationFailed");
        Intrinsics.checkParameterIsNotNull(onAuthenticationSucceeded, (String)"onAuthenticationSucceeded");
        BiometricPrompt.AuthenticationCallback authenticationCallback2 = new BiometricPrompt.AuthenticationCallback(onAuthenticationError, onAuthenticationFailed, onAuthenticationSucceeded){
            final /* synthetic */ Function2 $onAuthenticationError;
            final /* synthetic */ Function0 $onAuthenticationFailed;
            final /* synthetic */ Function1 $onAuthenticationSucceeded;

            public void onAuthenticationError(int errorCode, @NotNull CharSequence errString) {
                Intrinsics.checkParameterIsNotNull((Object)errString, (String)"errString");
                super.onAuthenticationError(errorCode, errString);
                DLog.INSTANCE.i("BiometricManager: onAuthenticationError", new Object[0]);
                this.$onAuthenticationError.invoke((Object)errorCode, (Object)errString);
            }

            public void onAuthenticationFailed() {
                super.onAuthenticationFailed();
                DLog.INSTANCE.i("BiometricManager: onAuthenticationFailed", new Object[0]);
                this.$onAuthenticationFailed.invoke();
            }

            public void onAuthenticationSucceeded(@NotNull BiometricPrompt.AuthenticationResult result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                super.onAuthenticationSucceeded(result);
                DLog.INSTANCE.i("BiometricManager: onAuthenticationSucceeded", new Object[0]);
                this.$onAuthenticationSucceeded.invoke((Object)result);
            }
            {
                this.$onAuthenticationError = $captured_local_variable$0;
                this.$onAuthenticationFailed = $captured_local_variable$1;
                this.$onAuthenticationSucceeded = $captured_local_variable$2;
            }
        };
        if (this.fragment != null) {
            Fragment fragment = this.fragment;
            if (fragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fragment");
            }
            biometricPrompt = new BiometricPrompt(fragment, ContextCompat.getMainExecutor((Context)this.getContext()), authenticationCallback2);
        } else if (this.activity != null) {
            Fragment fragment = this.fragment;
            if (fragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fragment");
            }
            biometricPrompt = new BiometricPrompt(fragment, ContextCompat.getMainExecutor((Context)this.getContext()), authenticationCallback2);
        } else {
            throw (Throwable)new Exception("Activity or Fragment isn't initialized yet.");
        }
        this.biometricPrompt = biometricPrompt;
    }

    public final void setPromptInfo(@NotNull String title, @NotNull String description, @NotNull String subtitle, boolean credentialAllowed, @NotNull String negativeButtonText, boolean confirmationRequired) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)subtitle, (String)"subtitle");
        Intrinsics.checkParameterIsNotNull((Object)negativeButtonText, (String)"negativeButtonText");
        BiometricPrompt.PromptInfo.Builder builder = new BiometricPrompt.PromptInfo.Builder().setTitle((CharSequence)title).setDescription((CharSequence)description).setDeviceCredentialAllowed(credentialAllowed).setConfirmationRequired(confirmationRequired);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"PromptInfo.Builder()\n   \u2026red(confirmationRequired)");
        BiometricPrompt.PromptInfo.Builder promptInfoBuilder = builder;
        CharSequence charSequence = subtitle;
        boolean bl = false;
        if (charSequence.length() > 0) {
            promptInfoBuilder.setSubtitle((CharSequence)subtitle);
        }
        if (!credentialAllowed) {
            promptInfoBuilder.setNegativeButtonText((CharSequence)negativeButtonText);
        }
        BiometricPrompt.PromptInfo promptInfo = promptInfoBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)promptInfo, (String)"promptInfoBuilder.build()");
        this.promptInfo = promptInfo;
    }

    public static /* synthetic */ void setPromptInfo$default(BiometricManager biometricManager, String string, String string2, String string3, boolean bl, String string4, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string4 = "Cancel";
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        biometricManager.setPromptInfo(string, string2, string3, bl, string4, bl2);
    }

    public final void authenticate() {
        if (this.promptInfo == null) {
            throw (Throwable)new Exception("PromptInfo is not initialized yet.");
        }
        if (this.biometricPrompt == null) {
            throw (Throwable)new Exception("BiometricPrompt is not initialized yet.");
        }
        BiometricPrompt biometricPrompt = this.biometricPrompt;
        if (biometricPrompt == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"biometricPrompt");
        }
        BiometricPrompt.PromptInfo promptInfo = this.promptInfo;
        if (promptInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"promptInfo");
        }
        biometricPrompt.authenticate(promptInfo);
    }

    public BiometricManager(@NotNull FragmentActivity fragmentActivity) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentActivity, (String)"fragmentActivity");
        this.activity = fragmentActivity;
    }

    public BiometricManager(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        this.fragment = fragment;
    }

    public static final /* synthetic */ FragmentActivity access$getActivity$p(BiometricManager $this) {
        FragmentActivity fragmentActivity = $this.activity;
        if (fragmentActivity == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
        }
        return fragmentActivity;
    }

    public static final /* synthetic */ void access$setActivity$p(BiometricManager $this, FragmentActivity fragmentActivity) {
        $this.activity = fragmentActivity;
    }

    public static final /* synthetic */ Fragment access$getFragment$p(BiometricManager $this) {
        Fragment fragment = $this.fragment;
        if (fragment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fragment");
        }
        return fragment;
    }

    public static final /* synthetic */ void access$setFragment$p(BiometricManager $this, Fragment fragment) {
        $this.fragment = fragment;
    }

    public static final /* synthetic */ BiometricPrompt.PromptInfo access$getPromptInfo$p(BiometricManager $this) {
        BiometricPrompt.PromptInfo promptInfo = $this.promptInfo;
        if (promptInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"promptInfo");
        }
        return promptInfo;
    }

    public static final /* synthetic */ void access$setPromptInfo$p(BiometricManager $this, BiometricPrompt.PromptInfo promptInfo) {
        $this.promptInfo = promptInfo;
    }

    public static final /* synthetic */ BiometricPrompt access$getBiometricPrompt$p(BiometricManager $this) {
        BiometricPrompt biometricPrompt = $this.biometricPrompt;
        if (biometricPrompt == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"biometricPrompt");
        }
        return biometricPrompt;
    }

    public static final /* synthetic */ void access$setBiometricPrompt$p(BiometricManager $this, BiometricPrompt biometricPrompt) {
        $this.biometricPrompt = biometricPrompt;
    }
}

