/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BinaryExpressionOperator;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class BinaryExpression
extends Expression {
    private Expression left;
    private BinaryExpressionOperator operator;
    private Expression right;

    public BinaryExpression(HiddenTokenAwareTree token, Expression left, BinaryExpressionOperator operator, Expression right) {
        super(token);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.BINARY_EXPRESSION;
    }

    public BinaryExpressionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(BinaryExpressionOperator operator) {
        this.operator = operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.left, this.operator, this.right);
    }

    public String toString() {
        return "[" + this.left + this.operator + this.right + "]";
    }

    @Override
    public BinaryExpression clone() {
        BinaryExpression result = (BinaryExpression)super.clone();
        result.left = this.left == null ? null : this.left.clone();
        result.operator = this.operator == null ? null : this.operator.clone();
        result.right = this.right == null ? null : this.right.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

