/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class DetachedRuleset
extends Expression
implements BodyOwner<GeneralBody> {
    private GeneralBody body;

    public DetachedRuleset(HiddenTokenAwareTree token, GeneralBody body) {
        super(token);
        this.body = body;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.body);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.DETACHED_RULESET;
    }

    @Override
    public DetachedRuleset clone() {
        DetachedRuleset result = (DetachedRuleset)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

