/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j;

import com.github.sommeri.less4j.utils.URIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class LessSource {
    public abstract LessSource relativeSource(String var1) throws FileNotFound, CannotReadFile, StringSourceException;

    public abstract String getContent() throws FileNotFound, CannotReadFile;

    public abstract byte[] getBytes() throws FileNotFound, CannotReadFile;

    public URI getURI() {
        return null;
    }

    public String getName() {
        return null;
    }

    public static class CannotReadFile
    extends Exception {
    }

    public static class FileNotFound
    extends Exception {
    }

    public static class StringSourceException
    extends Exception {
    }

    public static class StringSource
    extends LessSource {
        private String content;
        private String name;
        private URI uri;

        public StringSource(String content) {
            this(content, null);
        }

        public StringSource(String content, String name) {
            this.content = content;
            this.name = name;
        }

        public StringSource(String content, String name, URI uri) {
            this.content = content;
            this.name = name;
            this.uri = uri;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public byte[] getBytes() {
            return this.content != null ? this.content.getBytes() : null;
        }

        @Override
        public LessSource relativeSource(String filename) throws StringSourceException {
            throw new StringSourceException();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringSource other = (StringSource)obj;
            return !(this.content == null ? other.content != null : !this.content.equals(other.content));
        }
    }

    public static class FileSource
    extends AbstractHierarchicalSource {
        private static String DEFAULT_CHARSET = "utf-8";
        private File inputFile;
        private String charsetName;

        public FileSource(File inputFile) {
            this(inputFile, DEFAULT_CHARSET);
        }

        public FileSource(File inputFile, String charsetName) {
            this.inputFile = inputFile;
            this.charsetName = charsetName;
        }

        public FileSource(FileSource parent, String filename) {
            this(parent, filename, DEFAULT_CHARSET);
        }

        public FileSource(FileSource parent, String filename, String charsetName) {
            this(parent, new File(parent.getInputFile().getParentFile(), filename), charsetName);
        }

        public FileSource(FileSource parent, File inputFile, String charsetName) {
            super(parent);
            this.inputFile = inputFile;
            this.charsetName = charsetName;
            parent.addImportedSource(this);
        }

        @Override
        public URI getURI() {
            try {
                String path = this.getInputFile().toString();
                path = URIUtils.convertPlatformSeparatorToUri(path);
                return new URI(path);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        @Override
        public String getName() {
            return this.getInputFile().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getContent() throws FileNotFound, CannotReadFile {
            String string;
            InputStreamReader input = this.charsetName != null ? new InputStreamReader((InputStream)new FileInputStream(this.getInputFile()), this.charsetName) : new FileReader(this.getInputFile());
            try {
                String content = IOUtils.toString((Reader)input).replace("\r\n", "\n");
                this.setLastModified(this.getInputFile().lastModified());
                string = content;
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)input).close();
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    throw new FileNotFound();
                }
                catch (IOException ex) {
                    throw new CannotReadFile();
                }
            }
            ((Reader)input).close();
            return string;
        }

        @Override
        public byte[] getBytes() throws FileNotFound, CannotReadFile {
            try {
                byte[] content = FileUtils.readFileToByteArray((File)this.getInputFile());
                this.setLastModified(this.getInputFile().lastModified());
                return content;
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFound();
            }
            catch (IOException ex) {
                throw new CannotReadFile();
            }
        }

        @Override
        public FileSource relativeSource(String filename) {
            return new FileSource(this, filename, this.charsetName);
        }

        public File getInputFile() {
            return this.inputFile;
        }

        public String toString() {
            return this.getInputFile().toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            File canonicalInputFile = this.getCanonicalFile();
            result = 31 * result + (canonicalInputFile == null ? 0 : canonicalInputFile.hashCode());
            result = 31 * result + (this.charsetName == null ? 0 : this.charsetName.hashCode());
            return result;
        }

        private File getCanonicalFile() {
            try {
                return this.getInputFile().getCanonicalFile();
            }
            catch (IOException e) {
                return this.getInputFile().getAbsoluteFile();
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileSource other = (FileSource)obj;
            File absoluteInputFile = this.getCanonicalFile();
            if (absoluteInputFile == null ? other.getInputFile() != null : !absoluteInputFile.equals(other.getInputFile().getAbsoluteFile())) {
                return false;
            }
            return !(this.charsetName == null ? other.charsetName != null : !this.charsetName.equals(other.charsetName));
        }
    }

    public static class URLSource
    extends AbstractHierarchicalSource {
        private URL inputURL;
        private String charsetName;

        public URLSource(URL inputURL) {
            this(inputURL, null);
        }

        public URLSource(URL inputURL, String charsetName) {
            this.inputURL = inputURL;
            this.charsetName = charsetName;
        }

        public URLSource(URLSource parent, String filename) throws FileNotFound, CannotReadFile {
            this(parent, filename, null);
        }

        public URLSource(URLSource parent, String filename, String charsetName) throws FileNotFound, CannotReadFile {
            super(parent);
            try {
                this.inputURL = new URL(URIUtils.toParentURL(parent.inputURL), filename);
            }
            catch (MalformedURLException e) {
                throw new FileNotFound();
            }
            this.charsetName = charsetName;
            parent.addImportedSource(this);
        }

        @Override
        public String getContent() throws FileNotFound, CannotReadFile {
            try {
                URLConnection connection = this.getInputURL().openConnection();
                InputStreamReader input = this.charsetName != null ? new InputStreamReader(connection.getInputStream(), this.charsetName) : new InputStreamReader(connection.getInputStream());
                String content = IOUtils.toString((Reader)input).replace("\r\n", "\n");
                this.setLastModified(connection.getLastModified());
                ((Reader)input).close();
                return content;
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFound();
            }
            catch (IOException ex) {
                throw new CannotReadFile();
            }
        }

        @Override
        public byte[] getBytes() throws FileNotFound, CannotReadFile {
            try {
                URLConnection connection = this.getInputURL().openConnection();
                InputStreamReader input = new InputStreamReader(connection.getInputStream());
                this.setLastModified(connection.getLastModified());
                byte[] content = IOUtils.toByteArray((Reader)input);
                ((Reader)input).close();
                return content;
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFound();
            }
            catch (IOException ex) {
                throw new CannotReadFile();
            }
        }

        @Override
        public LessSource relativeSource(String filename) throws FileNotFound, CannotReadFile {
            return new URLSource(this, filename, this.charsetName);
        }

        public URL getInputURL() {
            return this.inputURL;
        }

        @Override
        public URI getURI() {
            try {
                return this.inputURL.toURI();
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        @Override
        public String getName() {
            return new File(this.inputURL.getPath()).getName();
        }

        public String toString() {
            return this.inputURL.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inputURL == null ? 0 : this.inputURL.hashCode());
            result = 31 * result + (this.charsetName == null ? 0 : this.charsetName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            URLSource other = (URLSource)obj;
            if (this.inputURL == null ? other.inputURL != null : !this.inputURL.equals(other.inputURL)) {
                return false;
            }
            return !(this.charsetName == null ? other.charsetName != null : !this.charsetName.equals(other.charsetName));
        }
    }

    public static abstract class AbstractHierarchicalSource
    extends LessSource {
        protected AbstractHierarchicalSource parent;
        protected long lastModified;
        protected long latestModified;
        protected Collection<LessSource> importedSources;

        public AbstractHierarchicalSource() {
            this.importedSources = new ArrayList<LessSource>();
        }

        public AbstractHierarchicalSource(AbstractHierarchicalSource parent) {
            this.parent = parent;
        }

        protected void setLastModified(long lastModified) {
            this.lastModified = lastModified;
            this.setLatestModified(lastModified);
        }

        protected void addImportedSource(LessSource source) {
            if (this.parent != null) {
                this.parent.addImportedSource(source);
            } else {
                this.importedSources.add(source);
            }
        }

        public Collection<LessSource> getImportedSources() {
            return this.importedSources;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getLatestModified() {
            return this.latestModified;
        }

        public void setLatestModified(long latestModified) {
            this.latestModified = latestModified;
            if (this.parent != null && latestModified > this.parent.getLatestModified()) {
                this.parent.setLatestModified(latestModified);
            }
        }
    }
}

