/*
 * Decompiled with CFR 0.152.
 */
package ng.softcom.android.utils.remote;

import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ng.softcom.android.utils.remote.RemoteUtils;
import org.jetbrains.annotations.NotNull;
import retrofit2.HttpException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0019\b\u0002\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lng/softcom/android/utils/remote/RemoteUtils;", "", "()V", "extractErrorMessage", "", "throwable", "", "httpErrorCatcher", "Lkotlin/Function1;", "Lretrofit2/HttpException;", "Lkotlin/ExtensionFunctionType;", "utils_release"})
public final class RemoteUtils {
    public static final RemoteUtils INSTANCE;

    @NotNull
    public final String extractErrorMessage(@NotNull Throwable throwable, @NotNull Function1<? super HttpException, String> httpErrorCatcher) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        Intrinsics.checkParameterIsNotNull(httpErrorCatcher, (String)"httpErrorCatcher");
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ConnectException) {
            string = "Could not connect to the server. Please check your internet connection.";
        } else if (throwable2 instanceof UnknownHostException) {
            string = "Couldn't connect to the server at the moment.";
        } else if (throwable2 instanceof SocketTimeoutException) {
            string = "Request timed out while trying to connect. Please check your connection.";
        } else if (throwable2 instanceof UnknownServiceException) {
            string = throwable.getMessage();
            if (string == null) {
                string = "An error occurred while connecting to the server. Please try again.";
            }
        } else if (throwable2 instanceof ProtocolException) {
            string = "An error occurred while connecting to the server. Please try again.";
        } else if (throwable2 instanceof HttpException) {
            string = (String)httpErrorCatcher.invoke((Object)throwable);
        } else {
            string = throwable.getMessage();
            if (string == null) {
                string = "An unexpected error has occurred. Please check your connection.";
            }
        }
        return string;
    }

    public static /* synthetic */ String extractErrorMessage$default(RemoteUtils remoteUtils, Throwable throwable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = extractErrorMessage.1.INSTANCE;
        }
        return remoteUtils.extractErrorMessage(throwable, (Function1<? super HttpException, String>)function1);
    }

    private RemoteUtils() {
    }

    static {
        RemoteUtils remoteUtils;
        INSTANCE = remoteUtils = new RemoteUtils();
    }
}

