/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.animation.type;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.smarteist.autoimageslider.IndicatorView.animation.controller.ValueController;
import com.smarteist.autoimageslider.IndicatorView.animation.data.type.SwapAnimationValue;
import com.smarteist.autoimageslider.IndicatorView.animation.type.BaseAnimation;

public class SwapAnimation
extends BaseAnimation<ValueAnimator> {
    private static final String ANIMATION_COORDINATE = "ANIMATION_COORDINATE";
    private static final String ANIMATION_COORDINATE_REVERSE = "ANIMATION_COORDINATE_REVERSE";
    private static final int COORDINATE_NONE = -1;
    private int coordinateStart = -1;
    private int coordinateEnd = -1;
    private SwapAnimationValue value = new SwapAnimationValue();

    public SwapAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SwapAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @Override
    public SwapAnimation progress(float progress) {
        if (this.animator != null) {
            long playTime = (long)(progress * (float)this.animationDuration);
            if (((ValueAnimator)this.animator).getValues() != null && ((ValueAnimator)this.animator).getValues().length > 0) {
                ((ValueAnimator)this.animator).setCurrentPlayTime(playTime);
            }
        }
        return this;
    }

    @NonNull
    public SwapAnimation with(int coordinateStart, int coordinateEnd) {
        if (this.animator != null && this.hasChanges(coordinateStart, coordinateEnd)) {
            this.coordinateStart = coordinateStart;
            this.coordinateEnd = coordinateEnd;
            PropertyValuesHolder holder = this.createColorPropertyHolder(ANIMATION_COORDINATE, coordinateStart, coordinateEnd);
            PropertyValuesHolder holderReverse = this.createColorPropertyHolder(ANIMATION_COORDINATE_REVERSE, coordinateEnd, coordinateStart);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{holder, holderReverse});
        }
        return this;
    }

    private PropertyValuesHolder createColorPropertyHolder(String propertyName, int startValue, int endValue) {
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startValue, endValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int coordinate = (Integer)animation.getAnimatedValue(ANIMATION_COORDINATE);
        int coordinateReverse = (Integer)animation.getAnimatedValue(ANIMATION_COORDINATE_REVERSE);
        this.value.setCoordinate(coordinate);
        this.value.setCoordinateReverse(coordinateReverse);
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }

    private boolean hasChanges(int coordinateStart, int coordinateEnd) {
        if (this.coordinateStart != coordinateStart) {
            return true;
        }
        return this.coordinateEnd != coordinateEnd;
    }
}

