/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.InfiniteAdapter;

import android.database.DataSetObserver;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.smarteist.autoimageslider.SliderViewAdapter;

public class InfinitePagerAdapter
extends PagerAdapter {
    public static final int INFINITE_SCROLL_LIMIT = 32400;
    private static final String TAG = "InfinitePagerAdapter";
    private SliderViewAdapter adapter;

    public InfinitePagerAdapter(SliderViewAdapter adapter) {
        this.adapter = adapter;
    }

    public PagerAdapter getRealAdapter() {
        return this.adapter;
    }

    public int getCount() {
        if (this.getRealCount() < 1) {
            return 0;
        }
        return this.getRealCount() * 32400;
    }

    public int getRealCount() {
        try {
            return this.getRealAdapter().getCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getMiddlePosition(int item) {
        int midpoint = Math.max(0, this.getRealCount()) * 16200;
        return item + midpoint;
    }

    @NonNull
    public Object instantiateItem(ViewGroup container, int virtualPosition) {
        if (this.getRealCount() < 1) {
            return this.adapter.instantiateItem(container, 0);
        }
        return this.adapter.instantiateItem(container, this.getRealPosition(virtualPosition));
    }

    public void destroyItem(ViewGroup container, int virtualPosition, Object object) {
        if (this.getRealCount() < 1) {
            this.adapter.destroyItem(container, 0, object);
            return;
        }
        this.adapter.destroyItem(container, this.getRealPosition(virtualPosition), object);
    }

    public void startUpdate(ViewGroup container) {
        this.adapter.startUpdate(container);
    }

    public void finishUpdate(ViewGroup container) {
        this.adapter.finishUpdate(container);
    }

    public boolean isViewFromObject(View view, Object object) {
        return this.adapter.isViewFromObject(view, object);
    }

    public void restoreState(Parcelable bundle, ClassLoader classLoader) {
        this.adapter.restoreState(bundle, classLoader);
    }

    public Parcelable saveState() {
        return this.adapter.saveState();
    }

    public CharSequence getPageTitle(int virtualPosition) {
        return this.adapter.getPageTitle(this.getRealPosition(virtualPosition));
    }

    public float getPageWidth(int position) {
        return this.adapter.getPageWidth(position);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        this.adapter.setPrimaryItem(container, position, object);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.adapter.unregisterDataSetObserver(observer);
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.adapter.registerDataSetObserver(observer);
    }

    public int getItemPosition(Object object) {
        return this.adapter.getItemPosition(object);
    }

    public int getRealPosition(int virtualPosition) {
        if (this.getRealCount() > 0) {
            return virtualPosition % this.getRealCount();
        }
        return 0;
    }
}

