/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import androidx.viewpager.widget.ViewPager;

public class CircularSliderHandle
implements ViewPager.OnPageChangeListener {
    private CurrentPageListener currentPageListener;
    private ViewPager mViewPager;
    private int mCurrentPosition;
    private int mPreviousPosition;
    private boolean mIsEndOfCycle;

    CircularSliderHandle(ViewPager viewPager) {
        this.mViewPager = viewPager;
    }

    void setCurrentPageListener(CurrentPageListener currentPageListener) {
        this.currentPageListener = currentPageListener;
    }

    public void onPageSelected(int position) {
        this.mCurrentPosition = position;
        if (this.currentPageListener != null) {
            this.currentPageListener.onCurrentPageChanged(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            if (this.mPreviousPosition == this.mCurrentPosition && !this.mIsEndOfCycle) {
                if (this.mCurrentPosition == 0) {
                    this.mViewPager.setCurrentItem(this.getAdapterItemsCount() - 1);
                } else {
                    this.mViewPager.setCurrentItem(0);
                }
                this.mIsEndOfCycle = true;
            } else {
                this.mIsEndOfCycle = false;
            }
            this.mPreviousPosition = this.mCurrentPosition;
        }
    }

    private int getAdapterItemsCount() {
        try {
            return this.mViewPager.getAdapter().getCount();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public static interface CurrentPageListener {
        public void onCurrentPageChanged(int var1);
    }
}

