/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.smarteist.autoimageslider.CircularSliderHandle;
import com.smarteist.autoimageslider.IndicatorAnimations;
import com.smarteist.autoimageslider.IndicatorView.PageIndicatorView;
import com.smarteist.autoimageslider.IndicatorView.animation.type.AnimationType;
import com.smarteist.autoimageslider.IndicatorView.draw.controller.DrawController;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Orientation;
import com.smarteist.autoimageslider.R;
import com.smarteist.autoimageslider.SliderAnimations;
import com.smarteist.autoimageslider.SliderPager;
import com.smarteist.autoimageslider.Transformations.AntiClockSpinTransformation;
import com.smarteist.autoimageslider.Transformations.Clock_SpinTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeInScalingTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutDepthTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutRotationTransformation;
import com.smarteist.autoimageslider.Transformations.CubeOutScalingTransformation;
import com.smarteist.autoimageslider.Transformations.DepthTransformation;
import com.smarteist.autoimageslider.Transformations.FadeTransformation;
import com.smarteist.autoimageslider.Transformations.FanTransformation;
import com.smarteist.autoimageslider.Transformations.FidgetSpinTransformation;
import com.smarteist.autoimageslider.Transformations.GateTransformation;
import com.smarteist.autoimageslider.Transformations.HingeTransformation;
import com.smarteist.autoimageslider.Transformations.HorizontalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.PopTransformation;
import com.smarteist.autoimageslider.Transformations.SimpleTransformation;
import com.smarteist.autoimageslider.Transformations.SpinnerTransformation;
import com.smarteist.autoimageslider.Transformations.TossTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalFlipTransformation;
import com.smarteist.autoimageslider.Transformations.VerticalShutTransformation;
import com.smarteist.autoimageslider.Transformations.ZoomOutTransformation;

public class SliderView
extends FrameLayout {
    private final Handler mHandler = new Handler();
    private boolean isAutoCycle = true;
    private int scrollTimeInSec = 2;
    private CircularSliderHandle mCircularSliderHandle;
    private PageIndicatorView mPagerIndicator;
    private DataSetObserver mDataSetObserver;
    private PagerAdapter mPagerAdapter;
    private Runnable mSliderRunnable;
    private SliderPager mSliderPager;

    public SliderView(Context context) {
        super(context);
        this.setupSlideView(context);
    }

    public SliderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupSlideView(context);
    }

    public SliderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupSlideView(context);
    }

    private void setupSlideView(Context context) {
        View wrapperView = LayoutInflater.from((Context)context).inflate(R.layout.slider_view, (ViewGroup)this, true);
        this.mSliderPager = (SliderPager)wrapperView.findViewById(R.id.vp_slider_layout);
        this.mCircularSliderHandle = new CircularSliderHandle(this.mSliderPager);
        this.mSliderPager.addOnPageChangeListener(this.mCircularSliderHandle);
        this.mPagerIndicator = (PageIndicatorView)wrapperView.findViewById(R.id.pager_indicator);
        this.mPagerIndicator.setViewPager(this.mSliderPager);
    }

    public void setOnIndicatorClickListener(DrawController.ClickListener listener) {
        this.mPagerIndicator.setClickListener(listener);
    }

    public void setCurrentPageListener(CircularSliderHandle.CurrentPageListener listener) {
        this.mCircularSliderHandle.setCurrentPageListener(listener);
    }

    public void setSliderAdapter(PagerAdapter pagerAdapter) {
        this.mPagerAdapter = pagerAdapter;
        this.registerDataObserver();
        this.mSliderPager.setAdapter(pagerAdapter);
        this.mSliderPager.setOffscreenPageLimit(pagerAdapter.getCount() - 1);
        this.mPagerIndicator.setCount(pagerAdapter.getCount());
        this.mPagerIndicator.setDynamicCount(true);
    }

    private void registerDataObserver() {
        if (this.mDataSetObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mDataSetObserver = new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                SliderView.this.mSliderPager.setOffscreenPageLimit(SliderView.this.mPagerAdapter.getCount() - 1);
            }
        };
        this.mPagerAdapter.registerDataSetObserver(this.mDataSetObserver);
    }

    public PagerAdapter getSliderAdapter() {
        return this.mPagerAdapter;
    }

    public boolean isAutoCycle() {
        return this.isAutoCycle;
    }

    public void setAutoCycle(boolean autoCycle) {
        this.isAutoCycle = autoCycle;
    }

    public int getScrollTimeInSec() {
        return this.scrollTimeInSec;
    }

    public void setScrollTimeInSec(int time) {
        this.scrollTimeInSec = time;
    }

    public void setSliderTransformAnimation(SliderAnimations animation) {
        switch (animation) {
            case ANTICLOCKSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new AntiClockSpinTransformation());
                break;
            }
            case CLOCK_SPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new Clock_SpinTransformation());
                break;
            }
            case CUBEINDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInDepthTransformation());
                break;
            }
            case CUBEINROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInRotationTransformation());
                break;
            }
            case CUBEINSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeInScalingTransformation());
                break;
            }
            case CUBEOUTDEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutDepthTransformation());
                break;
            }
            case CUBEOUTROTATIONTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutRotationTransformation());
                break;
            }
            case CUBEOUTSCALINGTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new CubeOutScalingTransformation());
                break;
            }
            case DEPTHTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new DepthTransformation());
                break;
            }
            case FADETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FadeTransformation());
                break;
            }
            case FANTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FanTransformation());
                break;
            }
            case FIDGETSPINTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new FidgetSpinTransformation());
                break;
            }
            case GATETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new GateTransformation());
                break;
            }
            case HINGETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new HingeTransformation());
                break;
            }
            case HORIZONTALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new HorizontalFlipTransformation());
                break;
            }
            case POPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new PopTransformation());
                break;
            }
            case SIMPLETRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new SimpleTransformation());
                break;
            }
            case SPINNERTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new SpinnerTransformation());
                break;
            }
            case TOSSTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new TossTransformation());
                break;
            }
            case VERTICALFLIPTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new VerticalFlipTransformation());
                break;
            }
            case VERTICALSHUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new VerticalShutTransformation());
                break;
            }
            case ZOOMOUTTRANSFORMATION: {
                this.mSliderPager.setPageTransformer(false, new ZoomOutTransformation());
                break;
            }
            default: {
                this.mSliderPager.setPageTransformer(false, new SimpleTransformation());
            }
        }
    }

    public void setCustomSliderTransformAnimation(ViewPager.PageTransformer animation) {
        this.mSliderPager.setPageTransformer(false, animation);
    }

    public void setSliderAnimationDuration(int duration) {
        this.mSliderPager.setScrollDuration(duration);
    }

    public void setIndicatorAnimationDuration(long duration) {
        this.mPagerIndicator.setAnimationDuration(duration);
    }

    public void setIndicatorPadding(int padding) {
        this.mPagerIndicator.setPadding(padding);
    }

    public void setIndicatorOrientation(Orientation orientation) {
        this.mPagerIndicator.setOrientation(orientation);
    }

    public void setCurrentPagePosition(int position) {
        if (this.getSliderAdapter() == null) {
            throw new NullPointerException("Adapter not set");
        }
        this.mSliderPager.setCurrentItem(position, true);
    }

    public int getCurrentPagePosition() {
        if (this.getSliderAdapter() != null) {
            return this.mSliderPager.getCurrentItem();
        }
        throw new NullPointerException("Adapter not set");
    }

    public void setIndicatorAnimation(IndicatorAnimations animations) {
        switch (animations) {
            case DROP: {
                this.mPagerIndicator.setAnimationType(AnimationType.DROP);
                break;
            }
            case FILL: {
                this.mPagerIndicator.setAnimationType(AnimationType.FILL);
                break;
            }
            case NONE: {
                this.mPagerIndicator.setAnimationType(AnimationType.NONE);
                break;
            }
            case SWAP: {
                this.mPagerIndicator.setAnimationType(AnimationType.SWAP);
                break;
            }
            case WORM: {
                this.mPagerIndicator.setAnimationType(AnimationType.WORM);
                break;
            }
            case COLOR: {
                this.mPagerIndicator.setAnimationType(AnimationType.COLOR);
                break;
            }
            case SCALE: {
                this.mPagerIndicator.setAnimationType(AnimationType.SCALE);
                break;
            }
            case SLIDE: {
                this.mPagerIndicator.setAnimationType(AnimationType.SLIDE);
                break;
            }
            case SCALE_DOWN: {
                this.mPagerIndicator.setAnimationType(AnimationType.SCALE_DOWN);
                break;
            }
            case THIN_WORM: {
                this.mPagerIndicator.setAnimationType(AnimationType.THIN_WORM);
            }
        }
    }

    public void setPagerIndicatorVisibility(boolean visibility) {
        if (visibility) {
            this.mPagerIndicator.setVisibility(0);
        } else {
            this.mPagerIndicator.setVisibility(8);
        }
    }

    public void startAutoCycle() {
        if (this.mSliderRunnable != null) {
            this.mHandler.removeCallbacks(this.mSliderRunnable);
        }
        this.mSliderRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SliderView.this.isAutoCycle) {
                        return;
                    }
                    int currentPosition = SliderView.this.mSliderPager.getCurrentItem();
                    currentPosition = currentPosition == SliderView.this.getSliderAdapter().getCount() - 1 ? 0 : ++currentPosition;
                    SliderView.this.mSliderPager.setCurrentItem(currentPosition, true);
                }
                finally {
                    SliderView.this.mHandler.postDelayed((Runnable)this, (long)(SliderView.this.scrollTimeInSec * 1000));
                }
            }
        };
        this.mSliderRunnable.run();
    }

    public int getSliderIndicatorRadius() {
        return this.mPagerIndicator.getRadius();
    }

    public void setSliderIndicatorRadius(int pagerIndicatorRadius) {
        this.mPagerIndicator.setRadius(pagerIndicatorRadius);
    }

    public void setSliderIndicatorSelectedColor(int color) {
        this.mPagerIndicator.setSelectedColor(color);
    }

    public int getSliderIndicatorSelectedColor() {
        return this.mPagerIndicator.getSelectedColor();
    }

    public void setSliderIndicatorUnselectedColor(int color) {
        this.mPagerIndicator.setUnselectedColor(color);
    }

    public int getSliderIndicatorUnselectedColor() {
        return this.mPagerIndicator.getUnselectedColor();
    }
}

