/*
 * Decompiled with CFR 0.152.
 */
package fr.arnaudguyon.tabstacker;

import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import fr.arnaudguyon.tabstacker.AnimationSet;
import fr.arnaudguyon.tabstacker.FragmentInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class TabStacker {
    private static final String BUNDLE_TAB_STACKER = "TabStacker";
    private String mCurrentTab = "";
    private FragmentManager mFragmentManager;
    private int mFragmentHolder;
    private HashMap<String, ArrayList<FragmentInfo>> mStacks = new HashMap();
    private static final String BUNDLE_CURRENT_TAB = "CurrentTab";
    private static final String BUNDLE_TAB_NAMES = "TabNames";
    private static final String BUNDLE_FRAGMENT_PREFIX = "FragmentInfo_";
    private static final String BUNDLE_STACKSIZE_POSTFIX = "_stackSize";

    public TabStacker(FragmentManager fragmentManager, @IdRes int fragmentHolder) {
        this.mFragmentManager = fragmentManager;
        this.mFragmentHolder = fragmentHolder;
    }

    public boolean switchToTab(String tabName) {
        if (tabName.equals(this.mCurrentTab)) {
            return true;
        }
        this.notifyAllRemoved(this.mCurrentTab, DismissReason.LEAVING_STACK);
        this.popAll(this.mCurrentTab);
        this.mCurrentTab = tabName;
        this.notifyAllRestored(tabName, PresentReason.RESTORING_STACK);
        this.pushAll(tabName);
        return !this.isEmpty(tabName);
    }

    public void replaceFragment(Fragment fragment, AnimationSet animationSet) {
        this.checkFragmentInterface(fragment);
        FragmentInfo topInfo = this.getTopFragmentInfo(this.mCurrentTab);
        if (topInfo != null) {
            this.onFragmentDismissed(topInfo.mFragment, DismissReason.REPLACED);
        }
        this.pushFragment(fragment, animationSet, Type.Replace);
        this.onFragmentPresented(fragment, PresentReason.NEW_FRAGMENT);
    }

    public void addFragment(Fragment fragment, AnimationSet animationSet) {
        this.checkFragmentInterface(fragment);
        FragmentInfo topInfo = this.getTopFragmentInfo(this.mCurrentTab);
        if (topInfo != null) {
            this.onFragmentDismissed(topInfo.mFragment, DismissReason.OVERLAPPED);
        }
        this.pushFragment(fragment, animationSet, Type.Add);
        this.onFragmentPresented(fragment, PresentReason.NEW_FRAGMENT);
    }

    public Fragment getTopFragment(@NonNull String selectedTab) {
        FragmentInfo fragmentInfo = this.getTopFragmentInfo(selectedTab);
        if (fragmentInfo != null) {
            return fragmentInfo.mFragment;
        }
        return null;
    }

    public Fragment getCurrentTopFragment() {
        return this.getTopFragment(this.mCurrentTab);
    }

    public String getCurrentTabName() {
        return this.mCurrentTab;
    }

    public int getCurrentTabSize() {
        return this.getTabSize(this.mCurrentTab);
    }

    public int getTabSize(String tabName) {
        ArrayList<FragmentInfo> list = this.mStacks.get(tabName);
        return list != null ? list.size() : 0;
    }

    private void pushFragment(Fragment fragment, AnimationSet animationSet, Type type) {
        this.checkFragmentInterface(fragment);
        if (this.isEmpty(this.mCurrentTab)) {
            type = Type.Replace;
            animationSet = null;
        }
        FragmentInfo fragmentInfo = new FragmentInfo(fragment, animationSet, type);
        if (type == Type.Replace) {
            this.replaceFragment(fragmentInfo, false);
        } else {
            this.addFragment(fragmentInfo, false);
        }
        ArrayList<FragmentInfo> list = this.mStacks.get(this.mCurrentTab);
        if (list == null) {
            list = new ArrayList();
            this.mStacks.put(this.mCurrentTab, list);
        }
        list.add(fragmentInfo);
    }

    public boolean onBackPressed() {
        return this.pop(DismissReason.BACK, PresentReason.BACK, false);
    }

    private boolean pop(DismissReason dismissReason, PresentReason presentReason, boolean instant) {
        if (this.getTabSize(this.mCurrentTab) <= 1) {
            return false;
        }
        ArrayList<FragmentInfo> infos = this.mStacks.get(this.mCurrentTab);
        FragmentInfo topFragmentInfo = infos.get(infos.size() - 1);
        if (topFragmentInfo.mType == Type.Add) {
            this.removeFragment(topFragmentInfo, instant);
            this.onFragmentDismissed(topFragmentInfo.mFragment, dismissReason);
        } else {
            int lastPreviousReplaceIndex;
            int currentIndex = infos.size() - 1;
            for (lastPreviousReplaceIndex = currentIndex - 1; lastPreviousReplaceIndex >= 1; --lastPreviousReplaceIndex) {
                FragmentInfo previousFragmentInfo = infos.get(lastPreviousReplaceIndex);
                if (previousFragmentInfo.mType == Type.Replace) break;
            }
            FragmentInfo previousReplace = infos.get(lastPreviousReplaceIndex);
            AnimationSet topAnimationSet = instant ? null : topFragmentInfo.mAnimationSet;
            int inAnim = topAnimationSet != null ? topAnimationSet.getPopInAnim() : 0;
            int outAnim = topAnimationSet != null ? topAnimationSet.getPopOutAnim() : 0;
            FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
            if (inAnim != 0 && outAnim != 0) {
                transaction.setCustomAnimations(inAnim, outAnim);
            }
            transaction.replace(this.mFragmentHolder, previousReplace.mFragment);
            transaction.commit();
            this.onFragmentDismissed(topFragmentInfo.mFragment, dismissReason);
            for (int iAdd = lastPreviousReplaceIndex + 1; iAdd < currentIndex; ++iAdd) {
                FragmentTransaction transaction2 = this.mFragmentManager.beginTransaction();
                if (inAnim != 0 && outAnim != 0) {
                    transaction2.setCustomAnimations(inAnim, outAnim);
                }
                transaction2.add(this.mFragmentHolder, infos.get((int)iAdd).mFragment);
                transaction2.commit();
            }
        }
        infos.remove(topFragmentInfo);
        topFragmentInfo = this.getTopFragmentInfo(this.mCurrentTab);
        if (topFragmentInfo != null) {
            this.onFragmentPresented(topFragmentInfo.mFragment, presentReason);
        }
        return true;
    }

    public void clearTabStack() {
        this.notifyAllRemoved(this.mCurrentTab, DismissReason.CLEARING_STACK);
        this.popAll(this.mCurrentTab);
        ArrayList<FragmentInfo> infos = this.mStacks.get(this.mCurrentTab);
        if (infos != null) {
            infos.clear();
        }
    }

    public int popToTop(boolean instant) {
        int tabSize = this.getCurrentTabSize();
        if (tabSize > 1) {
            return this.pop(tabSize - 1, instant);
        }
        return 0;
    }

    public int pop(int count, boolean instant) {
        int nbPopped;
        ArrayList<FragmentInfo> infos = this.mStacks.get(this.mCurrentTab);
        if (infos == null || infos.isEmpty()) {
            return nbPopped;
        }
        for (nbPopped = 0; nbPopped < count && infos.size() > 0; ++nbPopped) {
            if (this.pop(DismissReason.POP, PresentReason.POP, instant)) {
                continue;
            }
            return nbPopped;
        }
        return nbPopped;
    }

    private boolean isEmpty(String tabName) {
        return this.getTabSize(tabName) == 0;
    }

    private FragmentInfo getTopFragmentInfo(String tabName) {
        ArrayList<FragmentInfo> infos = this.mStacks.get(tabName);
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        return infos.get(infos.size() - 1);
    }

    private void popAll(String tabName) {
        ArrayList<FragmentInfo> infos = this.mStacks.get(tabName);
        if (infos != null) {
            for (int i = infos.size() - 1; i > 0; --i) {
                FragmentInfo topInfo = infos.get(i);
                this.removeFragment(topInfo, true);
            }
        }
    }

    private void pushAll(String tabName) {
        ArrayList<FragmentInfo> infos = this.mStacks.get(tabName);
        if (infos != null && infos.size() > 0) {
            int lastReplace = 0;
            for (int i = infos.size() - 1; i > 0; --i) {
                FragmentInfo info = infos.get(i);
                if (info.mType != Type.Replace) continue;
                lastReplace = i;
                break;
            }
            FragmentInfo replaceInfo = infos.get(lastReplace);
            this.replaceFragment(replaceInfo, true);
            for (int i = lastReplace + 1; i < infos.size(); ++i) {
                FragmentInfo info = infos.get(i);
                this.addFragment(info, true);
            }
        }
    }

    private void removeFragment(FragmentInfo fragmentInfo, boolean instant) {
        FragmentTransaction fragmentTransaction = this.mFragmentManager.beginTransaction();
        if (!instant && fragmentInfo.mAnimationSet != null) {
            fragmentInfo.mAnimationSet.addToTransaction(fragmentTransaction);
        }
        fragmentTransaction.remove(fragmentInfo.mFragment);
        fragmentTransaction.commit();
    }

    private void replaceFragment(FragmentInfo fragmentInfo, boolean instant) {
        FragmentTransaction fragmentTransaction = this.mFragmentManager.beginTransaction();
        if (!instant && fragmentInfo.mAnimationSet != null) {
            fragmentInfo.mAnimationSet.addToTransaction(fragmentTransaction);
        }
        fragmentTransaction.replace(this.mFragmentHolder, fragmentInfo.mFragment);
        fragmentTransaction.commit();
    }

    private void addFragment(FragmentInfo fragmentInfo, boolean instant) {
        FragmentTransaction fragmentTransaction = this.mFragmentManager.beginTransaction();
        if (!instant && fragmentInfo.mAnimationSet != null) {
            fragmentInfo.mAnimationSet.addToTransaction(fragmentTransaction);
        }
        fragmentTransaction.add(this.mFragmentHolder, fragmentInfo.mFragment);
        fragmentTransaction.commit();
    }

    private void notifyAllRemoved(String tabName, DismissReason reason) {
        ArrayList<FragmentInfo> infos = this.mStacks.get(tabName);
        if (infos != null) {
            for (int i = infos.size() - 1; i >= 0; --i) {
                FragmentInfo info = infos.get(i);
                this.onFragmentDismissed(info.mFragment, reason);
            }
        }
    }

    private void notifyAllRestored(String tabName, PresentReason reason) {
        ArrayList<FragmentInfo> infos = this.mStacks.get(tabName);
        if (infos != null) {
            for (FragmentInfo info : infos) {
                Fragment fragment = info.mFragment;
                this.onFragmentPresented(fragment, reason);
            }
        }
    }

    private void onFragmentPresented(Fragment fragment, PresentReason reason) {
        if (fragment instanceof TabStackInterface) {
            ((TabStackInterface)fragment).onTabFragmentPresented(reason);
        }
    }

    private void onFragmentDismissed(Fragment fragment, DismissReason reason) {
        if (fragment instanceof TabStackInterface) {
            ((TabStackInterface)fragment).onTabFragmentDismissed(reason);
        }
    }

    private void checkFragmentInterface(Fragment fragment) {
        if (!(fragment instanceof TabStackInterface)) {
            String className = fragment.getClass().getName();
            throw new RuntimeException(className + " must implement TabStackInterface");
        }
    }

    public void saveInstance(Bundle outState) {
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_CURRENT_TAB, this.mCurrentTab);
        Set<String> keys = this.mStacks.keySet();
        ArrayList<String> tabNames = new ArrayList<String>(keys);
        bundle.putStringArrayList(BUNDLE_TAB_NAMES, tabNames);
        for (String tabName : keys) {
            Bundle stackBundle = new Bundle();
            ArrayList<FragmentInfo> stack = this.mStacks.get(tabName);
            String stackSizeKey = tabName + BUNDLE_STACKSIZE_POSTFIX;
            stackBundle.putInt(stackSizeKey, stack.size());
            int index = 0;
            for (FragmentInfo fragmentInfo : stack) {
                String fragmentInfoKey = BUNDLE_FRAGMENT_PREFIX + index;
                ++index;
                Bundle infoBundle = fragmentInfo.saveInstance();
                stackBundle.putBundle(fragmentInfoKey, infoBundle);
            }
            bundle.putBundle(tabName, stackBundle);
        }
        outState.putBundle(BUNDLE_TAB_STACKER, bundle);
    }

    public void restoreInstance(Bundle savedInstanceState) {
        Bundle bundle;
        if (savedInstanceState.containsKey(BUNDLE_TAB_STACKER) && (bundle = savedInstanceState.getBundle(BUNDLE_TAB_STACKER)) != null) {
            this.mCurrentTab = bundle.getString(BUNDLE_CURRENT_TAB);
            ArrayList tabNames = bundle.getStringArrayList(BUNDLE_TAB_NAMES);
            if (tabNames != null) {
                for (String tabName : tabNames) {
                    ArrayList<FragmentInfo> stackInfos = this.mStacks.get(tabName);
                    if (stackInfos == null) {
                        stackInfos = new ArrayList();
                        this.mStacks.put(tabName, stackInfos);
                    } else {
                        stackInfos.clear();
                    }
                    Bundle stackBundle = bundle.getBundle(tabName);
                    String stackSizeKey = tabName + BUNDLE_STACKSIZE_POSTFIX;
                    int stackSize = stackBundle.getInt(stackSizeKey);
                    for (int i = 0; i < stackSize; ++i) {
                        String fragmentInfoKey = BUNDLE_FRAGMENT_PREFIX + i;
                        Bundle fragmentInfoBundle = stackBundle.getBundle(fragmentInfoKey);
                        FragmentInfo fragmentInfo = FragmentInfo.restoreInstance(fragmentInfoBundle);
                        stackInfos.add(fragmentInfo);
                    }
                }
            }
        }
        this.notifyAllRestored(this.mCurrentTab, PresentReason.RESTORING_STACK);
        this.pushAll(this.mCurrentTab);
    }

    public void restoreView(Fragment fragment, View fragmentView) {
        ArrayList<FragmentInfo> fragmentInfos = this.mStacks.get(this.mCurrentTab);
        for (FragmentInfo fragmentInfo : fragmentInfos) {
            if (fragmentInfo.mFragment != fragment) continue;
            fragmentInfo.restoreView(fragmentView);
            break;
        }
    }

    public static interface TabStackInterface {
        public void onTabFragmentPresented(PresentReason var1);

        public void onTabFragmentDismissed(DismissReason var1);

        public View onSaveTabFragmentInstance(Bundle var1);

        public void onRestoreTabFragmentInstance(Bundle var1);
    }

    public static enum DismissReason {
        REPLACED,
        OVERLAPPED,
        LEAVING_STACK,
        BACK,
        CLEARING_STACK,
        POP;

    }

    public static enum PresentReason {
        NEW_FRAGMENT,
        RESTORING_STACK,
        BACK,
        POP;

    }

    static enum Type {
        Replace,
        Add;

    }
}

