/*
 * Decompiled with CFR 0.152.
 */
package com.github.slashrootv200.exoplayerfragment;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.github.slashrootv200.exoplayerfragment.EventLogger;
import com.github.slashrootv200.exoplayerfragment.ExoErrorEvent;
import com.github.slashrootv200.exoplayerfragment.ExoPlayerFragment$$Lambda$1;
import com.github.slashrootv200.exoplayerfragment.ExoPlayerFragment$$Lambda$4;
import com.github.slashrootv200.exoplayerfragment.ExoPlayerFragment$$Lambda$5;
import com.github.slashrootv200.exoplayerfragment.ExoPlayerFragmentModel;
import com.github.slashrootv200.exoplayerfragment.ExoVideoEndedEvent;
import com.github.slashrootv200.exoplayerfragment.R;
import com.github.slashrootv200.exoplayerfragment.TrackSelectionHelper;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.HttpMediaDrmCallback;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.mediacodec.MediaCodecRenderer;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.metadata.MetadataRenderer;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.ConcatenatingMediaSource;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlaybackControlView;
import com.google.android.exoplayer2.ui.SimpleExoPlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.UUID;
import org.greenrobot.eventbus.EventBus;

public class ExoPlayerFragment
extends Fragment
implements View.OnClickListener,
ExoPlayer.EventListener,
PlaybackControlView.VisibilityListener {
    public static final String TAG = ExoPlayerFragment.class.getCanonicalName();
    public static final String DRM_SCHEME_UUID_EXTRA = "drm_scheme_uuid";
    public static final String DRM_LICENSE_URL = "drm_license_url";
    public static final String DRM_KEY_REQUEST_PROPERTIES = "drm_key_request_properties";
    public static final String PREFER_EXTENSION_DECODERS = "prefer_extension_decoders";
    public static final String ACTION_VIEW = "com.google.android.exoplayer.demo.action.VIEW";
    public static final String ACTION = "ACTION";
    public static final String EXTENSION_EXTRA = "extension";
    public static final String ACTION_VIEW_LIST = "com.google.android.exoplayer.demo.action.VIEW_LIST";
    public static final String URI_EXTRA = "URI_EXTRA";
    public static final String URI_LIST_EXTRA = "uri_list";
    public static final String EXTENSION_LIST_EXTRA = "extension_list";
    public static final String EXTRA_VIDEO_TITLE = "EXTRA_VIDEO_TITLE";
    public static final String EXTRA_DIALOG_THEME = "EXTRA_DIALOG_THEME";
    private static final DefaultBandwidthMeter BANDWIDTH_METER = new DefaultBandwidthMeter();
    private static final CookieManager DEFAULT_COOKIE_MANAGER = new CookieManager();
    private SimpleExoPlayerView simpleExoPlayerView;
    private LinearLayout debugRootView;
    private Button retryButton;
    private View rootView;
    private TextView mErrorTv;
    private ProgressBar mProgressBar;
    private ImageButton mFullscreenIb;
    private TextView mVideoTitleTv;
    private Handler mainHandler;
    private EventLogger eventLogger;
    private DataSource.Factory mediaDataSourceFactory;
    private SimpleExoPlayer player;
    private DefaultTrackSelector trackSelector;
    private TrackSelectionHelper trackSelectionHelper;
    private boolean needRetrySource;
    private TrackGroupArray lastSeenTrackGroupArray;
    private boolean shouldAutoPlay;
    private int resumeWindow;
    private long resumePosition;
    private boolean showAudioVideoAndTextButtons = true;
    private boolean mIsReturnedFromSharing;
    private boolean isFullscreen;
    private Uri mDelayedVideoUri = null;
    private String mDelayedVideoTitle = null;
    private boolean notifyErrorOnResume = false;
    private boolean mIsRestored = false;
    private ExoPlayerFragmentModel m;

    private static boolean isBehindLiveWindow(ExoPlaybackException e) {
        if (e.type != 0) {
            return false;
        }
        for (Throwable cause = e.getSourceException(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof BehindLiveWindowException)) continue;
            return true;
        }
        return false;
    }

    private static Bundle setUriInBundle(Bundle args, Uri uri) {
        args.putBoolean(PREFER_EXTENSION_DECODERS, true);
        args.putString(ACTION, ACTION_VIEW);
        args.putParcelable(URI_EXTRA, (Parcelable)uri);
        return args;
    }

    private static Bundle setTitleInBundle(Bundle args, String videoTitle) {
        args.putString(EXTRA_VIDEO_TITLE, videoTitle);
        return args;
    }

    private static Bundle setDialogThemeInBundle(Bundle args, int dialogTheme) {
        args.putInt(EXTRA_DIALOG_THEME, dialogTheme);
        return args;
    }

    public static ExoPlayerFragment newInstance(Uri uri, String videoTitle, int dialogTheme) {
        Log.d((String)TAG, (String)("entering newInstance with uri=" + uri + ",videoTitle=" + videoTitle));
        Bundle args = new Bundle();
        ExoPlayerFragment.setUriInBundle(args, uri);
        ExoPlayerFragment.setTitleInBundle(args, videoTitle);
        ExoPlayerFragment.setDialogThemeInBundle(args, dialogTheme);
        return ExoPlayerFragment.instantiatedAndSetArguments(args);
    }

    public static ExoPlayerFragment newInstance(Uri uri, int dialogTheme) {
        Log.d((String)TAG, (String)("entering newInstance with uri=" + uri));
        Bundle args = new Bundle();
        ExoPlayerFragment.setUriInBundle(args, uri);
        ExoPlayerFragment.setDialogThemeInBundle(args, dialogTheme);
        return ExoPlayerFragment.instantiatedAndSetArguments(args);
    }

    public static ExoPlayerFragment newInstance(Uri uri) {
        Log.d((String)TAG, (String)("entering newInstance with uri=" + uri));
        return ExoPlayerFragment.newInstance(uri, -1);
    }

    public static ExoPlayerFragment newInstance(Uri uri, String videoTitle) {
        Log.d((String)TAG, (String)("entering newInstance with uri=" + uri + ",videoTitle=" + videoTitle));
        return ExoPlayerFragment.newInstance(uri, videoTitle, -1);
    }

    private static ExoPlayerFragment instantiatedAndSetArguments(Bundle args) {
        ExoPlayerFragment f = new ExoPlayerFragment();
        f.setArguments(args);
        return f;
    }

    public void setVideoUriAndTitle(Uri videoUri, String videoTitle) {
        this.dLog("entering setVideoUri with videoTitle=" + videoTitle + ",videoUri=" + videoUri);
        if (this.mVideoTitleTv == null) {
            this.mDelayedVideoUri = videoUri;
            this.mDelayedVideoTitle = videoTitle;
        } else {
            this.getFragmentModel().setVideoTitle(videoTitle);
            if (!TextUtils.isEmpty((CharSequence)this.getFragmentModel().getVideoTitle())) {
                this.mVideoTitleTv.setText((CharSequence)this.getFragmentModel().getVideoTitle());
            } else {
                this.mVideoTitleTv.setText((CharSequence)"");
            }
            this.setVideoUri(videoUri);
        }
    }

    public void setVideoUri(Uri videoUri) {
        boolean haveResumePosition;
        this.dLog("entering setVideoUri with videoUri=" + videoUri);
        Bundle args = this.getArguments();
        String[] extensions = new String[]{args.getString(EXTENSION_EXTRA)};
        this.getFragmentModel().setUris(new Uri[]{videoUri});
        if (Util.maybeRequestReadExternalStoragePermission((Activity)this.getActivity(), (Uri[])this.getFragmentModel().getUris())) {
            return;
        }
        MediaSource[] mediaSources = new MediaSource[this.getFragmentModel().getUris().length];
        for (int i = 0; i < this.getFragmentModel().getUris().length; ++i) {
            mediaSources[i] = this.buildMediaSource(this.getFragmentModel().getUris()[i], extensions[i]);
        }
        ConcatenatingMediaSource mediaSource = mediaSources.length == 1 ? mediaSources[0] : new ConcatenatingMediaSource(mediaSources);
        boolean bl = haveResumePosition = this.resumeWindow != -1;
        if (haveResumePosition) {
            this.player.seekTo(this.resumeWindow, this.resumePosition);
        }
        this.player.prepare((MediaSource)mediaSource, !haveResumePosition, false);
        this.needRetrySource = false;
        this.showHideView((View)this.mErrorTv, false);
        this.updateButtonVisibilities();
    }

    protected Class<?> getFragmentModelClass() {
        return ExoPlayerFragmentModel.class;
    }

    protected ExoPlayerFragmentModel instantiateFragmentModel() {
        return new ExoPlayerFragmentModel();
    }

    private void initView(View v) {
        this.simpleExoPlayerView = (SimpleExoPlayerView)v.findViewById(R.id.player_view);
        this.debugRootView = (LinearLayout)v.findViewById(R.id.controls_root);
        this.retryButton = (Button)v.findViewById(R.id.retry_button);
        this.rootView = v.findViewById(R.id.root);
        this.mErrorTv = (TextView)v.findViewById(R.id.f_exo_error_tv);
        this.mProgressBar = (ProgressBar)v.findViewById(R.id.f_exo_progress_bar);
        this.mFullscreenIb = (ImageButton)v.findViewById(R.id.exo_full_screen);
        this.mVideoTitleTv = (TextView)v.findViewById(R.id.video_title);
        v.findViewById(R.id.exo_full_screen).setOnClickListener(ExoPlayerFragment$$Lambda$1.lambdaFactory$(this));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getFragmentModelClass() != null) {
            if (savedInstanceState == null) {
                if (this.m == null) {
                    this.m = this.instantiateFragmentModel();
                }
            } else {
                this.m = (ExoPlayerFragmentModel)savedInstanceState.getParcelable(this.getFragmentModelClass().getCanonicalName());
            }
        }
        this.shouldAutoPlay = false;
        this.clearResumePosition();
        this.mediaDataSourceFactory = this.buildDataSourceFactory(true);
        this.mainHandler = new Handler();
        if (CookieHandler.getDefault() != DEFAULT_COOKIE_MANAGER) {
            CookieHandler.setDefault(DEFAULT_COOKIE_MANAGER);
        }
        if (savedInstanceState == null) {
            this.getDataFromArguments();
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.fragment_exo_player, container, false);
        this.initView(v);
        return v;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.rootView.setOnClickListener((View.OnClickListener)this);
        this.retryButton.setOnClickListener((View.OnClickListener)this);
        this.rootView.setOnTouchListener(ExoPlayerFragment$$Lambda$4.lambdaFactory$(this));
        this.simpleExoPlayerView.setOnTouchListener(ExoPlayerFragment$$Lambda$5.lambdaFactory$(this));
        this.simpleExoPlayerView.setControllerVisibilityListener((PlaybackControlView.VisibilityListener)this);
        this.simpleExoPlayerView.requestFocus();
        this.mIsRestored = savedInstanceState != null;
    }

    public void onStart() {
        super.onStart();
        if (Util.SDK_INT > 23) {
            this.initializePlayer();
        }
    }

    public void onResume() {
        super.onResume();
        if (Util.SDK_INT <= 23 || this.player == null) {
            this.initializePlayer();
        }
        if (this.mDelayedVideoUri != null && this.mDelayedVideoTitle != null) {
            this.setVideoUriAndTitle(this.mDelayedVideoUri, this.mDelayedVideoTitle);
            this.mDelayedVideoTitle = null;
            this.mDelayedVideoUri = null;
        }
        if (this.mIsReturnedFromSharing) {
            this.mIsReturnedFromSharing = false;
            this.stopSpinner();
        }
        if (this.notifyErrorOnResume) {
            EventBus.getDefault().post((Object)new ExoErrorEvent(this.getFragmentModel().getUris()[0].toString(), null));
            this.notifyErrorOnResume = false;
        }
    }

    public void startSpinner(boolean isCancellable) {
        this.dLog("entering startSpinner with isCancellable = " + isCancellable);
        this.showHideView((View)this.mProgressBar, true);
    }

    public void stopSpinner() {
        this.dLog("entering stopSpinner");
        this.showHideView((View)this.mProgressBar, false);
    }

    public void onPause() {
        super.onPause();
        if (Util.SDK_INT <= 23) {
            this.releasePlayer();
        }
    }

    public void onStop() {
        super.onStop();
        if (Util.SDK_INT > 23) {
            this.releasePlayer();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.initializePlayer();
        } else {
            this.toastShort(this.getString(R.string.storage_permission_denied));
            this.showHideView((View)this.mErrorTv, true);
            this.mErrorTv.setText((CharSequence)this.getString(R.string.storage_permission_denied));
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    private void onFullScreenClicked() {
        boolean bl = this.isFullscreen = !this.isFullscreen;
        if (this.isFullscreen) {
            this.mFullscreenIb.setImageResource(R.drawable.ic_fullscreen_exit);
            this.getActivity().setRequestedOrientation(6);
            this.debugRootView.setVisibility(8);
        } else {
            this.mFullscreenIb.setImageResource(R.drawable.ic_fullscreen);
            this.getActivity().setRequestedOrientation(1);
            this.debugRootView.setVisibility(0);
        }
    }

    public void onClick(View view) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
        if (view == this.retryButton) {
            this.initializePlayer();
        } else if (view.getParent() == this.debugRootView && (mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo()) != null) {
            this.trackSelectionHelper.showSelectionDialog((Activity)this.getActivity(), ((Button)view).getText(), this.trackSelector.getCurrentMappedTrackInfo(), (Integer)view.getTag());
        }
    }

    public void onVisibilityChange(int visibility) {
        if (!this.isFullscreen) {
            this.debugRootView.setVisibility(visibility);
        }
    }

    private void initializePlayer() {
        boolean needNewPlayer;
        boolean bl = needNewPlayer = this.player == null;
        if (needNewPlayer) {
            DrmSessionManager<FrameworkMediaCrypto> drmSessionManager = null;
            if (this.getFragmentModel().getDrmSchemeUUID() != null) {
                try {
                    drmSessionManager = this.buildDrmSessionManager(this.getFragmentModel().getDrmSchemeUUID(), this.getFragmentModel().getDrmLicenseUrl(), this.getFragmentModel().getKeyRequestPropertiesArray());
                }
                catch (UnsupportedDrmException e) {
                    int errorStringId = Util.SDK_INT < 18 ? R.string.error_drm_not_supported : (e.reason == 1 ? R.string.error_drm_unsupported_scheme : R.string.error_drm_unknown);
                    this.toastShort(this.getString(errorStringId));
                    return;
                }
            }
            DefaultRenderersFactory renderersFactory = new DefaultRenderersFactory((Context)this.getActivity(), drmSessionManager, 2);
            AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)BANDWIDTH_METER);
            this.trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
            this.trackSelectionHelper = new TrackSelectionHelper((MappingTrackSelector)this.trackSelector, (TrackSelection.Factory)videoTrackSelectionFactory, this.getFragmentModel().getDialogTheme());
            this.lastSeenTrackGroupArray = null;
            this.player = ExoPlayerFactory.newSimpleInstance((RenderersFactory)renderersFactory, (TrackSelector)this.trackSelector);
            this.player.addListener((ExoPlayer.EventListener)this);
            this.eventLogger = new EventLogger((MappingTrackSelector)this.trackSelector);
            this.player.addListener((ExoPlayer.EventListener)this.eventLogger);
            this.player.setAudioDebugListener((AudioRendererEventListener)this.eventLogger);
            this.player.setVideoDebugListener((VideoRendererEventListener)this.eventLogger);
            this.player.setMetadataOutput((MetadataRenderer.Output)this.eventLogger);
            this.simpleExoPlayerView.setPlayer(this.player);
            this.player.setPlayWhenReady(this.shouldAutoPlay);
        }
        if (needNewPlayer || this.needRetrySource) {
            boolean haveResumePosition;
            String action = this.getFragmentModel().getAction();
            if (ACTION_VIEW.equals(action)) {
                if (TextUtils.isEmpty((CharSequence)this.getFragmentModel().getVideoTitle())) {
                    this.mVideoTitleTv.setText((CharSequence)"");
                } else {
                    this.mVideoTitleTv.setText((CharSequence)this.getFragmentModel().getVideoTitle());
                }
            } else if (!ACTION_VIEW_LIST.equals(action)) {
                this.showHideView((View)this.mErrorTv, true);
                this.mErrorTv.setText((CharSequence)this.getString(R.string.unexpected_intent_action, new Object[]{action}));
                this.toastShort(this.getString(R.string.unexpected_intent_action, new Object[]{action}));
                return;
            }
            if (Util.maybeRequestReadExternalStoragePermission((Activity)this.getActivity(), (Uri[])this.getFragmentModel().getUris())) {
                return;
            }
            MediaSource[] mediaSources = new MediaSource[this.getFragmentModel().getUris().length];
            for (int i = 0; i < this.getFragmentModel().getUris().length; ++i) {
                mediaSources[i] = this.buildMediaSource(this.getFragmentModel().getUris()[i], this.getFragmentModel().getExtensions()[i]);
            }
            ConcatenatingMediaSource mediaSource = mediaSources.length == 1 ? mediaSources[0] : new ConcatenatingMediaSource(mediaSources);
            boolean bl2 = haveResumePosition = this.resumeWindow != -1;
            if (haveResumePosition) {
                this.player.seekTo(this.resumeWindow, this.resumePosition);
            }
            if (this.getFragmentModel().getResumePosition() > 0L) {
                this.player.seekTo(this.getFragmentModel().getResumePosition());
            }
            this.player.prepare((MediaSource)mediaSource, !haveResumePosition, false);
            this.needRetrySource = false;
            this.showHideView((View)this.mErrorTv, false);
            this.updateButtonVisibilities();
        }
    }

    public boolean getCurrentPlaybackState() {
        this.dLog("entering getCurrentPlaybackState");
        if (this.simpleExoPlayerView != null && this.simpleExoPlayerView.getPlayer() != null) {
            this.dLog("simpleExoPlayerView != null && simpleExoPlayerView.getPlayer() != null is true");
            return this.simpleExoPlayerView.getPlayer().getPlayWhenReady();
        }
        this.dLog("simpleExoPlayerView != null && simpleExoPlayerView.getPlayer() != null is false");
        return false;
    }

    public void pauseVideo() {
        this.dLog("entering pauseVideo");
        if (this.simpleExoPlayerView != null && this.simpleExoPlayerView.getPlayer() != null) {
            this.dLog("simpleExoPlayerView != null && simpleExoPlayerView.getPlayer() != null is true");
            this.simpleExoPlayerView.getPlayer().setPlayWhenReady(false);
        } else {
            this.dLog("simpleExoPlayerView != null && simpleExoPlayerView.getPlayer() != null is false");
        }
    }

    public void resumeVideo() {
        this.dLog("entering resumeVideo");
        if (this.simpleExoPlayerView != null && this.simpleExoPlayerView.getPlayer() != null) {
            this.dLog("simpleExoPlayerView != null && simpleExoPlayerView.getPlayer() != null is true");
            this.simpleExoPlayerView.getPlayer().setPlayWhenReady(true);
        } else {
            this.dLog("simpleExoPlayerView != null && simpleExoPlayerView.getPlayer() != null is false");
        }
    }

    private MediaSource buildMediaSource(Uri uri, String overrideExtension) {
        int type = TextUtils.isEmpty((CharSequence)overrideExtension) ? Util.inferContentType((Uri)uri) : Util.inferContentType((String)("." + overrideExtension));
        switch (type) {
            case 1: {
                return new SsMediaSource(uri, this.buildDataSourceFactory(false), (SsChunkSource.Factory)new DefaultSsChunkSource.Factory(this.mediaDataSourceFactory), this.mainHandler, (AdaptiveMediaSourceEventListener)this.eventLogger);
            }
            case 0: {
                return new DashMediaSource(uri, this.buildDataSourceFactory(false), (DashChunkSource.Factory)new DefaultDashChunkSource.Factory(this.mediaDataSourceFactory), this.mainHandler, (AdaptiveMediaSourceEventListener)this.eventLogger);
            }
            case 2: {
                return new HlsMediaSource(uri, this.mediaDataSourceFactory, this.mainHandler, (AdaptiveMediaSourceEventListener)this.eventLogger);
            }
            case 3: {
                return new ExtractorMediaSource(uri, this.mediaDataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory(), this.mainHandler, (ExtractorMediaSource.EventListener)this.eventLogger);
            }
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.simpleExoPlayerView != null && this.simpleExoPlayerView.getPlayer() != null) {
            this.getFragmentModel().setResumePosition(this.simpleExoPlayerView.getPlayer().getCurrentPosition());
        }
        if (this.getFragmentModelClass() != null) {
            outState.putParcelable(this.getFragmentModelClass().getCanonicalName(), (Parcelable)this.m);
        }
        super.onSaveInstanceState(outState);
    }

    private DrmSessionManager<FrameworkMediaCrypto> buildDrmSessionManager(UUID uuid, String licenseUrl, String[] keyRequestPropertiesArray) throws UnsupportedDrmException {
        if (Util.SDK_INT < 18) {
            return null;
        }
        HttpMediaDrmCallback drmCallback = new HttpMediaDrmCallback(licenseUrl, this.buildHttpDataSourceFactory(false));
        if (keyRequestPropertiesArray != null) {
            for (int i = 0; i < keyRequestPropertiesArray.length - 1; i += 2) {
                drmCallback.setKeyRequestProperty(keyRequestPropertiesArray[i], keyRequestPropertiesArray[i + 1]);
            }
        }
        return new DefaultDrmSessionManager(uuid, (ExoMediaDrm)FrameworkMediaDrm.newInstance((UUID)uuid), (MediaDrmCallback)drmCallback, null, this.mainHandler, (DefaultDrmSessionManager.EventListener)this.eventLogger);
    }

    private void releasePlayer() {
        if (this.player != null) {
            this.shouldAutoPlay = this.player.getPlayWhenReady();
            this.updateResumePosition();
            this.player.release();
            this.player = null;
            this.trackSelector = null;
            this.trackSelectionHelper = null;
            this.eventLogger = null;
        }
    }

    private void updateResumePosition() {
        this.resumeWindow = this.player.getCurrentWindowIndex();
        this.resumePosition = this.player.isCurrentWindowSeekable() ? Math.max(0L, this.player.getCurrentPosition()) : -9223372036854775807L;
    }

    private void clearResumePosition() {
        this.resumeWindow = -1;
        this.resumePosition = -9223372036854775807L;
    }

    private DataSource.Factory buildDataSourceFactory(boolean useBandwidthMeter) {
        return this.buildDataSourceFactory((DefaultBandwidthMeter)(useBandwidthMeter ? BANDWIDTH_METER : null));
    }

    public DataSource.Factory buildDataSourceFactory(DefaultBandwidthMeter bandwidthMeter) {
        return new DefaultDataSourceFactory(this.getContext(), (TransferListener)bandwidthMeter, (DataSource.Factory)this.buildHttpDataSourceFactory(bandwidthMeter));
    }

    public HttpDataSource.Factory buildHttpDataSourceFactory(DefaultBandwidthMeter bandwidthMeter) {
        return new DefaultHttpDataSourceFactory("exo-player", (TransferListener)bandwidthMeter);
    }

    private HttpDataSource.Factory buildHttpDataSourceFactory(boolean useBandwidthMeter) {
        return this.buildHttpDataSourceFactory((DefaultBandwidthMeter)(useBandwidthMeter ? BANDWIDTH_METER : null));
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    private void dLog(String message) {
        Log.d((String)TAG, (String)message);
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        switch (playbackState) {
            case 1: {
                this.dLog("onPlayerStateChanged with playbackState = ExoPlayer.STATE_IDLE");
                this.showHideView((View)this.mProgressBar, false);
                break;
            }
            case 2: {
                this.dLog("onPlayerStateChanged with playbackState = ExoPlayer.STATE_BUFFERING");
                this.showHideView((View)this.mProgressBar, true);
                break;
            }
            case 3: {
                this.dLog("onPlayerStateChanged with playbackState = ExoPlayer.STATE_READY");
                this.showHideView((View)this.mProgressBar, false);
                break;
            }
            case 4: {
                this.dLog("onPlayerStateChanged with playbackState = ExoPlayer.STATE_ENDED");
                this.showHideView((View)this.mProgressBar, false);
                this.showControls();
                EventBus.getDefault().post((Object)new ExoVideoEndedEvent());
                break;
            }
            default: {
                this.dLog("onPlayerStateChanged with playbackState = " + playbackState);
            }
        }
        this.updateButtonVisibilities();
    }

    public void onPositionDiscontinuity() {
        if (this.needRetrySource) {
            this.updateResumePosition();
        }
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void showHideView(View v, boolean show) {
        if (show) {
            v.setVisibility(0);
        } else {
            v.setVisibility(8);
        }
    }

    public void onTimelineChanged(Timeline timeline, Object manifest) {
    }

    public void onPlayerError(ExoPlaybackException e) {
        Exception cause;
        String errorString = null;
        if (this.isResumed()) {
            EventBus.getDefault().post((Object)new ExoErrorEvent(this.getFragmentModel().getUris()[0].toString(), e.getMessage()));
        } else {
            this.notifyErrorOnResume = true;
        }
        if (e.type == 1 && (cause = e.getRendererException()) instanceof MediaCodecRenderer.DecoderInitializationException) {
            MediaCodecRenderer.DecoderInitializationException decoderInitializationException = (MediaCodecRenderer.DecoderInitializationException)cause;
            errorString = decoderInitializationException.decoderName == null ? (decoderInitializationException.getCause() instanceof MediaCodecUtil.DecoderQueryException ? this.getString(R.string.error_querying_decoders) : (decoderInitializationException.secureDecoderRequired ? this.getString(R.string.error_no_secure_decoder, new Object[]{decoderInitializationException.mimeType}) : this.getString(R.string.error_no_decoder, new Object[]{decoderInitializationException.mimeType}))) : this.getString(R.string.error_instantiating_decoder, new Object[]{decoderInitializationException.decoderName});
        }
        if (errorString != null) {
            this.showHideView((View)this.mErrorTv, true);
            this.toastShort(errorString);
        }
        this.needRetrySource = true;
        if (ExoPlayerFragment.isBehindLiveWindow(e)) {
            this.clearResumePosition();
            this.initializePlayer();
        } else {
            this.updateResumePosition();
            this.updateButtonVisibilities();
            this.showControls();
        }
    }

    public void toastShort(String message) {
        Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)0).show();
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        this.updateButtonVisibilities();
        if (trackGroups != this.lastSeenTrackGroupArray) {
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
            if (mappedTrackInfo != null) {
                if (mappedTrackInfo.getTrackTypeRendererSupport(2) == 1) {
                    this.toastShort(this.getString(R.string.error_unsupported_video));
                }
                if (mappedTrackInfo.getTrackTypeRendererSupport(1) == 1) {
                    this.toastShort(this.getString(R.string.error_unsupported_audio));
                }
            }
            this.lastSeenTrackGroupArray = trackGroups;
        }
    }

    public ExoPlayerFragmentModel getFragmentModel() {
        return this.m;
    }

    public void setFragmentModel(ExoPlayerFragmentModel m) {
        this.m = m;
    }

    private void updateButtonVisibilities() {
        this.debugRootView.removeAllViews();
        this.retryButton.setVisibility(this.needRetrySource ? 0 : 8);
        this.debugRootView.addView((View)this.retryButton);
        if (this.player == null) {
            return;
        }
        if (this.showAudioVideoAndTextButtons) {
            MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
            if (mappedTrackInfo == null) {
                return;
            }
            block5: for (int i = 0; i < mappedTrackInfo.length; ++i) {
                int label;
                TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(i);
                if (trackGroups.length == 0) continue;
                switch (this.player.getRendererType(i)) {
                    case 1: {
                        if (!this.getResources().getBoolean(R.bool.exo_fragment_lib_show_audio_selector)) continue block5;
                        label = R.string.audio;
                        break;
                    }
                    case 2: {
                        if (!this.getResources().getBoolean(R.bool.exo_fragment_lib_show_video_selector)) continue block5;
                        label = R.string.video;
                        break;
                    }
                    case 3: {
                        if (!this.getResources().getBoolean(R.bool.exo_fragment_lib_show_text_selector)) continue block5;
                        label = R.string.text;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                Button button = new Button((Context)this.getActivity());
                Drawable buttonDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.exo_lib_player_translucent_button);
                buttonDrawable.mutate();
                button.setBackground(buttonDrawable);
                button.setText(label);
                button.setTextColor(-1);
                button.setTag((Object)i);
                button.setOnClickListener((View.OnClickListener)this);
                this.debugRootView.addView((View)button, this.debugRootView.getChildCount() - 1);
            }
        }
    }

    private void showControls() {
        this.debugRootView.setVisibility(0);
    }

    public boolean onPlayerViewTouch(View v, MotionEvent event) {
        this.simpleExoPlayerView.showController();
        return false;
    }

    private void getDataFromArguments() {
        Bundle args = this.getArguments();
        this.getFragmentModel().setDialogTheme(args.getInt(EXTRA_DIALOG_THEME, -1));
        if (args.containsKey(PREFER_EXTENSION_DECODERS)) {
            this.getFragmentModel().setPreferExtensionDecoders(args.getBoolean(PREFER_EXTENSION_DECODERS, false));
        }
        if (args.containsKey(DRM_LICENSE_URL)) {
            this.getFragmentModel().setDrmLicenseUrl(args.getString(DRM_LICENSE_URL));
        }
        if (args.containsKey(DRM_KEY_REQUEST_PROPERTIES)) {
            this.getFragmentModel().setKeyRequestPropertiesArray(args.getStringArray(DRM_KEY_REQUEST_PROPERTIES));
        }
        if (args.containsKey(EXTENSION_LIST_EXTRA)) {
            this.getFragmentModel().setExtensions(args.getStringArray(EXTENSION_LIST_EXTRA));
        }
        if (args.containsKey(ACTION)) {
            this.getFragmentModel().setAction(args.getString(ACTION));
            if (ACTION_VIEW.equals(this.getFragmentModel().getAction())) {
                this.getFragmentModel().setUris(new Uri[]{(Uri)args.getParcelable(URI_EXTRA)});
                if (this.getFragmentModel().getExtensions() == null) {
                    this.getFragmentModel().setExtensions(new String[1]);
                }
            } else if (ACTION_VIEW_LIST.equals(this.getFragmentModel().getAction())) {
                String[] arr = args.getStringArray(URI_LIST_EXTRA);
                this.getFragmentModel().setUris(new Uri[arr.length]);
                for (int i = 0; i < arr.length; ++i) {
                    this.getFragmentModel().getUris()[i] = Uri.parse((String)arr[i]);
                }
                if (this.getFragmentModel().getExtensions() == null) {
                    this.getFragmentModel().setExtensions(new String[arr.length]);
                }
            }
        }
        UUID drmSchemeUuid = args.containsKey(DRM_SCHEME_UUID_EXTRA) ? UUID.fromString(args.getString(DRM_SCHEME_UUID_EXTRA)) : null;
        this.getFragmentModel().setDrmSchemeUUID(drmSchemeUuid);
    }

    static /* synthetic */ boolean lambda$onViewCreated$2(ExoPlayerFragment this_, View view12, MotionEvent motionEvent) {
        this_.onPlayerViewTouch(view12, motionEvent);
        return false;
    }

    static /* synthetic */ boolean lambda$onViewCreated$1(ExoPlayerFragment this_, View view1, MotionEvent motionEvent) {
        this_.onPlayerViewTouch(view1, motionEvent);
        return false;
    }

    static /* synthetic */ void lambda$initView$0(ExoPlayerFragment this_, View view) {
        this_.onFullScreenClicked();
    }

    static {
        DEFAULT_COOKIE_MANAGER.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
    }
}

