/*
 * Decompiled with CFR 0.152.
 */
package com.github.slashrootv200.exoplayerfragment;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import com.github.slashrootv200.exoplayerfragment.ExoErrorEvent;
import com.github.slashrootv200.exoplayerfragment.ExoPlayerFragment;
import com.github.slashrootv200.exoplayerfragment.ExoVideoEndedEvent;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class BaseExoPlayerActivity
extends AppCompatActivity {
    private final String TAG = BaseExoPlayerActivity.class.getCanonicalName();
    private final int PLAY_STATE = 1;
    private final int PAUSE_STATE = 2;
    protected ExoPlayerFragment mExoPlayerFragment;
    private int mVideoPlaybackStateAtPause;
    private int mLayoutResId;
    private Object mExoErrorListener;
    private Object mExoVideoEndedListener;

    public BaseExoPlayerActivity(int layoutResId) {
        this.mLayoutResId = layoutResId;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.mLayoutResId);
        if (savedInstanceState != null) {
            this.mExoPlayerFragment = (ExoPlayerFragment)this.getSupportFragmentManager().findFragmentByTag(ExoPlayerFragment.TAG);
        }
    }

    private final void dLog(String message) {
        Log.d((String)this.TAG, (String)message);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.dLog("entering onConfigurationChanged with newConfig=" + newConfig);
        super.onConfigurationChanged(newConfig);
        this.dLog("new orientation=" + newConfig.orientation);
        View decorView = this.getWindow().getDecorView();
        if (newConfig.orientation == 1) {
            this.showHideActionBarIfPresent(true);
            this.showSystemUI(decorView);
            this.onPortrait();
        } else if (newConfig.orientation == 2) {
            this.showHideActionBarIfPresent(false);
            this.hideSystemUI(decorView);
            this.onLandscape();
        }
    }

    private void showHideActionBarIfPresent(boolean show) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            if (show) {
                actionBar.show();
            } else {
                actionBar.hide();
            }
        }
    }

    protected void onResume() {
        super.onResume();
        this.dLog("entering onResume");
        if (this.mVideoPlaybackStateAtPause == 1 && this.mExoPlayerFragment != null) {
            this.mExoPlayerFragment.resumeVideo();
        }
        this.mExoErrorListener = new Object(){

            @Subscribe(threadMode=ThreadMode.MAIN)
            public void onExoErrorReceived(ExoErrorEvent e) {
                BaseExoPlayerActivity.this.onExoErrorReceived(e);
            }
        };
        this.mExoVideoEndedListener = new Object(){

            @Subscribe(threadMode=ThreadMode.MAIN)
            public void onExoVideoEnded(ExoVideoEndedEvent e) {
                BaseExoPlayerActivity.this.onExoVideoEndedEventReceived(e);
            }
        };
        EventBus.getDefault().register(this.mExoErrorListener);
        EventBus.getDefault().register(this.mExoVideoEndedListener);
    }

    protected void onPause() {
        this.dLog("entering onPause");
        super.onPause();
        if (this.mExoPlayerFragment != null) {
            this.mVideoPlaybackStateAtPause = this.mExoPlayerFragment.getCurrentPlaybackState() ? 1 : 2;
            this.mExoPlayerFragment.pauseVideo();
        }
        EventBus.getDefault().unregister(this.mExoErrorListener);
        EventBus.getDefault().unregister(this.mExoVideoEndedListener);
        this.mExoErrorListener = null;
        this.dLog("exiting onPause");
    }

    void hideSystemUI(View decorView) {
        decorView.setSystemUiVisibility(5894);
    }

    void showSystemUI(View decorView) {
        decorView.setSystemUiVisibility(1792);
        decorView.setSystemUiVisibility(0);
    }

    protected abstract void onPortrait();

    protected abstract void onLandscape();

    public abstract void onExoVideoEndedEventReceived(ExoVideoEndedEvent var1);

    public abstract void onExoErrorReceived(ExoErrorEvent var1);
}

