/*
 * Decompiled with CFR 0.152.
 */
package com.github.slashrootv200.exoplayerfragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import com.github.slashrootv200.exoplayerfragment.ExoUtils;
import com.github.slashrootv200.exoplayerfragment.R;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.RandomTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import java.util.Arrays;

final class TrackSelectionHelper
implements View.OnClickListener,
DialogInterface.OnClickListener {
    private static final TrackSelection.Factory FIXED_FACTORY = new FixedTrackSelection.Factory();
    private static final TrackSelection.Factory RANDOM_FACTORY = new RandomTrackSelection.Factory();
    private final MappingTrackSelector selector;
    private final TrackSelection.Factory adaptiveTrackSelectionFactory;
    private MappingTrackSelector.MappedTrackInfo trackInfo;
    private int rendererIndex;
    private TrackGroupArray trackGroups;
    private boolean[] trackGroupsAdaptive;
    private boolean isDisabled;
    private MappingTrackSelector.SelectionOverride override;
    private CheckedTextView disableView;
    private CheckedTextView defaultView;
    private CheckedTextView enableRandomAdaptationView;
    private CheckedTextView[][] trackViews;

    public TrackSelectionHelper(MappingTrackSelector selector, TrackSelection.Factory adaptiveTrackSelectionFactory) {
        this.selector = selector;
        this.adaptiveTrackSelectionFactory = adaptiveTrackSelectionFactory;
    }

    private static int[] getTracksAdding(MappingTrackSelector.SelectionOverride override, int addedTrack) {
        int[] tracks = override.tracks;
        tracks = Arrays.copyOf(tracks, tracks.length + 1);
        tracks[tracks.length - 1] = addedTrack;
        return tracks;
    }

    private static int[] getTracksRemoving(MappingTrackSelector.SelectionOverride override, int removedTrack) {
        int[] tracks = new int[override.length - 1];
        int trackCount = 0;
        for (int i = 0; i < tracks.length + 1; ++i) {
            int track = override.tracks[i];
            if (track == removedTrack) continue;
            tracks[trackCount++] = track;
        }
        return tracks;
    }

    public void showSelectionDialog(Activity activity, CharSequence title, MappingTrackSelector.MappedTrackInfo trackInfo, int rendererIndex) {
        this.trackInfo = trackInfo;
        this.rendererIndex = rendererIndex;
        this.trackGroups = trackInfo.getTrackGroups(rendererIndex);
        this.trackGroupsAdaptive = new boolean[this.trackGroups.length];
        for (int i = 0; i < this.trackGroups.length; ++i) {
            this.trackGroupsAdaptive[i] = this.adaptiveTrackSelectionFactory != null && trackInfo.getAdaptiveSupport(rendererIndex, i, false) != 0 && this.trackGroups.get((int)i).length > 1;
        }
        this.isDisabled = this.selector.getRendererDisabled(rendererIndex);
        this.override = this.selector.getSelectionOverride(rendererIndex, this.trackGroups);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle(title).setView(this.buildView(builder.getContext())).setPositiveButton(17039370, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, null).create().show();
    }

    @SuppressLint(value={"InflateParams"})
    private View buildView(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(R.layout.track_selection_dialog, null);
        ViewGroup root = (ViewGroup)view.findViewById(R.id.root);
        TypedArray attributeArray = context.getTheme().obtainStyledAttributes(new int[]{16843534});
        int selectableItemBackgroundResourceId = attributeArray.getResourceId(0, 0);
        attributeArray.recycle();
        this.disableView = (CheckedTextView)inflater.inflate(17367055, root, false);
        this.disableView.setBackgroundResource(selectableItemBackgroundResourceId);
        this.disableView.setText(R.string.selection_disabled);
        this.disableView.setFocusable(true);
        this.disableView.setOnClickListener((View.OnClickListener)this);
        root.addView((View)this.disableView);
        this.defaultView = (CheckedTextView)inflater.inflate(17367055, root, false);
        this.defaultView.setBackgroundResource(selectableItemBackgroundResourceId);
        this.defaultView.setText(R.string.selection_default);
        this.defaultView.setFocusable(true);
        this.defaultView.setOnClickListener((View.OnClickListener)this);
        root.addView(inflater.inflate(R.layout.list_divider, root, false));
        root.addView((View)this.defaultView);
        boolean haveSupportedTracks = false;
        boolean haveAdaptiveTracks = false;
        this.trackViews = new CheckedTextView[this.trackGroups.length][];
        for (int groupIndex = 0; groupIndex < this.trackGroups.length; ++groupIndex) {
            TrackGroup group = this.trackGroups.get(groupIndex);
            boolean groupIsAdaptive = this.trackGroupsAdaptive[groupIndex];
            haveAdaptiveTracks |= groupIsAdaptive;
            this.trackViews[groupIndex] = new CheckedTextView[group.length];
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                if (trackIndex == 0) {
                    root.addView(inflater.inflate(R.layout.list_divider, root, false));
                }
                int trackViewLayoutId = groupIsAdaptive ? 0x1090010 : 17367055;
                CheckedTextView trackView = (CheckedTextView)inflater.inflate(trackViewLayoutId, root, false);
                trackView.setBackgroundResource(selectableItemBackgroundResourceId);
                trackView.setText((CharSequence)ExoUtils.buildTrackName(group.getFormat(trackIndex)));
                if (this.trackInfo.getTrackFormatSupport(this.rendererIndex, groupIndex, trackIndex) == 3) {
                    trackView.setFocusable(true);
                    trackView.setTag((Object)Pair.create((Object)groupIndex, (Object)trackIndex));
                    trackView.setOnClickListener((View.OnClickListener)this);
                    haveSupportedTracks = true;
                } else {
                    trackView.setFocusable(false);
                    trackView.setEnabled(false);
                }
                this.trackViews[groupIndex][trackIndex] = trackView;
                root.addView((View)trackView);
            }
        }
        if (!haveSupportedTracks) {
            this.defaultView.setText(R.string.selection_default_none);
        } else if (haveAdaptiveTracks) {
            this.enableRandomAdaptationView = (CheckedTextView)inflater.inflate(0x1090010, root, false);
            this.enableRandomAdaptationView.setBackgroundResource(selectableItemBackgroundResourceId);
            this.enableRandomAdaptationView.setText(R.string.enable_random_adaptation);
            this.enableRandomAdaptationView.setOnClickListener((View.OnClickListener)this);
            root.addView(inflater.inflate(R.layout.list_divider, root, false));
            root.addView((View)this.enableRandomAdaptationView);
        }
        this.updateViews();
        return view;
    }

    private void updateViews() {
        this.disableView.setChecked(this.isDisabled);
        this.defaultView.setChecked(!this.isDisabled && this.override == null);
        for (int i = 0; i < this.trackViews.length; ++i) {
            for (int j = 0; j < this.trackViews[i].length; ++j) {
                this.trackViews[i][j].setChecked(this.override != null && this.override.groupIndex == i && this.override.containsTrack(j));
            }
        }
        if (this.enableRandomAdaptationView != null) {
            boolean enableView = !this.isDisabled && this.override != null && this.override.length > 1;
            this.enableRandomAdaptationView.setEnabled(enableView);
            this.enableRandomAdaptationView.setFocusable(enableView);
            if (enableView) {
                this.enableRandomAdaptationView.setChecked(!this.isDisabled && this.override.factory instanceof RandomTrackSelection.Factory);
            }
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        this.selector.setRendererDisabled(this.rendererIndex, this.isDisabled);
        if (this.override != null) {
            this.selector.setSelectionOverride(this.rendererIndex, this.trackGroups, this.override);
        } else {
            this.selector.clearSelectionOverrides(this.rendererIndex);
        }
    }

    public void onClick(View view) {
        if (view == this.disableView) {
            this.isDisabled = true;
            this.override = null;
        } else if (view == this.defaultView) {
            this.isDisabled = false;
            this.override = null;
        } else if (view == this.enableRandomAdaptationView) {
            this.setOverride(this.override.groupIndex, this.override.tracks, !this.enableRandomAdaptationView.isChecked());
        } else {
            this.isDisabled = false;
            Pair tag = (Pair)view.getTag();
            int groupIndex = (Integer)tag.first;
            int trackIndex = (Integer)tag.second;
            if (!this.trackGroupsAdaptive[groupIndex] || this.override == null || this.override.groupIndex != groupIndex) {
                this.override = new MappingTrackSelector.SelectionOverride(FIXED_FACTORY, groupIndex, new int[]{trackIndex});
            } else {
                boolean isEnabled = ((CheckedTextView)view).isChecked();
                int overrideLength = this.override.length;
                if (isEnabled) {
                    if (overrideLength == 1) {
                        this.override = null;
                        this.isDisabled = true;
                    } else {
                        this.setOverride(groupIndex, TrackSelectionHelper.getTracksRemoving(this.override, trackIndex), this.enableRandomAdaptationView.isChecked());
                    }
                } else {
                    this.setOverride(groupIndex, TrackSelectionHelper.getTracksAdding(this.override, trackIndex), this.enableRandomAdaptationView.isChecked());
                }
            }
        }
        this.updateViews();
    }

    private void setOverride(int group, int[] tracks, boolean enableRandomAdaptation) {
        TrackSelection.Factory factory = tracks.length == 1 ? FIXED_FACTORY : (enableRandomAdaptation ? RANDOM_FACTORY : this.adaptiveTrackSelectionFactory);
        this.override = new MappingTrackSelector.SelectionOverride(factory, group, tracks);
    }
}

