/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import jcifs.util.Hexdump;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIObjectId;

class PingObject
extends NdrObject {
    int opnum = -1;
    List<JIObjectId> listOfAdds = new ArrayList<JIObjectId>();
    List<JIObjectId> listOfDels = new ArrayList<JIObjectId>();
    byte[] setId = null;
    int seqNum = 0;

    PingObject() {
    }

    public int getOpnum() {
        return this.opnum;
    }

    public void write(NetworkDataRepresentation ndr) {
        switch (this.opnum) {
            case 2: {
                int newlength = 22 + this.listOfAdds.size() * 8 + 8 + this.listOfDels.size() * 8 + 16;
                if (newlength > ndr.getBuffer().buf.length) {
                    ndr.getBuffer().buf = new byte[newlength + 16];
                }
                if (this.setId == null) {
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().info("Complex Ping going for the first time, will get the setId as response of this call ");
                    }
                    this.setId = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                } else if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "Complex Ping going for setId: {0}", Hexdump.toHexString((byte[])this.setId));
                }
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "Complex ping going : listOfAdds -> Size : {0} , {1}", new Object[]{this.listOfAdds.size(), this.listOfAdds});
                    JISystem.getLogger().log(Level.INFO, "listOfDels -> Size : {0} , {1}", new Object[]{this.listOfDels.size(), this.listOfDels});
                }
                JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.setId);
                JIMarshalUnMarshalHelper.serialize(ndr, Short.class, (short)this.seqNum, null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Short.class, (short)this.listOfAdds.size(), null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Short.class, (short)this.listOfDels.size(), null, 0);
                if (this.listOfAdds.size() > 0) {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Object().hashCode(), null, 0);
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, this.listOfAdds.size(), null, 0);
                    for (int i = 0; i < this.listOfAdds.size(); ++i) {
                        JIObjectId oid = this.listOfAdds.get(i);
                        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, oid.getOID());
                    }
                } else {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, null, 0);
                }
                if (this.listOfDels.size() > 0) {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Object().hashCode(), null, 0);
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, this.listOfDels.size(), null, 0);
                    double index = new Integer(ndr.getBuffer().getIndex()).doubleValue();
                    long k = Math.round(index % 8.0);
                    k = k == 0L ? 0L : 8L - k;
                    ndr.writeOctetArray(new byte[(int)k], 0, (int)k);
                    for (int i = 0; i < this.listOfDels.size(); ++i) {
                        JIObjectId oid = this.listOfDels.get(i);
                        JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, oid.getOID());
                    }
                } else {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, null, 0);
                }
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, null, 0);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, null, 0);
                break;
            }
            case 1: {
                if (this.setId != null) {
                    JIMarshalUnMarshalHelper.writeOctetArrayLE(ndr, this.setId);
                    if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                    JISystem.getLogger().log(Level.INFO, "Simple Ping going for setId: {0}", Hexdump.toHexString((byte[])this.setId));
                    break;
                }
                if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                JISystem.getLogger().info("Some error ! Simple ping requested , but has no setID ");
                break;
            }
        }
    }

    public void read(NetworkDataRepresentation ndr) {
        switch (this.opnum) {
            case 2: {
                this.setId = JIMarshalUnMarshalHelper.readOctetArrayLE(ndr, 8);
                JIMarshalUnMarshalHelper.deSerialize(ndr, Short.class, null, 0, null);
                int hresult = ((Number)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null)).intValue();
                if (hresult != 0) {
                    if (!JISystem.getLogger().isLoggable(Level.SEVERE)) break;
                    JISystem.getLogger().log(Level.SEVERE, "Some error ! Complex ping failed , hresult: {0}", hresult);
                    break;
                }
                if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                JISystem.getLogger().log(Level.INFO, "Complex Ping Succeeded,  setId is : {0}", Hexdump.toHexString((byte[])this.setId));
                break;
            }
            case 1: {
                int hresult = ((Number)JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, null, 0, null)).intValue();
                if (hresult != 0) {
                    if (!JISystem.getLogger().isLoggable(Level.SEVERE)) break;
                    JISystem.getLogger().log(Level.SEVERE, "Some error ! Simple ping failed , hresult: {0}", hresult);
                    break;
                }
                if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                JISystem.getLogger().info("Simple Ping Succeeded");
                break;
            }
        }
    }
}

