/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.IdentifierFactory;
import com.iwombat.util.GUIDUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIComOxidDetails;
import org.jinterop.dcom.core.JIComOxidRuntimeHelper;
import org.jinterop.dcom.core.JIComOxidStub;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JISetId;
import org.jinterop.dcom.core.JIStdObjRef;

final class JIComOxidRuntime {
    private static final Properties defaults = new Properties();
    private static final Properties defaults2 = new Properties();
    private static boolean stopSystem = false;
    private static boolean resolverStarted = false;
    private static int oxidResolverPort = -1;
    private static final Map<String, JIComOxidDetails> mapOfIPIDVsComponent = new HashMap<String, JIComOxidDetails>();
    private static final Map<JILocalCoClass, JIComOxidDetails> mapOfJavaVsOxidDetails = new HashMap<JILocalCoClass, JIComOxidDetails>();
    private static final Map<JIOxid, JIComOxidDetails> mapOfOxidVsOxidDetails = new HashMap<JIOxid, JIComOxidDetails>();
    private static final Map<JIObjectId, JILocalCoClass> mapOfOIDVsComponents = new HashMap<JIObjectId, JILocalCoClass>();
    private static final Map<Integer, List<JIObjectId>> mapOfSessionIdsVsOIDs = new HashMap<Integer, List<JIObjectId>>();
    private static final Map<JISetId, List<JIObjectId>> mapOfSetIdVsListOfOIDs = new HashMap<JISetId, List<JIObjectId>>();
    private static final Map<JISession, PingSetHolder> mapOfSessionVsPingSetHolder = new HashMap<JISession, PingSetHolder>();
    private static final Map<String, JIComOxidStub> mapOfAddressVsStub = new HashMap<String, JIComOxidStub>();
    private static final List<JILocalCoClass> listOfExportedJavaComponents = new ArrayList<JILocalCoClass>();
    private static final Object mutex2 = new Object();
    private static final Object mutex3 = new Object();
    private static final Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private static final Timer pingTimer_2minutes = new Timer(true);
    private static final Timer pingTimer_8minutes = new Timer(true);
    private static final Object mutex4 = new Object();
    private static ServerSocket serverSocket = null;
    static final Object mutex = new Object();

    private JIComOxidRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroySessionOIDs(int sessionId) {
        Object object = mutex2;
        synchronized (object) {
            List<JIObjectId> oids;
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().log(Level.INFO, "destroySessionOIDs for session: {0}", sessionId);
            }
            if ((oids = mapOfSessionIdsVsOIDs.remove(sessionId)) == null || oids.isEmpty()) {
                return;
            }
            for (int i = 0; i < oids.size(); ++i) {
                JIObjectId oid = oids.get(i);
                JILocalCoClass component = mapOfOIDVsComponents.remove(oid);
                JIComOxidDetails details = mapOfJavaVsOxidDetails.get(component);
                if (details != null) {
                    mapOfOxidVsOxidDetails.remove(details.getOxid());
                    mapOfIPIDVsComponent.remove(details.getIpid());
                }
                mapOfJavaVsOxidDetails.remove(component);
                listOfExportedJavaComponents.remove(component);
                if (details == null) continue;
                details.interruptRemUnknownThreadGroup();
            }
            oids.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUpdateOXIDs(JISession session, String IPID, JIObjectId oid) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = mapOfSessionVsPingSetHolder.get(session);
            if (holder == null) {
                holder = new PingSetHolder();
                holder.username = session.getUserName();
                holder.password = session.getPassword();
                holder.domain = session.getDomain();
                holder.currentSetOIDs.put(oid, oid);
                holder.modified = true;
                holder.seqNum = 0;
                mapOfSessionVsPingSetHolder.put(session, holder);
            } else {
                JIObjectId oid2 = holder.currentSetOIDs.get(oid);
                if (oid2 != null) {
                    oid = oid2;
                } else {
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().log(Level.INFO, "addUpdateOXIDs: Adding OID to holder {0}, current size of currentSetOIDs is {1}", new Object[]{holder, holder.currentSetOIDs.size()});
                    }
                    holder.currentSetOIDs.put(oid, oid);
                    holder.modified = true;
                }
            }
            oid.incrementIPIDRefCountBy1();
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().log(Level.INFO, "addUpdateOXIDs: finally this oid is {0}", oid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delIPIDReference(String IPID, JIObjectId oid, JISession session) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = mapOfSessionVsPingSetHolder.get(session);
            if (holder != null) {
                JIObjectId oid2 = holder.currentSetOIDs.get(oid);
                if (oid2 == null) {
                    if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                        JISystem.getLogger().log(Level.WARNING, "In delIPIDReference: Could not find Original OID for this temp OID for session: {0} , temp oid is {1} , and IPID is {2}", new Object[]{session.getSessionIdentifier(), oid, IPID});
                    }
                    return;
                }
                oid = oid2;
                oid.decrementIPIDRefCountBy1();
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "delIPIDReference: Decrementing reference count for IPID {0} on OID {1}", new Object[]{IPID, oid});
                }
                if (oid.getIPIDRefCount() <= 0) {
                    holder.currentSetOIDs.remove(oid);
                    if (holder.currentSetOIDs.isEmpty()) {
                        holder.closed = true;
                        mapOfSessionVsPingSetHolder.remove(session);
                    }
                    if (JISystem.getLogger().isLoggable(Level.INFO)) {
                        JISystem.getLogger().log(Level.INFO, "delIPIDReference: sessionid {0}Ref count is <= 0, for OID {1}, holder status: {2}", new Object[]{session.getSessionIdentifier(), oid, holder.closed});
                    }
                }
            } else if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                JISystem.getLogger().log(Level.WARNING, "In delIPIDReference: Could not find PingSetHolder for this session: {0} , temp oid is {1} , and IPID is {2}", new Object[]{session.getSessionIdentifier(), oid, IPID});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearIPIDsforSession(JISession session) {
        Object object = mutex3;
        synchronized (object) {
            PingSetHolder holder = mapOfSessionVsPingSetHolder.get(session);
            if (holder != null) {
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "clearIPIDsforSession: holder.currentSetOIDs''s size is {0}", holder.currentSetOIDs.size());
                }
                holder.modified = true;
                holder.currentSetOIDs.clear();
                holder.closed = true;
                mapOfSessionVsPingSetHolder.remove(session);
            }
        }
        object = mutex4;
        synchronized (object) {
            JIComOxidStub stub = mapOfAddressVsStub.remove(session.getTargetServer());
            if (stub != null) {
                stub.close();
            }
        }
    }

    static synchronized void startResolverTimer() {
        pingTimer_2minutes.scheduleAtFixedRate((TimerTask)new ClientPingTimerTask(), 0L, 240000L);
        if (JISystem.isJavaCoClassAutoCollectionSet()) {
            pingTimer_8minutes.scheduleAtFixedRate((TimerTask)new ServerPingTimerTask(), 0L, 480000L);
        }
    }

    static synchronized void startResolver() {
        if (resolverStarted) {
            return;
        }
        Runnable thread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                    serverSocket = serverSocketChannel.socket();
                    serverSocket.bind(null);
                    oxidResolverPort = serverSocket.getLocalPort();
                    while (!stopSystem) {
                        Socket socket = serverSocket.accept();
                        Object object = mutex;
                        synchronized (object) {
                            JISystem.internal_setSocket(socket);
                            Properties properties = new Properties(defaults);
                            properties.put("IID", "99fcfec4-5260-101b-bbcb-00aa0021347a:0.0".toUpperCase());
                            JIComOxidRuntimeHelper oxidResolver = new JIComOxidRuntimeHelper(properties);
                            oxidResolver.startOxid(socket.getLocalPort(), socket.getPort());
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread thread2 = new Thread(thread, "jI_OxidResolver");
        thread2.setDaemon(true);
        thread2.start();
        resolverStarted = true;
    }

    static int getOxidResolverPort() {
        return oxidResolverPort;
    }

    static synchronized void stopResolver() {
        stopSystem = true;
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pingTimer_2minutes.cancel();
        pingTimer_8minutes.cancel();
        for (JIComOxidStub s : mapOfAddressVsStub.values()) {
            s.close();
        }
        mapOfAddressVsStub.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIInterfacePointer getInterfacePointer(JISession session, JILocalCoClass component) throws JIException {
        JIInterfacePointer ptr = null;
        Object object = mutex2;
        synchronized (object) {
            if (component.isAlreadyExported()) {
                throw new JIException(4163);
            }
            component.setSession(session);
            String ipid = GUIDUtil.guidStringFromHexString((String)IdentifierFactory.createUniqueIdentifier().toHexString());
            String iid = component.isCoClassUnderRealIID() ? component.getCoClassIID() : "00000000-0000-0000-c000-000000000046";
            byte[] bytes = new byte[8];
            randomGen.nextBytes(bytes);
            JIOxid oxid = new JIOxid(bytes);
            byte[] bytes2 = new byte[8];
            randomGen.nextBytes(bytes2);
            JIObjectId oid = new JIObjectId(bytes2, false);
            component.setObjectId(oid.getOID());
            JIStdObjRef objref = new JIStdObjRef(ipid, oxid, oid);
            ptr = new JIInterfacePointer(iid, oxidResolverPort, objref);
            Properties properties = new Properties(defaults2);
            properties.put("IID", "00000131-0000-0000-C000-000000000046:0.0".toUpperCase());
            properties.put("rpc.ntlm.domain", session.getTargetServer());
            int protecttionLevel = 2;
            if (session.isSessionSecurityEnabled()) {
                protecttionLevel = 6;
                properties.setProperty("rpc.ntlm.seal", "true");
                properties.setProperty("rpc.ntlm.sign", "true");
                properties.setProperty("rpc.ntlm.keyExchange", "true");
                properties.setProperty("rpc.ntlm.keyLength", "128");
                properties.setProperty("rpc.ntlm.ntlm2", "true");
                properties.setProperty("rpc.security.username", session.getUserName());
                properties.setProperty("rpc.security.password", session.getPassword());
                properties.setProperty("rpc.ntlm.ntlm2", "true");
            }
            if (session.isNTLMv2Enabled()) {
                properties.setProperty("rpc.ntlm.ntlmv2", "true");
            }
            JIComOxidRuntimeHelper remUnknown = new JIComOxidRuntimeHelper(properties);
            JIComOxidDetails details = new JIComOxidDetails(component, oxid, oid, iid, ipid, ptr, remUnknown, protecttionLevel);
            mapOfJavaVsOxidDetails.put(component, details);
            mapOfOxidVsOxidDetails.put(oxid, details);
            mapOfOIDVsComponents.put(oid, component);
            listOfExportedJavaComponents.add(component);
            mapOfIPIDVsComponent.put(ipid, details);
            List<JIObjectId> oids = mapOfSessionIdsVsOIDs.get(session.getSessionIdentifier());
            if (oids == null) {
                oids = new ArrayList<JIObjectId>();
                mapOfSessionIdsVsOIDs.put(session.getSessionIdentifier(), oids);
            }
            oids.add(oid);
            component.setAssociatedInterfacePointer(ptr);
        }
        return ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIComOxidDetails getOxidDetails(JIOxid oxid) {
        Object object = mutex2;
        synchronized (object) {
            return mapOfOxidVsOxidDetails.get(oxid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JIComOxidDetails getComponentFromIPID(String ipid) {
        Object object = mutex2;
        synchronized (object) {
            return mapOfIPIDVsComponent.get(ipid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUpdateSets(JISetId setId, List<JIObjectId> objectIdsAdded, List<JIObjectId> objectIdsDel) {
        Object object = mutex2;
        synchronized (object) {
            List<JIObjectId> listOfOIDs = mapOfSetIdVsListOfOIDs.get(setId);
            if (listOfOIDs == null) {
                listOfOIDs = new ArrayList<JIObjectId>();
                listOfOIDs.addAll(objectIdsAdded);
                mapOfSetIdVsListOfOIDs.put(setId, listOfOIDs);
            } else {
                for (int i = 0; i < listOfOIDs.size(); ++i) {
                    JIObjectId oid = listOfOIDs.get(i);
                    if (objectIdsDel.contains(oid)) continue;
                    oid.updateLastPingTime();
                }
                listOfOIDs.addAll(objectIdsAdded);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JILocalCoClass getJavaComponentFromIPID(String ipid) {
        JILocalCoClass component = null;
        Object object = mutex2;
        synchronized (object) {
            for (int i = 0; i < listOfExportedJavaComponents.size() && (component = listOfExportedJavaComponents.get(i)).getIIDFromIpid(ipid) == null; ++i) {
                component = null;
            }
        }
        return component;
    }

    static {
        defaults2.put("rpc.ntlm.lanManagerKey", "false");
        defaults2.put("rpc.ntlm.sign", "false");
        defaults2.put("rpc.ntlm.seal", "false");
        defaults2.put("rpc.ntlm.keyExchange", "false");
        defaults2.put("rpc.connectionContext", "org.jinterop.dcom.transport.JIComRuntimeNTLMConnectionContext");
        defaults.put("rpc.connectionContext", "org.jinterop.dcom.transport.JIComRuntimeConnectionContext");
    }

    private static class PingSetHolder {
        byte[] setId = null;
        String username = null;
        String password = null;
        String domain = null;
        boolean modified = false;
        boolean closed = false;
        int seqNum = 1;
        Map<JIObjectId, JIObjectId> currentSetOIDs = new HashMap<JIObjectId, JIObjectId>();
        Map<JIObjectId, JIObjectId> pingedOnce = new HashMap<JIObjectId, JIObjectId>();

        private PingSetHolder() {
        }

        public String toString() {
            return "SetID[" + Arrays.toString(this.setId) + "] , currentSetOIDs[" + this.currentSetOIDs + "]";
        }
    }

    private static class ClientPingTimerTask
    extends TimerTask {
        private ClientPingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator itr;
            Object object = mutex3;
            synchronized (object) {
                itr = new HashMap(mapOfSessionVsPingSetHolder).entrySet().iterator();
            }
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().info("Running ClientPingTimerTask !");
            }
            while (itr.hasNext()) {
                int n;
                JIComOxidStub stub;
                Map.Entry entry = itr.next();
                PingSetHolder holder = (PingSetHolder)entry.getValue();
                String address = ((JISession)entry.getKey()).getTargetServer();
                Object object2 = mutex4;
                synchronized (object2) {
                    stub = (JIComOxidStub)((Object)mapOfAddressVsStub.get(address));
                    if (stub == null) {
                        stub = new JIComOxidStub(address, holder.domain, holder.username, holder.password);
                        mapOfAddressVsStub.put(address, stub);
                    }
                }
                ArrayList<JIObjectId> listOfAddedOIDs = new ArrayList<JIObjectId>();
                ArrayList<JIObjectId> listOfRemovedOIDs = new ArrayList<JIObjectId>();
                Object object3 = mutex3;
                synchronized (object3) {
                    Iterator<JIObjectId> itr2 = holder.currentSetOIDs.keySet().iterator();
                    while (itr2.hasNext()) {
                        JIObjectId oid = itr2.next();
                        if (oid.getIPIDRefCount() == 0) {
                            if (!oid.dontping) {
                                listOfRemovedOIDs.add(oid);
                                holder.pingedOnce.remove(oid);
                                holder.modified = true;
                            }
                            itr2.remove();
                            continue;
                        }
                        if (oid.dontping || holder.pingedOnce.containsKey(oid)) continue;
                        listOfAddedOIDs.add(oid);
                        holder.pingedOnce.put(oid, oid);
                        holder.modified = true;
                    }
                }
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "Within ClientPingTimerTask: holder.currentSetOIDs, current size of which is {0}", holder.currentSetOIDs.size());
                }
                if (holder.setId == null) {
                    listOfRemovedOIDs.clear();
                }
                boolean isSimplePing = false;
                if (holder.setId != null && !holder.modified) {
                    isSimplePing = true;
                }
                byte[] byArray = holder.setId;
                if (isSimplePing) {
                    n = 0;
                } else {
                    int n2 = holder.seqNum;
                    n = n2;
                    holder.seqNum = n2 + 1;
                }
                holder.setId = stub.call(isSimplePing, byArray, listOfAddedOIDs, listOfRemovedOIDs, n);
                if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                    JISystem.getLogger().log(Level.INFO, "Within ClientPingTimerTask: holder.seqNum {0}", holder.seqNum);
                }
                holder.modified = false;
                if (!holder.closed) continue;
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "Within ClientPingTimerTask: Holder {0} is empty, will remove this from mapOfSessionVsPingSetHolder", holder);
                }
                itr.remove();
                Object object4 = mutex3;
                synchronized (object4) {
                    mapOfSessionVsPingSetHolder.remove(entry.getKey());
                }
            }
        }
    }

    private static class ServerPingTimerTask
    extends TimerTask {
        private ServerPingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = mutex2;
            synchronized (object) {
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().info("Running ServerPingTimerTask !");
                }
                Iterator itr = mapOfOIDVsComponents.keySet().iterator();
                while (itr.hasNext()) {
                    JILocalCoClass component;
                    JIObjectId oid = (JIObjectId)itr.next();
                    if (!oid.hasExpired() || (component = (JILocalCoClass)mapOfOIDVsComponents.get(oid)).isAssociatedReferenceAlive()) continue;
                    JIComOxidDetails details = (JIComOxidDetails)mapOfJavaVsOxidDetails.get(component);
                    mapOfOxidVsOxidDetails.remove(details.getOxid());
                    mapOfIPIDVsComponent.remove(details.getIpid());
                    mapOfJavaVsOxidDetails.remove(component);
                    listOfExportedJavaComponents.remove(component);
                    itr.remove();
                    details.interruptRemUnknownThreadGroup();
                }
            }
        }
    }
}

