/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIFrameworkHelper;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIOrpcThat;
import org.jinterop.dcom.core.JIOrpcThis;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIVariant;
import rpc.core.UUID;

public class JICallBuilder
extends NdrObject
implements Serializable {
    private static final long serialVersionUID = -2939657500731135110L;
    static final String CURRENTSESSION = "CURRENTSESSION";
    static final String COMOBJECTS = "COMOBJECTS";
    private int opnum = -1;
    private Object[] outparams = null;
    private boolean dispatchNotSupported = false;
    private String enclosingParentsIPID = null;
    private List<Integer> inparamFlags = new ArrayList<Integer>();
    private List<Integer> outparamFlags = new ArrayList<Integer>();
    private List<Object> inParams = new ArrayList<Object>();
    private List<Object> outParams = new ArrayList<Object>();
    private int hresult = 0;
    private boolean executed = false;
    private Object[] resultsOfException = null;
    private JISession session = null;
    boolean fromDestroySession = false;

    public JICallBuilder(boolean dispatchNotSupported) {
        this();
        this.dispatchNotSupported = dispatchNotSupported;
    }

    public JICallBuilder() {
    }

    public void reInit() {
        this.opnum = -1;
        this.inParams = new ArrayList<Object>();
        this.inparamFlags = new ArrayList<Integer>();
        this.outParams = new ArrayList<Object>();
        this.outparamFlags = new ArrayList<Integer>();
        this.hresult = -1;
        this.outparams = null;
        this.executed = false;
    }

    void setParentIpid(String IPIDofParent) {
        this.enclosingParentsIPID = IPIDofParent;
    }

    String getParentIpid() {
        return this.enclosingParentsIPID;
    }

    public void addInParamAsComObject(IJIComObject comObject, int FLAGS) {
        this.insertInParamAsComObjectAt(this.inParams.size(), comObject, FLAGS);
    }

    public void addInParamAsInt(int value, int FLAGS) {
        this.insertInParamAsIntAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsUnsigned(IJIUnsigned value, int FLAGS) {
        this.insertInParamAsUnsignedAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsFloat(float value, int FLAGS) {
        this.insertInParamAsFloatAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsBoolean(boolean value, int FLAGS) {
        this.insertInParamAsBooleanAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsShort(short value, int FLAGS) {
        this.insertInParamAsShortAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsDouble(double value, int FLAGS) {
        this.insertInParamAsDoubleAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsCharacter(char value, int FLAGS) {
        this.insertInParamAsCharacterAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsString(String value, int FLAGS) {
        this.insertInParamAsStringAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsVariant(JIVariant value, int FLAGS) {
        this.insertInParamAsVariantAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsObject(Object value, int FLAGS) {
        this.insertInParamAsObjectAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsUUID(String value, int FLAGS) {
        this.insertInParamAsUUIDAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsPointer(JIPointer value, int FLAGS) {
        this.insertInParamAsPointerAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsStruct(JIStruct value, int FLAGS) {
        this.insertInParamAsStructAt(this.inParams.size(), value, FLAGS);
    }

    public void addInParamAsArray(JIArray value, int FLAGS) {
        this.insertInParamAsArrayAt(this.inParams.size(), value, FLAGS);
    }

    public void setInParams(Object[] values, int FLAGS) {
        for (Object value1 : values) {
            this.inParams.add(value1);
            this.inparamFlags.add(FLAGS);
        }
    }

    public void insertInParamAsComObjectAt(int index, IJIComObject value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsIntAt(int index, int value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsUnsignedAt(int index, IJIUnsigned value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsFloatAt(int index, float value, int FLAGS) {
        this.inParams.add(index, Float.valueOf(value));
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsBooleanAt(int index, boolean value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsShortAt(int index, short value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsDoubleAt(int index, double value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsCharacterAt(int index, char value, int FLAGS) {
        this.inParams.add(index, Character.valueOf(value));
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsStringAt(int index, String value, int FLAGS) {
        this.inParams.add(index, new JIString(value, FLAGS));
        this.inparamFlags.add(index, 0);
    }

    public void insertInParamAsVariantAt(int index, JIVariant value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, 0);
    }

    public void insertInParamAsObjectAt(int index, Object value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsUUIDAt(int index, String value, int FLAGS) {
        this.inParams.add(index, new UUID(value));
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsPointerAt(int index, JIPointer value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsStructAt(int index, JIStruct value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void insertInParamAsArrayAt(int index, JIArray value, int FLAGS) {
        this.inParams.add(index, value);
        this.inparamFlags.add(index, FLAGS);
    }

    public void removeInParamAt(int index, int FLAGS) {
        Object value = this.inParams.remove(index);
        this.inparamFlags.remove(index);
    }

    public Object getInParamAt(int index) {
        return this.inParams.get(index);
    }

    public void addOutParamAsType(Class<?> clazz, int FLAGS) {
        this.insertOutParamAt(this.outParams.size(), clazz, FLAGS);
    }

    public void addOutParamAsObject(Object outparam, int FLAGS) {
        this.insertOutParamAt(this.outParams.size(), outparam, FLAGS);
    }

    public void insertOutParamAt(int index, Object classOrInstance, int FLAGS) {
        this.outParams.add(index, classOrInstance);
        this.outparamFlags.add(index, FLAGS);
    }

    public Object getOutParamAt(int index) {
        return this.outParams.get(index);
    }

    public void removeOutParamAt(int index, int FLAGS) {
        this.outParams.remove(index);
        this.outparamFlags.remove(index);
    }

    public void setOutParams(Object[] values, int FLAGS) {
        for (int i = 0; i < values.length; ++i) {
            this.outParams.add(values[i]);
            this.outparamFlags.add(FLAGS);
        }
    }

    public Object[] getResults() {
        return this.outparams;
    }

    public int getResultAsIntAt(int index) {
        this.checkIfCalled();
        return ((Number)this.outparams[index]).intValue();
    }

    public float getResultAsFloatAt(int index) {
        this.checkIfCalled();
        return ((Number)this.outparams[index]).floatValue();
    }

    public boolean getResultAsBooleanAt(int index) {
        this.checkIfCalled();
        return (Boolean)this.outparams[index];
    }

    public short getResultAsShortAt(int index) {
        this.checkIfCalled();
        return ((Number)this.outparams[index]).shortValue();
    }

    public double getResultAsDoubleAt(int index) {
        this.checkIfCalled();
        return ((Number)this.outparams[index]).doubleValue();
    }

    public char getResultAsCharacterAt(int index) {
        this.checkIfCalled();
        return ((Character)this.outparams[index]).charValue();
    }

    public JIString getResultAsStringAt(int index) {
        this.checkIfCalled();
        return (JIString)this.outparams[index];
    }

    public JIVariant getResultAsVariantAt(int index) {
        this.checkIfCalled();
        return (JIVariant)this.outparams[index];
    }

    public String getResultAsUUIDStrAt(int index) {
        this.checkIfCalled();
        return this.outparams[index].toString();
    }

    public JIPointer getResultAsPointerAt(int index) {
        this.checkIfCalled();
        return (JIPointer)this.outparams[index];
    }

    public JIStruct getResultAsStructAt(int index) {
        this.checkIfCalled();
        return (JIStruct)this.outparams[index];
    }

    public JIArray getResultAsArrayAt(int index) {
        this.checkIfCalled();
        return (JIArray)this.outparams[index];
    }

    public Object[] getResultsInCaseOfException() {
        return this.resultsOfException;
    }

    public int getHRESULT() {
        return this.hresult;
    }

    private void checkIfCalled() {
        if (!this.executed) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4098));
        }
    }

    public Object[] getInParams() {
        return this.inParams.toArray();
    }

    public Object[] getOutParams() {
        return this.outParams.toArray();
    }

    public Integer[] getInparamFlags() {
        return this.inparamFlags.toArray(new Integer[this.inparamFlags.size()]);
    }

    public Integer[] getOutparamFlags() {
        return this.outparamFlags.toArray(new Integer[this.outparamFlags.size()]);
    }

    public int getOpnum() {
        return this.opnum;
    }

    public void setOpnum(int num) {
        int dispatch = 0;
        if (!this.dispatchNotSupported) {
            dispatch = 4;
        }
        this.opnum = dispatch + num + 3;
    }

    void write2(NetworkDataRepresentation ndr) {
        ndr.getBuffer().buf = new byte[this.bufferLength() + 16 + 30];
        JIOrpcThat.encode(ndr);
        this.writePacket(ndr);
    }

    public void write(NetworkDataRepresentation ndr) {
        ndr.getBuffer().buf = new byte[this.bufferLength() + 16];
        JIOrpcThis orpcthis = new JIOrpcThis();
        orpcthis.encode(ndr);
        this.writePacket(ndr);
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(0);
        ndr.writeUnsignedLong(0);
    }

    private void writePacket(NetworkDataRepresentation ndr) {
        if (this.session == null) {
            throw new IllegalStateException("Programming Error ! Session not attached with this call ! ... Please rectify ! ");
        }
        Object[] inparams = this.inParams.toArray();
        if (inparams != null) {
            for (int index = 0; index < inparams.length; ++index) {
                ArrayList<JIPointer> listOfDefferedPointers = new ArrayList<JIPointer>();
                if (inparams[index] == null) {
                    JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, 0, listOfDefferedPointers, 0);
                } else {
                    JIMarshalUnMarshalHelper.serialize(ndr, inparams[index].getClass(), inparams[index], listOfDefferedPointers, ((Number)this.inparamFlags.get(index)).intValue());
                }
                int x = 0;
                while (x < listOfDefferedPointers.size()) {
                    ArrayList<JIPointer> newList = new ArrayList<JIPointer>();
                    JIMarshalUnMarshalHelper.serialize(ndr, JIPointer.class, (JIPointer)listOfDefferedPointers.get(x), newList, ((Number)this.inparamFlags.get(index)).intValue());
                    listOfDefferedPointers.addAll(++x, newList);
                }
            }
        }
    }

    public void read(NetworkDataRepresentation ndr) {
        JIOrpcThat orpcThat = JIOrpcThat.decode(ndr);
        this.readPacket(ndr, false);
        this.readResult(ndr);
    }

    void read2(NetworkDataRepresentation ndr) {
        JIOrpcThis.decode(ndr);
        this.readPacket(ndr, true);
    }

    private void readPacket(NetworkDataRepresentation ndr, boolean fromCallback) {
        if (this.session == null) {
            throw new IllegalStateException("Programming Error ! Session not attached with this call ! ... Please rectify ! ");
        }
        int index = 0;
        this.outparams = this.outParams.toArray();
        if (JISystem.getLogger().isLoggable(Level.FINEST)) {
            String str = "";
            for (int i = 0; i < this.outparams.length; ++i) {
                str = str + "Out Param:[" + i + "]" + this.outparams[i] + "\n";
            }
            JISystem.getLogger().finest(str);
        }
        ArrayList comObjects = new ArrayList();
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        additionalData.put(CURRENTSESSION, this.session);
        additionalData.put(COMOBJECTS, comObjects);
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.outparams != null && this.outparams.length > 0) {
            while (index < this.outparams.length) {
                ArrayList<JIPointer> listOfDefferedPointers = new ArrayList<JIPointer>();
                results.add(JIMarshalUnMarshalHelper.deSerialize(ndr, this.outparams[index], listOfDefferedPointers, this.outparamFlags.get(index), additionalData));
                int x = 0;
                while (x < listOfDefferedPointers.size()) {
                    ArrayList<JIPointer> newList = new ArrayList<JIPointer>();
                    JIPointer replacement = (JIPointer)JIMarshalUnMarshalHelper.deSerialize(ndr, listOfDefferedPointers.get(x), newList, this.outparamFlags.get(index), additionalData);
                    ((JIPointer)listOfDefferedPointers.get(x)).replaceSelfWithNewPointer(replacement);
                    listOfDefferedPointers.addAll(++x, newList);
                }
                ++index;
            }
            for (int i = 0; i < comObjects.size(); ++i) {
                JIComObjectImpl comObjectImpl = (JIComObjectImpl)comObjects.get(i);
                try {
                    IJIComObject comObject;
                    if (fromCallback) {
                        JISession newsession = JISession.createSession(this.session);
                        newsession.setGlobalSocketTimeout(this.session.getGlobalSocketTimeout());
                        newsession.useSessionSecurity(this.session.isSessionSecurityEnabled());
                        newsession.useNTLMv2(this.session.isNTLMv2Enabled());
                        JIComServer comServer = new JIComServer(newsession, comObjectImpl.internal_getInterfacePointer(), null);
                        comObject = comServer.getInstance();
                        JIFrameworkHelper.link2Sessions(this.session, newsession);
                    } else {
                        comObject = JIFrameworkHelper.instantiateComObject2(this.session, comObjectImpl.internal_getInterfacePointer());
                    }
                    comObjectImpl.replaceMembers(comObject);
                    JIFrameworkHelper.addComObjectToSession(comObjectImpl.getAssociatedSession(), comObjectImpl);
                    comObjectImpl.addRef();
                    continue;
                }
                catch (JIException e) {
                    JISystem.getLogger().throwing("JICallBuilder", "readPacket", e);
                    throw new JIRuntimeException(e.getErrorCode());
                }
            }
            comObjects.clear();
        }
        this.outparams = results.toArray();
        this.executed = true;
    }

    private void readResult(NetworkDataRepresentation ndr) {
        this.hresult = ndr.readUnsignedLong();
        if (this.hresult != 0) {
            this.resultsOfException = this.outparams;
            this.outparams = null;
            throw new JIRuntimeException(this.hresult);
        }
    }

    private int bufferLength() {
        Object[] inparams;
        int length = 0;
        for (Object inparam : inparams = this.inParams.toArray()) {
            if (inparam == null) {
                length += 4;
                continue;
            }
            int length2 = JIMarshalUnMarshalHelper.getLengthInBytes(inparam.getClass(), inparam, 0);
            length += length2;
        }
        return length + 2048;
    }

    public boolean isError() {
        this.checkIfCalled();
        return this.hresult != 0;
    }

    void attachSession(JISession session) {
        this.session = session;
    }

    JISession getSession() {
        return this.session;
    }
}

