/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import gnu.crypto.prng.IRandom;
import gnu.crypto.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.ntlmssp.NtlmFlags;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import rpc.IntegrityException;
import rpc.Security;
import rpc.security.ntlm.NTLMKeyFactory;

public class Ntlm1
implements NtlmFlags,
Security {
    private static final int NTLM1_VERIFIER_LENGTH = 16;
    private IRandom clientCipher = null;
    private IRandom serverCipher = null;
    private byte[] clientSigningKey = null;
    private byte[] serverSigningKey = null;
    private NTLMKeyFactory keyFactory = null;
    private boolean isServer = false;
    private int protectionLevel;
    private int requestCounter = 0;
    private int responseCounter = 0;
    private static final Logger logger = Logger.getLogger("org.jinterop");

    public Ntlm1(int flags, byte[] sessionKey, boolean isServer) {
        this.protectionLevel = (flags & 0x20) != 0 ? 6 : 5;
        this.isServer = isServer;
        this.keyFactory = new NTLMKeyFactory();
        this.clientSigningKey = this.keyFactory.generateClientSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] clientSealingKey = this.keyFactory.generateClientSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.serverSigningKey = this.keyFactory.generateServerSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] serverSealingKey = this.keyFactory.generateServerSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.clientCipher = this.keyFactory.getARCFOUR(clientSealingKey);
        this.serverCipher = this.keyFactory.getARCFOUR(serverSealingKey);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Client Signing Key derieved from the session key: [{0}]", Util.dumpString(this.clientSigningKey));
            logger.log(Level.FINEST, "Client Sealing Key derieved from the session key: [{0}]", Util.dumpString(clientSealingKey));
            logger.log(Level.FINEST, "Server Signing Key derieved from the session key: [{0}]", Util.dumpString(this.serverSigningKey));
            logger.log(Level.FINEST, "Server Sealing Key derieved from the session key: [{0}]", Util.dumpString(serverSealingKey));
        }
    }

    @Override
    public int getVerifierLength() {
        return 16;
    }

    @Override
    public int getAuthenticationService() {
        return 10;
    }

    @Override
    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    @Override
    public void processIncoming(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            NdrBuffer buffer = ndr.getBuffer();
            byte[] signingKey = null;
            IRandom cipher = null;
            if (!this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (this.getProtectionLevel() == 6) {
                data = this.keyFactory.applyARCFOUR(cipher, data);
                System.arraycopy(data, 0, ndr.getBuffer().buf, index, data.length);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.info("AFTER Decryption");
                logger.log(Level.FINEST, "\n{0}", Hexdump.toHexString((byte[])data));
                logger.log(Level.FINEST, "\nLength is: {0}", data.length);
            }
            byte[] verifier = this.keyFactory.signingPt1(this.responseCounter, signingKey, buffer.getBuffer(), verifierIndex);
            this.keyFactory.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            byte[] signing = new byte[16];
            ndr.readOctetArray(signing, 0, signing.length);
            if (!this.keyFactory.compareSignature(verifier, signing)) {
                throw new IntegrityException("Message out of sequence. Perhaps the user being used to run this application is different from the one under which the COM server is running !.");
            }
            ++this.responseCounter;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "", ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "", ex);
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }

    @Override
    public void processOutgoing(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            NdrBuffer buffer = ndr.getBuffer();
            byte[] signingKey = null;
            IRandom cipher = null;
            if (this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] verifier = this.keyFactory.signingPt1(this.requestCounter, signingKey, buffer.getBuffer(), verifierIndex);
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (logger.isLoggable(Level.FINEST)) {
                logger.info("BEFORE Encryption");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                logger.log(Level.FINEST, "\n{0}", Hexdump.toHexString((byte[])data));
                logger.log(Level.INFO, "Length is: {0}", data.length);
            }
            if (this.getProtectionLevel() == 6) {
                byte[] data2 = this.keyFactory.applyARCFOUR(cipher, data);
                System.arraycopy(data2, 0, ndr.getBuffer().buf, index, data2.length);
            }
            this.keyFactory.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            buffer.writeOctetArray(verifier, 0, verifier.length);
            ++this.requestCounter;
        }
        catch (Exception ex) {
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }
}

