/*
 * Decompiled with CFR 0.152.
 */
package ndr;

public class Format {
    public static final int LITTLE_ENDIAN = 0x10000000;
    public static final int BIG_ENDIAN = 0;
    public static final int ASCII_CHARACTER = 0;
    public static final int EBCDIC_CHARACTER = 0x1000000;
    public static final int IEEE_FLOATING_POINT = 0;
    public static final int VAX_FLOATING_POINT = 65536;
    public static final int CRAY_FLOATING_POINT = 0x100000;
    public static final int IBM_FLOATING_POINT = 0x110000;
    public static final int DEFAULT_DATA_REPRESENTATION = 0x10000000;
    public static final Format DEFAULT_FORMAT = new Format(0x10000000);
    static final int BYTE_ORDER_MASK = -268435456;
    static final int CHARACTER_MASK = 0xF000000;
    static final int FLOATING_POINT_MASK = 0xFF0000;
    private final int dataRepresentation;

    public Format(int dataRepresentation) {
        this.dataRepresentation = dataRepresentation;
        if ((dataRepresentation & 0xF0000000) != 0x10000000) {
            throw new IllegalArgumentException("Only little-endian byte order is currently supported.");
        }
        if ((dataRepresentation & 0xF000000) != 0) {
            throw new IllegalArgumentException("Only ASCII character set is currently supported.");
        }
        if ((dataRepresentation & 0xFF0000) != 0) {
            throw new IllegalArgumentException("Only IEEE floating point is currently supported.");
        }
    }

    public int getDataRepresentation() {
        return this.dataRepresentation;
    }

    public static Format readFormat(byte[] src, int index, boolean connectionless) {
        int value = src[index++] << 24;
        value |= (src[index++] & 0xFF) << 16;
        value |= (src[index++] & 0xFF) << 8;
        if (!connectionless) {
            value |= src[index] & 0xFF;
        }
        return new Format(value);
    }

    public void writeFormat(byte[] dest, int index, boolean connectionless) {
        int val = this.getDataRepresentation();
        dest[index++] = (byte)(val >> 24 & 0xFF);
        dest[index++] = (byte)(val >> 16 & 0xFF);
        dest[index] = 0;
        if (!connectionless) {
            dest[++index] = 0;
        }
    }
}

