/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powerspinner;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.skydoves.powerspinner.IconSpinnerItem;
import com.skydoves.powerspinner.OnSpinnerItemSelectedListener;
import com.skydoves.powerspinner.PowerSpinnerInterface;
import com.skydoves.powerspinner.PowerSpinnerView;
import com.skydoves.powerspinner.databinding.PowerspinnerItemDefaultPowerBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001+B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\tH\u0016J\u001c\u0010\u001d\u001a\u00020\u001c2\n\u0010\u001e\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u001c\u0010 \u001a\u00060\u0002R\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0016J\u0016\u0010$\u001a\u00020\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040&H\u0016J!\u0010'\u001a\u00020\u001c*\u00020(2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b*R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/skydoves/powerspinner/IconSpinnerAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/skydoves/powerspinner/IconSpinnerAdapter$IconSpinnerViewHolder;", "Lcom/skydoves/powerspinner/PowerSpinnerInterface;", "Lcom/skydoves/powerspinner/IconSpinnerItem;", "powerSpinnerView", "Lcom/skydoves/powerspinner/PowerSpinnerView;", "(Lcom/skydoves/powerspinner/PowerSpinnerView;)V", "compoundPadding", "", "index", "getIndex", "()I", "setIndex", "(I)V", "onSpinnerItemSelectedListener", "Lcom/skydoves/powerspinner/OnSpinnerItemSelectedListener;", "getOnSpinnerItemSelectedListener", "()Lcom/skydoves/powerspinner/OnSpinnerItemSelectedListener;", "setOnSpinnerItemSelectedListener", "(Lcom/skydoves/powerspinner/OnSpinnerItemSelectedListener;)V", "spinnerItems", "", "spinnerView", "getSpinnerView", "()Lcom/skydoves/powerspinner/PowerSpinnerView;", "getItemCount", "notifyItemSelected", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "itemList", "", "applyCompoundDrawables", "Landroidx/appcompat/widget/AppCompatTextView;", "item", "applyCompoundDrawables$powerspinner_release", "IconSpinnerViewHolder", "powerspinner_release"})
@SourceDebugExtension(value={"SMAP\nIconSpinnerAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconSpinnerAdapter.kt\ncom/skydoves/powerspinner/IconSpinnerAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class IconSpinnerAdapter
extends RecyclerView.Adapter<IconSpinnerViewHolder>
implements PowerSpinnerInterface<IconSpinnerItem> {
    private int index;
    @NotNull
    private final PowerSpinnerView spinnerView;
    @Nullable
    private OnSpinnerItemSelectedListener<IconSpinnerItem> onSpinnerItemSelectedListener;
    private final int compoundPadding;
    @NotNull
    private final List<IconSpinnerItem> spinnerItems;

    public IconSpinnerAdapter(@NotNull PowerSpinnerView powerSpinnerView) {
        Intrinsics.checkNotNullParameter((Object)((Object)powerSpinnerView), (String)"powerSpinnerView");
        this.index = powerSpinnerView.getSelectedIndex();
        this.spinnerView = powerSpinnerView;
        this.compoundPadding = 12;
        this.spinnerItems = new ArrayList();
        this.getSpinnerView().setCompoundDrawablePadding(this.compoundPadding);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    @NotNull
    public PowerSpinnerView getSpinnerView() {
        return this.spinnerView;
    }

    @Override
    @Nullable
    public OnSpinnerItemSelectedListener<IconSpinnerItem> getOnSpinnerItemSelectedListener() {
        return this.onSpinnerItemSelectedListener;
    }

    @Override
    public void setOnSpinnerItemSelectedListener(@Nullable OnSpinnerItemSelectedListener<IconSpinnerItem> onSpinnerItemSelectedListener) {
        this.onSpinnerItemSelectedListener = onSpinnerItemSelectedListener;
    }

    @NotNull
    public IconSpinnerViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        IconSpinnerViewHolder iconSpinnerViewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        PowerspinnerItemDefaultPowerBinding powerspinnerItemDefaultPowerBinding = PowerspinnerItemDefaultPowerBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)powerspinnerItemDefaultPowerBinding, (String)"inflate(\n        LayoutI\u2026nt,\n        false\n      )");
        PowerspinnerItemDefaultPowerBinding binding = powerspinnerItemDefaultPowerBinding;
        IconSpinnerViewHolder $this$onCreateViewHolder_u24lambda_u242 = iconSpinnerViewHolder = new IconSpinnerViewHolder(binding);
        boolean bl = false;
        binding.getRoot().setOnClickListener(arg_0 -> IconSpinnerAdapter.onCreateViewHolder$lambda$2$lambda$1($this$onCreateViewHolder_u24lambda_u242, this, arg_0));
        return iconSpinnerViewHolder;
    }

    public void onBindViewHolder(@NotNull IconSpinnerViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind$powerspinner_release(this.getSpinnerView(), this.spinnerItems.get(position), this.getIndex() == position);
    }

    @Override
    public void setItems(@NotNull List<IconSpinnerItem> itemList) {
        Intrinsics.checkNotNullParameter(itemList, (String)"itemList");
        this.spinnerItems.clear();
        this.spinnerItems.addAll((Collection<IconSpinnerItem>)itemList);
        this.setIndex(-1);
        this.notifyDataSetChanged();
    }

    @Override
    public void notifyItemSelected(int index) {
        block3: {
            IconSpinnerItem iconSpinnerItem;
            int it;
            if (index == -1) {
                return;
            }
            IconSpinnerItem item = this.spinnerItems.get(index);
            Integer n = item.getIconPadding();
            this.getSpinnerView().setCompoundDrawablePadding(n != null ? n.intValue() : this.getSpinnerView().getCompoundDrawablePadding());
            this.applyCompoundDrawables$powerspinner_release(this.getSpinnerView(), this.getSpinnerView(), item);
            int oldIndex = this.getIndex();
            this.setIndex(index);
            this.getSpinnerView().notifyItemSelected(index, item.getText());
            this.notifyDataSetChanged();
            OnSpinnerItemSelectedListener<IconSpinnerItem> onSpinnerItemSelectedListener = this.getOnSpinnerItemSelectedListener();
            if (onSpinnerItemSelectedListener == null) break block3;
            Integer n2 = oldIndex;
            int n3 = ((Number)n2).intValue();
            int n4 = oldIndex;
            OnSpinnerItemSelectedListener<IconSpinnerItem> onSpinnerItemSelectedListener2 = onSpinnerItemSelectedListener;
            boolean bl = false;
            boolean bl2 = it != -1;
            OnSpinnerItemSelectedListener<IconSpinnerItem> onSpinnerItemSelectedListener3 = onSpinnerItemSelectedListener2;
            int n5 = n4;
            Integer n6 = bl2 ? n2 : null;
            if (n6 != null) {
                it = ((Number)n6).intValue();
                n4 = n5;
                onSpinnerItemSelectedListener2 = onSpinnerItemSelectedListener3;
                boolean bl3 = false;
                IconSpinnerItem iconSpinnerItem2 = this.spinnerItems.get(oldIndex);
                onSpinnerItemSelectedListener3 = onSpinnerItemSelectedListener2;
                n5 = n4;
                iconSpinnerItem = iconSpinnerItem2;
            } else {
                iconSpinnerItem = null;
            }
            onSpinnerItemSelectedListener3.onItemSelected(n5, iconSpinnerItem, index, item);
        }
    }

    @Override
    public int getItemCount() {
        return this.spinnerItems.size();
    }

    public final /* synthetic */ void applyCompoundDrawables$powerspinner_release(AppCompatTextView $this$applyCompoundDrawables, PowerSpinnerView spinnerView, IconSpinnerItem item) {
        Integer n;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$applyCompoundDrawables, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)spinnerView), (String)"spinnerView");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                n = item.getIconRes();
                if (n == null) break block8;
                int it = ((Number)n).intValue();
                boolean bl = false;
                Drawable drawable2 = ResourcesCompat.getDrawable((Resources)spinnerView.getResources(), (int)it, null);
                n = drawable2;
                if (drawable2 != null) break block9;
            }
            n = item.getIcon();
        }
        Integer icon = n;
        Drawable start = $this$applyCompoundDrawables.getCompoundDrawablesRelative()[0];
        Drawable top = $this$applyCompoundDrawables.getCompoundDrawablesRelative()[1];
        Drawable end = $this$applyCompoundDrawables.getCompoundDrawablesRelative()[2];
        Drawable bottom = $this$applyCompoundDrawables.getCompoundDrawablesRelative()[3];
        switch (item.getIconGravity()) {
            case 0x800003: {
                $this$applyCompoundDrawables.setCompoundDrawablesRelativeWithIntrinsicBounds((Drawable)icon, top, end, bottom);
                break;
            }
            case 0x800005: {
                $this$applyCompoundDrawables.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, (Drawable)icon, bottom);
                break;
            }
            case 48: {
                $this$applyCompoundDrawables.setCompoundDrawablesRelativeWithIntrinsicBounds(start, (Drawable)icon, end, bottom);
                break;
            }
            case 80: {
                $this$applyCompoundDrawables.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, (Drawable)icon);
            }
        }
    }

    private static final void onCreateViewHolder$lambda$2$lambda$1(IconSpinnerViewHolder $this_apply, IconSpinnerAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_apply), (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Integer n = $this_apply.getBindingAdapterPosition();
        int it2 = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it2 != -1 ? n : null;
        if (n2 == null) {
            return;
        }
        int position = n2;
        this$0.notifyItemSelected(position);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/skydoves/powerspinner/IconSpinnerAdapter$IconSpinnerViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/skydoves/powerspinner/databinding/PowerspinnerItemDefaultPowerBinding;", "(Lcom/skydoves/powerspinner/IconSpinnerAdapter;Lcom/skydoves/powerspinner/databinding/PowerspinnerItemDefaultPowerBinding;)V", "bind", "", "spinnerView", "Lcom/skydoves/powerspinner/PowerSpinnerView;", "item", "Lcom/skydoves/powerspinner/IconSpinnerItem;", "isSelectedItem", "", "bind$powerspinner_release", "powerspinner_release"})
    @SourceDebugExtension(value={"SMAP\nIconSpinnerAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconSpinnerAdapter.kt\ncom/skydoves/powerspinner/IconSpinnerAdapter$IconSpinnerViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public final class IconSpinnerViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final PowerspinnerItemDefaultPowerBinding binding;

        public IconSpinnerViewHolder(PowerspinnerItemDefaultPowerBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }

        public final void bind$powerspinner_release(@NotNull PowerSpinnerView spinnerView, @NotNull IconSpinnerItem item, boolean isSelectedItem) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)((Object)spinnerView), (String)"spinnerView");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            AppCompatTextView appCompatTextView = this.binding.itemDefaultText;
            IconSpinnerAdapter iconSpinnerAdapter = IconSpinnerAdapter.this;
            AppCompatTextView $this$bind_u24lambda_u241 = appCompatTextView;
            boolean bl = false;
            $this$bind_u24lambda_u241.setText(item.getText());
            Typeface typeface = item.getTextTypeface();
            if (typeface != null) {
                Typeface it = typeface;
                boolean bl2 = false;
                $this$bind_u24lambda_u241.setTypeface(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                $this$bind_u24lambda_u241.setTypeface($this$bind_u24lambda_u241.getTypeface(), item.getTextStyle());
            }
            Integer n = item.getGravity();
            $this$bind_u24lambda_u241.setGravity(n != null ? n.intValue() : spinnerView.getGravity());
            Float f = item.getTextSize();
            $this$bind_u24lambda_u241.setTextSize(0, f != null ? f.floatValue() : spinnerView.getTextSize());
            Integer n2 = item.getTextColor();
            $this$bind_u24lambda_u241.setTextColor(n2 != null ? n2.intValue() : spinnerView.getCurrentTextColor());
            Integer n3 = item.getIconPadding();
            $this$bind_u24lambda_u241.setCompoundDrawablePadding(n3 != null ? n3.intValue() : spinnerView.getCompoundDrawablePadding());
            Intrinsics.checkNotNullExpressionValue((Object)$this$bind_u24lambda_u241, (String)"bind$lambda$1");
            iconSpinnerAdapter.applyCompoundDrawables$powerspinner_release($this$bind_u24lambda_u241, spinnerView, item);
            this.binding.getRoot().setPadding(spinnerView.getPaddingLeft(), spinnerView.getPaddingTop(), spinnerView.getPaddingRight(), spinnerView.getPaddingBottom());
            if (spinnerView.getSpinnerItemHeight() != Integer.MIN_VALUE) {
                this.binding.getRoot().setHeight(spinnerView.getSpinnerItemHeight());
            }
            if (spinnerView.getSpinnerSelectedItemBackground() != null && isSelectedItem) {
                this.binding.getRoot().setBackground(spinnerView.getSpinnerSelectedItemBackground());
            } else {
                this.binding.getRoot().setBackground(null);
            }
        }
    }
}

