/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.skydoves.balloon.BalloonOverlayPadding;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.internals.ViewPropertyDelegate;
import com.skydoves.balloon.internals.ViewPropertyKt;
import com.skydoves.balloon.overlay.BalloonOverlayCircle;
import com.skydoves.balloon.overlay.BalloonOverlayEmpty;
import com.skydoves.balloon.overlay.BalloonOverlayOval;
import com.skydoves.balloon.overlay.BalloonOverlayRect;
import com.skydoves.balloon.overlay.BalloonOverlayRoundRect;
import com.skydoves.balloon.overlay.BalloonOverlayShape;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\b\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010F\u001a\u00020GJ\u0010\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0014J\b\u0010K\u001a\u00020GH\u0002J\u001a\u0010L\u001a\u00020G2\b\u0010M\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020JH\u0002J(\u0010N\u001a\u00020G2\u0006\u0010I\u001a\u00020J2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010A\u001a\u00020BH\u0002J\b\u0010S\u001a\u00020\u0007H\u0002J0\u0010T\u001a\u00020G2\u0006\u0010U\u001a\u00020E2\u0006\u0010V\u001a\u00020\u00072\u0006\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\u0007H\u0014R/\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR;\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00122\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\u0019\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010\u001f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0011\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR/\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\n\u001a\u0004\u0018\u00010#8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010\u0011\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R+\u0010+\u001a\u00020*2\u0006\u0010\n\u001a\u00020*8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u0010\u0011\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R/\u00102\u001a\u0004\u0018\u0001012\b\u0010\n\u001a\u0004\u0018\u0001018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b7\u0010\u0011\u001a\u0004\b3\u00104\"\u0004\b5\u00106R+\u00109\u001a\u0002082\u0006\u0010\n\u001a\u0002088F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b>\u0010\u0011\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/skydoves/balloon/overlay/BalloonAnchorOverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "defStyle", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "anchorView", "getAnchorView", "()Landroid/view/View;", "setAnchorView", "(Landroid/view/View;)V", "anchorView$delegate", "Lcom/skydoves/balloon/internals/ViewPropertyDelegate;", "", "anchorViewList", "getAnchorViewList", "()Ljava/util/List;", "setAnchorViewList", "(Ljava/util/List;)V", "anchorViewList$delegate", "overlayColor", "getOverlayColor", "()I", "setOverlayColor", "(I)V", "overlayColor$delegate", "overlayPaddingColor", "getOverlayPaddingColor", "setOverlayPaddingColor", "overlayPaddingColor$delegate", "Landroid/graphics/Shader;", "overlayPaddingShader", "getOverlayPaddingShader", "()Landroid/graphics/Shader;", "setOverlayPaddingShader", "(Landroid/graphics/Shader;)V", "overlayPaddingShader$delegate", "Lcom/skydoves/balloon/BalloonOverlayPadding;", "overlayPadding", "getOverlayPadding", "()Lcom/skydoves/balloon/BalloonOverlayPadding;", "setOverlayPadding", "(Lcom/skydoves/balloon/BalloonOverlayPadding;)V", "overlayPadding$delegate", "Landroid/graphics/Point;", "overlayPosition", "getOverlayPosition", "()Landroid/graphics/Point;", "setOverlayPosition", "(Landroid/graphics/Point;)V", "overlayPosition$delegate", "Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "balloonOverlayShape", "getBalloonOverlayShape", "()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "setBalloonOverlayShape", "(Lcom/skydoves/balloon/overlay/BalloonOverlayShape;)V", "balloonOverlayShape$delegate", "bitmap", "Landroid/graphics/Bitmap;", "paint", "Landroid/graphics/Paint;", "paddingColorPaint", "invalidated", "", "forceInvalidate", "", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "prepareBitmap", "addFocusViewInOverlay", "view", "drawRoundRectWithCorners", "rect", "Landroid/graphics/RectF;", "cornerRadii", "", "getStatusBarHeight", "onLayout", "changed", "left", "top", "right", "bottom", "balloon_release"})
@SourceDebugExtension(value={"SMAP\nBalloonAnchorOverlayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonAnchorOverlayView.kt\ncom/skydoves/balloon/overlay/BalloonAnchorOverlayView\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n90#2,6:331\n1915#3,2:337\n*S KotlinDebug\n*F\n+ 1 BalloonAnchorOverlayView.kt\ncom/skydoves/balloon/overlay/BalloonAnchorOverlayView\n*L\n118#1:331,6\n144#1:337,2\n*E\n"})
public final class BalloonAnchorOverlayView
extends View {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ViewPropertyDelegate anchorView$delegate;
    @NotNull
    private final ViewPropertyDelegate anchorViewList$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayColor$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPaddingColor$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPaddingShader$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPadding$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPosition$delegate;
    @NotNull
    private final ViewPropertyDelegate balloonOverlayShape$delegate;
    @Nullable
    private Bitmap bitmap;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint paddingColorPaint;
    private boolean invalidated;

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr, int defStyle) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attr, defStyle);
        this.anchorView$delegate = ViewPropertyKt.viewProperty(this, null);
        this.anchorViewList$delegate = ViewPropertyKt.viewProperty(this, null);
        this.overlayColor$delegate = ViewPropertyKt.viewProperty(this, 0);
        this.overlayPaddingColor$delegate = ViewPropertyKt.viewProperty(this, 0);
        this.overlayPaddingShader$delegate = ViewPropertyKt.viewProperty(this, null);
        this.overlayPadding$delegate = ViewPropertyKt.viewProperty(this, new BalloonOverlayPadding(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
        this.overlayPosition$delegate = ViewPropertyKt.viewProperty(this, null);
        this.balloonOverlayShape$delegate = ViewPropertyKt.viewProperty(this, BalloonOverlayOval.INSTANCE);
        this.paint = new Paint(1);
        this.paddingColorPaint = new Paint(1);
        Paint $this$_init__u24lambda_u240 = paint = this.paint;
        boolean bl = false;
        $this$_init__u24lambda_u240.setAntiAlias(true);
        $this$_init__u24lambda_u240.setFilterBitmap(true);
        $this$_init__u24lambda_u240.setDither(true);
        Paint $this$_init__u24lambda_u241 = paint = this.paddingColorPaint;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setAntiAlias(true);
        $this$_init__u24lambda_u241.setFilterBitmap(true);
        $this$_init__u24lambda_u241.setDither(true);
    }

    public /* synthetic */ BalloonAnchorOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final View getAnchorView() {
        return (View)this.anchorView$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setAnchorView(@Nullable View view) {
        this.anchorView$delegate.setValue((Object)this, $$delegatedProperties[0], view);
    }

    @Nullable
    public final List<View> getAnchorViewList() {
        return (List)this.anchorViewList$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setAnchorViewList(@Nullable List<? extends View> list) {
        this.anchorViewList$delegate.setValue((Object)this, $$delegatedProperties[1], list);
    }

    @ColorInt
    public final int getOverlayColor() {
        return ((Number)this.overlayColor$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    public final void setOverlayColor(int n) {
        this.overlayColor$delegate.setValue((Object)this, $$delegatedProperties[2], n);
    }

    @ColorInt
    public final int getOverlayPaddingColor() {
        return ((Number)this.overlayPaddingColor$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    public final void setOverlayPaddingColor(int n) {
        this.overlayPaddingColor$delegate.setValue((Object)this, $$delegatedProperties[3], n);
    }

    @Nullable
    public final Shader getOverlayPaddingShader() {
        return (Shader)this.overlayPaddingShader$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public final void setOverlayPaddingShader(@Nullable Shader shader) {
        this.overlayPaddingShader$delegate.setValue((Object)this, $$delegatedProperties[4], shader);
    }

    @NotNull
    public final BalloonOverlayPadding getOverlayPadding() {
        return (BalloonOverlayPadding)this.overlayPadding$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    public final void setOverlayPadding(@NotNull BalloonOverlayPadding balloonOverlayPadding) {
        Intrinsics.checkNotNullParameter((Object)balloonOverlayPadding, (String)"<set-?>");
        this.overlayPadding$delegate.setValue((Object)this, $$delegatedProperties[5], balloonOverlayPadding);
    }

    @Nullable
    public final Point getOverlayPosition() {
        return (Point)this.overlayPosition$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    public final void setOverlayPosition(@Nullable Point point) {
        this.overlayPosition$delegate.setValue((Object)this, $$delegatedProperties[6], point);
    }

    @NotNull
    public final BalloonOverlayShape getBalloonOverlayShape() {
        return (BalloonOverlayShape)this.balloonOverlayShape$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    public final void setBalloonOverlayShape(@NotNull BalloonOverlayShape balloonOverlayShape) {
        Intrinsics.checkNotNullParameter((Object)balloonOverlayShape, (String)"<set-?>");
        this.balloonOverlayShape$delegate.setValue((Object)this, $$delegatedProperties[7], balloonOverlayShape);
    }

    public final void forceInvalidate() {
        this.invalidated = true;
        this.invalidate();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Bitmap bitmap;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                if (this.invalidated || this.bitmap == null) break block4;
                Bitmap bitmap2 = this.bitmap;
                boolean bl = bitmap2 != null ? bitmap2.isRecycled() : false;
                if (!bl) break block5;
            }
            this.prepareBitmap();
        }
        if ((bitmap = this.bitmap) != null && !bitmap.isRecycled()) {
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareBitmap() {
        void width$iv;
        block10: {
            block9: {
                if (this.getWidth() == 0 || this.getHeight() == 0) break block9;
                View view = this.getAnchorView();
                if (view != null ? view.getWidth() == 0 : false) break block9;
                View view2 = this.getAnchorView();
                boolean bl = view2 != null ? view2.getHeight() == 0 : false;
                if (!bl) break block10;
            }
            return;
        }
        Bitmap localBitmap = this.bitmap;
        if (localBitmap != null && !localBitmap.isRecycled()) {
            localBitmap.recycle();
        }
        int n = this.getWidth();
        int height$iv = this.getHeight();
        Bitmap.Config config$iv = Bitmap.Config.ARGB_8888;
        boolean $i$f$createBitmap = false;
        this.bitmap = localBitmap = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
        Canvas canvas = new Canvas(localBitmap);
        Object object = this.paint;
        Paint $this$prepareBitmap_u24lambda_u240 = object;
        boolean bl = false;
        $this$prepareBitmap_u24lambda_u240.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        $this$prepareBitmap_u24lambda_u240.setColor(this.getOverlayColor());
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        object = this.paint;
        Paint $this$prepareBitmap_u24lambda_u241 = object;
        boolean bl2 = false;
        $this$prepareBitmap_u24lambda_u241.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        $this$prepareBitmap_u24lambda_u241.setColor(0);
        object = this.paddingColorPaint;
        Paint $this$prepareBitmap_u24lambda_u242 = object;
        boolean bl3 = false;
        $this$prepareBitmap_u24lambda_u242.setColor(this.getOverlayPaddingColor());
        $this$prepareBitmap_u24lambda_u242.setStyle(Paint.Style.STROKE);
        $this$prepareBitmap_u24lambda_u242.setStrokeWidth(this.getOverlayPadding().getTop());
        $this$prepareBitmap_u24lambda_u242.setShader(this.getOverlayPaddingShader());
        object = this.getAnchorViewList();
        if (object == null || object.isEmpty()) {
            this.addFocusViewInOverlay(this.getAnchorView(), canvas);
        } else {
            List<View> list = this.getAnchorViewList();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    View view = (View)element$iv;
                    boolean bl4 = false;
                    this.addFocusViewInOverlay(view, canvas);
                }
            }
        }
        this.invalidated = false;
    }

    private final void addFocusViewInOverlay(View view, Canvas canvas) {
        View view2 = view;
        if (view2 != null) {
            RectF rectF;
            RectF rectF2;
            View anchor = view2;
            boolean bl = false;
            Rect rect = new Rect();
            anchor.getGlobalVisibleRect(rect);
            rect.offset((int)anchor.getTranslationX(), (int)anchor.getTranslationY());
            Point point = this.getOverlayPosition();
            if (point != null) {
                Point position = point;
                boolean bl2 = false;
                rectF2 = new RectF((float)position.x - this.getOverlayPadding().getLeft(), (float)position.y - this.getOverlayPadding().getTop() + (float)this.getStatusBarHeight(), (float)(position.x + anchor.getWidth()) + this.getOverlayPadding().getRight(), (float)(position.y + anchor.getHeight()) + this.getOverlayPadding().getBottom() + (float)this.getStatusBarHeight());
            } else {
                rectF2 = new RectF((float)rect.left - this.getOverlayPadding().getLeft(), (float)rect.top - this.getOverlayPadding().getTop(), (float)rect.right + this.getOverlayPadding().getRight(), (float)rect.bottom + this.getOverlayPadding().getBottom());
            }
            RectF anchorRect = rectF2;
            float f = this.getOverlayPadding().getTop() / (float)2;
            float f2 = this.getOverlayPadding().getBottom() / (float)2;
            float position = this.getOverlayPadding().getLeft() / (float)2;
            float bl2 = this.getOverlayPadding().getRight() / (float)2;
            BalloonOverlayPadding halfOverlayPadding = new BalloonOverlayPadding(position, f, bl2, f2);
            RectF $this$addFocusViewInOverlay_u24lambda_u240_u241 = rectF = new RectF(anchorRect);
            boolean bl3 = false;
            $this$addFocusViewInOverlay_u24lambda_u240_u241.inset(halfOverlayPadding.getLeft(), halfOverlayPadding.getTop());
            RectF anchorPaddingRect = rectF;
            BalloonOverlayShape overlay = this.getBalloonOverlayShape();
            if (!(overlay instanceof BalloonOverlayEmpty)) {
                if (overlay instanceof BalloonOverlayRect) {
                    canvas.drawRect(anchorRect, this.paint);
                    canvas.drawRect(anchorPaddingRect, this.paddingColorPaint);
                } else if (overlay instanceof BalloonOverlayOval) {
                    canvas.drawOval(anchorRect, this.paint);
                    canvas.drawOval(anchorPaddingRect, this.paddingColorPaint);
                } else if (overlay instanceof BalloonOverlayCircle) {
                    Float f3 = ((BalloonOverlayCircle)overlay).getRadius();
                    if (f3 != null) {
                        float radius = ((Number)f3).floatValue();
                        boolean bl4 = false;
                        canvas.drawCircle(anchorRect.centerX(), anchorRect.centerY(), radius, this.paint);
                        canvas.drawCircle(anchorPaddingRect.centerX(), anchorPaddingRect.centerY(), radius - this.getOverlayPadding().getTop() / (float)2, this.paddingColorPaint);
                    }
                    Integer n = ((BalloonOverlayCircle)overlay).getRadiusRes();
                    if (n != null) {
                        int radiusRes = ((Number)n).intValue();
                        boolean bl5 = false;
                        Context context = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                        float resolvedRadius = ContextExtensionKt.dimen(context, radiusRes);
                        canvas.drawCircle(anchorRect.centerX(), anchorRect.centerY(), resolvedRadius, this.paint);
                        canvas.drawCircle(anchorPaddingRect.centerX(), anchorPaddingRect.centerY(), resolvedRadius - this.getOverlayPadding().getTop() / (float)2, this.paddingColorPaint);
                    }
                } else if (overlay instanceof BalloonOverlayRoundRect) {
                    float[] resolvedRadius;
                    float[] fArray = ((BalloonOverlayRoundRect)overlay).getCornerRadii();
                    if (fArray != null) {
                        float[] radii = fArray;
                        boolean bl6 = false;
                        this.drawRoundRectWithCorners(canvas, anchorRect, radii, this.paint);
                        resolvedRadius = new float[]{RangesKt.coerceAtLeast((float)(radii[0] - this.getOverlayPadding().getLeft() / (float)2), (float)0.0f), RangesKt.coerceAtLeast((float)(radii[1] - this.getOverlayPadding().getRight() / (float)2), (float)0.0f), RangesKt.coerceAtLeast((float)(radii[2] - this.getOverlayPadding().getRight() / (float)2), (float)0.0f), RangesKt.coerceAtLeast((float)(radii[3] - this.getOverlayPadding().getLeft() / (float)2), (float)0.0f)};
                        float[] paddingRadii = resolvedRadius;
                        this.drawRoundRectWithCorners(canvas, anchorPaddingRect, paddingRadii, this.paddingColorPaint);
                    }
                    int[] nArray = ((BalloonOverlayRoundRect)overlay).getCornerRadiiRes();
                    if (nArray != null) {
                        int[] radiiRes = nArray;
                        boolean bl7 = false;
                        resolvedRadius = new float[4];
                        Context context = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                        resolvedRadius[0] = ContextExtensionKt.dimen(context, radiiRes[0]);
                        Context context2 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
                        resolvedRadius[1] = ContextExtensionKt.dimen(context2, radiiRes[1]);
                        Context context3 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
                        resolvedRadius[2] = ContextExtensionKt.dimen(context3, radiiRes[2]);
                        Context context4 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
                        resolvedRadius[3] = ContextExtensionKt.dimen(context4, radiiRes[3]);
                        float[] radii = resolvedRadius;
                        this.drawRoundRectWithCorners(canvas, anchorRect, radii, this.paint);
                        float[] fArray2 = new float[]{RangesKt.coerceAtLeast((float)(radii[0] - this.getOverlayPadding().getLeft() / (float)2), (float)0.0f), RangesKt.coerceAtLeast((float)(radii[1] - this.getOverlayPadding().getRight() / (float)2), (float)0.0f), RangesKt.coerceAtLeast((float)(radii[2] - this.getOverlayPadding().getRight() / (float)2), (float)0.0f), RangesKt.coerceAtLeast((float)(radii[3] - this.getOverlayPadding().getLeft() / (float)2), (float)0.0f)};
                        float[] paddingRadii = fArray2;
                        this.drawRoundRectWithCorners(canvas, anchorPaddingRect, paddingRadii, this.paddingColorPaint);
                    }
                    Pair<Float, Float> pair = ((BalloonOverlayRoundRect)overlay).getRadiusPair();
                    if (pair != null) {
                        Pair<Float, Float> radiusPair = pair;
                        boolean bl8 = false;
                        canvas.drawRoundRect(anchorRect, ((Number)radiusPair.getFirst()).floatValue(), ((Number)radiusPair.getSecond()).floatValue(), this.paint);
                        canvas.drawRoundRect(anchorPaddingRect, ((Number)radiusPair.getFirst()).floatValue() - this.getOverlayPadding().getLeft() / (float)2, ((Number)radiusPair.getSecond()).floatValue() - this.getOverlayPadding().getTop() / (float)2, this.paddingColorPaint);
                    }
                    Pair<Integer, Integer> pair2 = ((BalloonOverlayRoundRect)overlay).getRadiusResPair();
                    if (pair2 != null) {
                        Pair<Integer, Integer> radiusResPair = pair2;
                        boolean bl9 = false;
                        Context context = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                        float radiusX = ContextExtensionKt.dimen(context, ((Number)radiusResPair.getFirst()).intValue());
                        Context context5 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"getContext(...)");
                        float radiusY = ContextExtensionKt.dimen(context5, ((Number)radiusResPair.getSecond()).intValue());
                        canvas.drawRoundRect(anchorRect, radiusX, radiusY, this.paint);
                        canvas.drawRoundRect(anchorPaddingRect, radiusX - this.getOverlayPadding().getLeft() / (float)2, radiusY - this.getOverlayPadding().getTop() / (float)2, this.paddingColorPaint);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void drawRoundRectWithCorners(Canvas canvas, RectF rect, float[] cornerRadii, Paint paint) {
        Path path;
        float[] fArray = new float[]{cornerRadii[0], cornerRadii[0], cornerRadii[1], cornerRadii[1], cornerRadii[2], cornerRadii[2], cornerRadii[3], cornerRadii[3]};
        float[] radii = fArray;
        Path $this$drawRoundRectWithCorners_u24lambda_u240 = path = new Path();
        boolean bl = false;
        $this$drawRoundRectWithCorners_u24lambda_u240.addRoundRect(rect, radii, Path.Direction.CW);
        Path path2 = path;
        canvas.drawPath(path2, paint);
    }

    private final int getStatusBarHeight() {
        int n;
        Rect rectangle = new Rect();
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
            n = rectangle.top;
        } else {
            n = 0;
        }
        return n;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.invalidated = true;
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attr, 0, 4, null);
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "anchorView", "getAnchorView()Landroid/view/View;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "anchorViewList", "getAnchorViewList()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayColor", "getOverlayColor()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPaddingColor", "getOverlayPaddingColor()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPaddingShader", "getOverlayPaddingShader()Landroid/graphics/Shader;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPadding", "getOverlayPadding()Lcom/skydoves/balloon/BalloonOverlayPadding;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPosition", "getOverlayPosition()Landroid/graphics/Point;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "balloonOverlayShape", "getBalloonOverlayShape()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

