/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import android.view.Window;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.overlay.BalloonOverlayCircle;
import com.skydoves.balloon.overlay.BalloonOverlayOval;
import com.skydoves.balloon.overlay.BalloonOverlayRect;
import com.skydoves.balloon.overlay.BalloonOverlayRoundRect;
import com.skydoves.balloon.overlay.BalloonOverlayShape;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u0014J\u0006\u0010:\u001a\u000207J\b\u0010;\u001a\u00020\u0007H\u0002J0\u0010<\u001a\u0002072\u0006\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0007H\u0014J\b\u0010B\u001a\u000207H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010!\u001a\u00020\u00072\b\b\u0001\u0010\u0012\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R&\u0010&\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000e8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R&\u0010+\u001a\u00020\u00072\b\b\u0001\u0010\u0012\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010#\"\u0004\b-\u0010%R(\u0010.\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/skydoves/balloon/overlay/BalloonAnchorOverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_anchorView", "_balloonOverlayShape", "Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "_overlayColor", "_overlayPadding", "", "_overlayPaddingColor", "_overlayPosition", "Landroid/graphics/Point;", "value", "anchorView", "getAnchorView", "()Landroid/view/View;", "setAnchorView", "(Landroid/view/View;)V", "balloonOverlayShape", "getBalloonOverlayShape", "()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "setBalloonOverlayShape", "(Lcom/skydoves/balloon/overlay/BalloonOverlayShape;)V", "bitmap", "Landroid/graphics/Bitmap;", "invalidated", "", "overlayColor", "getOverlayColor", "()I", "setOverlayColor", "(I)V", "overlayPadding", "getOverlayPadding", "()F", "setOverlayPadding", "(F)V", "overlayPaddingColor", "getOverlayPaddingColor", "setOverlayPaddingColor", "overlayPosition", "getOverlayPosition", "()Landroid/graphics/Point;", "setOverlayPosition", "(Landroid/graphics/Point;)V", "paddingColorPaint", "Landroid/graphics/Paint;", "paint", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "forceInvalidate", "getStatusBarHeight", "onLayout", "changed", "left", "top", "right", "bottom", "prepareBitmap", "balloon_release"})
public final class BalloonAnchorOverlayView
extends View {
    private View _anchorView;
    @ColorInt
    private int _overlayColor;
    @ColorInt
    private int _overlayPaddingColor;
    @Px
    private float _overlayPadding;
    private Point _overlayPosition;
    private BalloonOverlayShape _balloonOverlayShape;
    private Bitmap bitmap;
    private final Paint paint;
    private final Paint paddingColorPaint;
    private boolean invalidated;

    @Nullable
    public final View getAnchorView() {
        return this._anchorView;
    }

    public final void setAnchorView(@Nullable View value2) {
        this._anchorView = value2;
        this.invalidate();
    }

    @ColorInt
    public final int getOverlayColor() {
        return this._overlayColor;
    }

    public final void setOverlayColor(@ColorInt int value2) {
        this._overlayColor = value2;
        this.invalidate();
    }

    @ColorInt
    public final int getOverlayPaddingColor() {
        return this._overlayPaddingColor;
    }

    public final void setOverlayPaddingColor(@ColorInt int value2) {
        this._overlayPaddingColor = value2;
        this.invalidate();
    }

    @Px
    public final float getOverlayPadding() {
        return this._overlayPadding;
    }

    public final void setOverlayPadding(@Px float value2) {
        this._overlayPadding = value2;
        this.invalidate();
    }

    @Nullable
    public final Point getOverlayPosition() {
        return this._overlayPosition;
    }

    public final void setOverlayPosition(@Nullable Point value2) {
        this._overlayPosition = value2;
        this.invalidate();
    }

    @NotNull
    public final BalloonOverlayShape getBalloonOverlayShape() {
        return this._balloonOverlayShape;
    }

    public final void setBalloonOverlayShape(@NotNull BalloonOverlayShape value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this._balloonOverlayShape = value2;
        this.invalidate();
    }

    public final void forceInvalidate() {
        this.invalidated = true;
        this.invalidate();
    }

    protected void dispatchDraw(@Nullable Canvas canvas) {
        block4: {
            Bitmap bitmap;
            block3: {
                block2: {
                    if (this.invalidated || this.bitmap == null) break block2;
                    Bitmap bitmap2 = this.bitmap;
                    if (bitmap2 == null) break block3;
                    if (!bitmap2.isRecycled()) break block3;
                }
                this.prepareBitmap();
            }
            if ((bitmap = this.bitmap) == null || bitmap.isRecycled()) break block4;
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawBitmap(bitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private final void prepareBitmap() {
        Bitmap localBitmap;
        block18: {
            block17: {
                if (this.getWidth() == 0 || this.getHeight() == 0) break block17;
                View view = this.getAnchorView();
                if (view != null && view.getWidth() == 0) break block17;
                View view2 = this.getAnchorView();
                if (view2 == null) break block18;
                if (view2.getHeight() != 0) break block18;
            }
            return;
        }
        if ((localBitmap = this.bitmap) != null && !localBitmap.isRecycled()) {
            localBitmap.recycle();
        }
        this.bitmap = localBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(localBitmap);
        Paint paint = this.paint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        $this$apply.setColor(this.getOverlayColor());
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        paint = this.paint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        $this$apply.setColor(0);
        paint = this.paddingColorPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl5 = false;
        $this$apply.setColor(this.getOverlayPaddingColor());
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeWidth(this.getOverlayPadding());
        View view = this.getAnchorView();
        if (view != null) {
            RectF rectF;
            paint = view;
            bl = false;
            bl2 = false;
            Paint anchor = paint;
            boolean bl6 = false;
            Rect rect = new Rect();
            anchor.getGlobalVisibleRect(rect);
            Point point = this.getOverlayPosition();
            if (point != null) {
                Point point2 = point;
                boolean bl7 = false;
                boolean bl8 = false;
                Point position = point2;
                boolean bl9 = false;
                rectF = new RectF((float)position.x - this.getOverlayPadding(), (float)position.y - this.getOverlayPadding() + (float)this.getStatusBarHeight(), (float)(position.x + anchor.getWidth()) + this.getOverlayPadding(), (float)(position.y + anchor.getHeight()) + this.getOverlayPadding() + (float)this.getStatusBarHeight());
            } else {
                rectF = new RectF((float)rect.left - this.getOverlayPadding(), (float)rect.top - this.getOverlayPadding(), (float)rect.right + this.getOverlayPadding(), (float)rect.bottom + this.getOverlayPadding());
            }
            RectF anchorRect = rectF;
            float halfOfOverlayPadding = this.getOverlayPadding() / (float)2;
            RectF rectF2 = new RectF(anchorRect);
            boolean bl10 = false;
            boolean bl11 = false;
            RectF $this$apply2 = rectF2;
            boolean bl12 = false;
            $this$apply2.inset(halfOfOverlayPadding, halfOfOverlayPadding);
            RectF anchorPaddingRect = rectF2;
            BalloonOverlayShape overlay = this.getBalloonOverlayShape();
            if (overlay instanceof BalloonOverlayRect) {
                canvas.drawRect(anchorRect, this.paint);
                canvas.drawRect(anchorPaddingRect, this.paddingColorPaint);
            } else if (overlay instanceof BalloonOverlayOval) {
                canvas.drawOval(anchorRect, this.paint);
                canvas.drawOval(anchorPaddingRect, this.paddingColorPaint);
            } else if (overlay instanceof BalloonOverlayCircle) {
                Float f = ((BalloonOverlayCircle)overlay).getRadius();
                if (f != null) {
                    Float f2 = f;
                    bl11 = false;
                    boolean bl13 = false;
                    float radius = ((Number)f2).floatValue();
                    boolean bl14 = false;
                    canvas.drawCircle(anchorRect.centerX(), anchorRect.centerY(), radius, this.paint);
                    canvas.drawCircle(anchorPaddingRect.centerX(), anchorPaddingRect.centerY(), radius - halfOfOverlayPadding, this.paddingColorPaint);
                }
                Integer n = ((BalloonOverlayCircle)overlay).getRadiusRes();
                if (n != null) {
                    Integer n2 = n;
                    bl11 = false;
                    boolean bl15 = false;
                    int radiusRes = ((Number)n2).intValue();
                    boolean bl16 = false;
                    float f3 = anchorRect.centerX();
                    float f4 = anchorRect.centerY();
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    canvas.drawCircle(f3, f4, ContextExtensionKt.dimen(context, radiusRes), this.paint);
                    float f5 = anchorPaddingRect.centerX();
                    float f6 = anchorPaddingRect.centerY();
                    Context context2 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                    canvas.drawCircle(f5, f6, ContextExtensionKt.dimen(context2, radiusRes) - halfOfOverlayPadding, this.paddingColorPaint);
                }
            } else if (overlay instanceof BalloonOverlayRoundRect) {
                Pair<Float, Float> pair = ((BalloonOverlayRoundRect)overlay).getRadiusPair();
                if (pair != null) {
                    Pair<Float, Float> pair2 = pair;
                    bl11 = false;
                    boolean bl17 = false;
                    Pair<Float, Float> radiusPair = pair2;
                    boolean bl18 = false;
                    canvas.drawRoundRect(anchorRect, ((Number)radiusPair.getFirst()).floatValue(), ((Number)radiusPair.getSecond()).floatValue(), this.paint);
                    canvas.drawRoundRect(anchorPaddingRect, ((Number)radiusPair.getFirst()).floatValue() - halfOfOverlayPadding, ((Number)radiusPair.getSecond()).floatValue() - halfOfOverlayPadding, this.paddingColorPaint);
                }
                Pair<Integer, Integer> pair3 = ((BalloonOverlayRoundRect)overlay).getRadiusResPair();
                if (pair3 != null) {
                    Pair<Integer, Integer> pair4 = pair3;
                    bl11 = false;
                    boolean bl19 = false;
                    Pair<Integer, Integer> radiusResPair = pair4;
                    boolean bl20 = false;
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    float f = ContextExtensionKt.dimen(context, ((Number)radiusResPair.getFirst()).intValue());
                    Context context3 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                    canvas.drawRoundRect(anchorRect, f, ContextExtensionKt.dimen(context3, ((Number)radiusResPair.getSecond()).intValue()), this.paint);
                    Context context4 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
                    float f7 = ContextExtensionKt.dimen(context4, ((Number)radiusResPair.getFirst()).intValue()) - halfOfOverlayPadding;
                    Context context5 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"context");
                    canvas.drawRoundRect(anchorPaddingRect, f7, ContextExtensionKt.dimen(context5, ((Number)radiusResPair.getSecond()).intValue()) - halfOfOverlayPadding, this.paddingColorPaint);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.invalidated = false;
    }

    private final int getStatusBarHeight() {
        int n;
        Rect rectangle = new Rect();
        Context context = this.getContext();
        if (context instanceof Activity) {
            Window window = ((Activity)context).getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"context.window");
            window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
            n = rectangle.top;
        } else {
            n = 0;
        }
        return n;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.invalidated = true;
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attr, defStyle);
        this._balloonOverlayShape = BalloonOverlayOval.INSTANCE;
        this.paint = new Paint(1);
        this.paddingColorPaint = new Paint(1);
        Paint paint = this.paint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setFilterBitmap(true);
        $this$apply.setDither(true);
        paint = this.paddingColorPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setFilterBitmap(true);
        $this$apply.setDither(true);
    }

    public /* synthetic */ BalloonAnchorOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        this(context, attr, 0, 4, null);
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

