/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.cardview.widget.CardView;
import androidx.core.widget.ImageViewCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.skydoves.balloon.ArrowConstraints;
import com.skydoves.balloon.ArrowOrientation;
import com.skydoves.balloon.Balloon$WhenMappings;
import com.skydoves.balloon.BalloonAnimation;
import com.skydoves.balloon.BalloonDsl;
import com.skydoves.balloon.BalloonPersistence;
import com.skydoves.balloon.DefinitionKt;
import com.skydoves.balloon.IconForm;
import com.skydoves.balloon.IconGravity;
import com.skydoves.balloon.OnBalloonClickListener;
import com.skydoves.balloon.OnBalloonDismissListener;
import com.skydoves.balloon.OnBalloonInitializedListener;
import com.skydoves.balloon.OnBalloonOutsideTouchListener;
import com.skydoves.balloon.R;
import com.skydoves.balloon.TextForm;
import com.skydoves.balloon.annotations.Dp;
import com.skydoves.balloon.annotations.Sp;
import com.skydoves.balloon.databinding.LayoutBalloonBinding;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.extensions.ImageViewExtensionKt;
import com.skydoves.balloon.extensions.TextViewExtensionKt;
import com.skydoves.balloon.extensions.ViewExtensionKt;
import com.skydoves.balloon.vectortext.VectorTextView;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002ghB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0006\u0010/\u001a\u00020-J\u000e\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0006\u00108\u001a\u000206J\u0006\u00109\u001a\u00020+J\u0006\u0010:\u001a\u00020+J\u0010\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020+H\u0002J\u0006\u0010=\u001a\u00020+J\b\u0010>\u001a\u000204H\u0002J\u0006\u0010?\u001a\u00020+J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u000206H\u0002J\u0010\u0010C\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0002J\b\u0010D\u001a\u00020-H\u0002J\b\u0010E\u001a\u00020-H\u0002J\b\u0010F\u001a\u00020-H\u0002J\b\u0010G\u001a\u00020-H\u0003J\b\u0010H\u001a\u00020-H\u0002J\b\u0010I\u001a\u00020-H\u0002J\b\u0010J\u001a\u00020-H\u0002J\b\u0010K\u001a\u00020-H\u0002J\b\u0010L\u001a\u00020-H\u0007J\b\u0010M\u001a\u00020-H\u0007J6\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002#\b\u0004\u0010P\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(O\u0012\u0004\u0012\u00020-0QH\u0083\bJ\u0016\u0010T\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u000206J&\u0010T\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u0016\u0010W\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u000206J&\u0010W\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u0016\u0010X\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u000206J&\u0010X\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u0016\u0010Y\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u000206J&\u0010Y\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u0016\u0010Z\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u000206J&\u0010Z\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u0016\u0010[\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u000206J&\u0010[\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00002\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u001a\u0010\u0016\u001a\u00020-2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020-0QJ\u0014\u0010\u001c\u001a\u00020-2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020-0]J \u0010(\u001a\u00020-2\u0018\u0010\\\u001a\u0014\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u00020-0^J\u000e\u0010`\u001a\u00020-2\u0006\u00105\u001a\u000206J!\u0010`\u001a\u00020-2\u0006\u00105\u001a\u0002062\u000e\b\u0004\u0010P\u001a\b\u0012\u0004\u0012\u00020-0]H\u0083\bJ\u001e\u0010`\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u000e\u0010a\u001a\u00020-2\u0006\u00105\u001a\u000206J\u001e\u0010a\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u000e\u0010b\u001a\u00020-2\u0006\u00105\u001a\u000206J\u001e\u0010b\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u000e\u0010c\u001a\u00020-2\u0006\u00105\u001a\u000206J\u001e\u0010c\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u000e\u0010d\u001a\u00020-2\u0006\u00105\u001a\u000206J\u001e\u0010d\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u000e\u0010e\u001a\u00020-2\u0006\u00105\u001a\u000206J\u001e\u0010e\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+J\u000e\u0010f\u001a\u00020-2\u0006\u00105\u001a\u000206J!\u0010f\u001a\u00020-2\u0006\u00105\u001a\u0002062\u000e\b\u0004\u0010P\u001a\b\u0012\u0004\u0012\u00020-0]H\u0083\bJ\u001e\u0010f\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020+R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/skydoves/balloon/Balloon;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "builder", "Lcom/skydoves/balloon/Balloon$Builder;", "(Landroid/content/Context;Lcom/skydoves/balloon/Balloon$Builder;)V", "balloonPersistence", "Lcom/skydoves/balloon/BalloonPersistence;", "binding", "Lcom/skydoves/balloon/databinding/LayoutBalloonBinding;", "bodyWindow", "Landroid/widget/PopupWindow;", "destroyed", "", "<set-?>", "isShowing", "()Z", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "getOnBalloonClickListener", "()Lcom/skydoves/balloon/OnBalloonClickListener;", "setOnBalloonClickListener", "(Lcom/skydoves/balloon/OnBalloonClickListener;)V", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "getOnBalloonDismissListener", "()Lcom/skydoves/balloon/OnBalloonDismissListener;", "setOnBalloonDismissListener", "(Lcom/skydoves/balloon/OnBalloonDismissListener;)V", "onBalloonInitializedListener", "Lcom/skydoves/balloon/OnBalloonInitializedListener;", "getOnBalloonInitializedListener", "()Lcom/skydoves/balloon/OnBalloonInitializedListener;", "setOnBalloonInitializedListener", "(Lcom/skydoves/balloon/OnBalloonInitializedListener;)V", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "getOnBalloonOutsideTouchListener", "()Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "setOnBalloonOutsideTouchListener", "(Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;)V", "supportRtlLayoutFactor", "", "applyBalloonAnimation", "", "createByBuilder", "dismiss", "dismissWithDelay", "delay", "", "getArrowConstraintPositionX", "", "anchor", "Landroid/view/View;", "getArrowConstraintPositionY", "getContentView", "getDoubleArrowSize", "getMeasureHeight", "getMeasureTextWidth", "measuredWidth", "getMeasureWidth", "getMinArrowPosition", "getStatusBarHeight", "getWindowBodyScreenLocation", "", "view", "initializeArrow", "initializeBackground", "initializeBalloonContent", "initializeBalloonListeners", "initializeBalloonWindow", "initializeCustomLayoutWithResource", "initializeCustomLayoutWithView", "initializeIcon", "initializeText", "onDestroy", "onPause", "relay", "balloon", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "relayShow", "xOff", "yOff", "relayShowAlignBottom", "relayShowAlignLeft", "relayShowAlignRight", "relayShowAlignTop", "relayShowAsDropDown", "unit", "Lkotlin/Function0;", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "show", "showAlignBottom", "showAlignLeft", "showAlignRight", "showAlignTop", "showAsDropDown", "update", "Builder", "Factory", "balloon_release"})
public final class Balloon
implements LifecycleObserver {
    private final LayoutBalloonBinding binding;
    private final PopupWindow bodyWindow;
    private boolean isShowing;
    private boolean destroyed;
    @Nullable
    private OnBalloonClickListener onBalloonClickListener;
    @Nullable
    private OnBalloonDismissListener onBalloonDismissListener;
    @Nullable
    private OnBalloonInitializedListener onBalloonInitializedListener;
    @Nullable
    private OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
    private int supportRtlLayoutFactor;
    private final BalloonPersistence balloonPersistence;
    private final Context context;
    private final Builder builder;

    public final boolean isShowing() {
        return this.isShowing;
    }

    @Nullable
    public final OnBalloonClickListener getOnBalloonClickListener() {
        return this.onBalloonClickListener;
    }

    public final void setOnBalloonClickListener(@Nullable OnBalloonClickListener onBalloonClickListener) {
        this.onBalloonClickListener = onBalloonClickListener;
    }

    @Nullable
    public final OnBalloonDismissListener getOnBalloonDismissListener() {
        return this.onBalloonDismissListener;
    }

    public final void setOnBalloonDismissListener(@Nullable OnBalloonDismissListener onBalloonDismissListener) {
        this.onBalloonDismissListener = onBalloonDismissListener;
    }

    @Nullable
    public final OnBalloonInitializedListener getOnBalloonInitializedListener() {
        return this.onBalloonInitializedListener;
    }

    public final void setOnBalloonInitializedListener(@Nullable OnBalloonInitializedListener onBalloonInitializedListener) {
        this.onBalloonInitializedListener = onBalloonInitializedListener;
    }

    @Nullable
    public final OnBalloonOutsideTouchListener getOnBalloonOutsideTouchListener() {
        return this.onBalloonOutsideTouchListener;
    }

    public final void setOnBalloonOutsideTouchListener(@Nullable OnBalloonOutsideTouchListener onBalloonOutsideTouchListener) {
        this.onBalloonOutsideTouchListener = onBalloonOutsideTouchListener;
    }

    private final void createByBuilder() {
        block4: {
            LifecycleOwner lifecycleOwner;
            this.initializeBackground();
            this.initializeBalloonWindow();
            this.initializeBalloonContent();
            this.initializeBalloonListeners();
            if (this.builder.layoutRes != Integer.MIN_VALUE) {
                this.initializeCustomLayoutWithResource();
            } else if (this.builder.layout != null) {
                this.initializeCustomLayoutWithView();
            } else {
                this.initializeIcon();
                this.initializeText();
            }
            if ((lifecycleOwner = this.builder.lifecycleOwner) == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null) break block4;
            lifecycleOwner.addObserver((LifecycleObserver)this);
        }
    }

    private final void initializeArrow(View anchor) {
        AppCompatImageView appCompatImageView = this.binding.balloonArrow;
        boolean bl = false;
        boolean bl2 = false;
        AppCompatImageView $this$with = appCompatImageView;
        boolean bl3 = false;
        ViewExtensionKt.visible((View)$this$with, false);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.builder.arrowSize, this.builder.arrowSize);
        switch (Balloon$WhenMappings.$EnumSwitchMapping$0[this.builder.arrowOrientation.ordinal()]) {
            case 1: {
                RelativeLayout relativeLayout = this.binding.balloonContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.balloonContent");
                params.addRule(8, relativeLayout.getId());
                $this$with.setRotation(180.0f);
                break;
            }
            case 2: {
                RelativeLayout relativeLayout = this.binding.balloonContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.balloonContent");
                params.addRule(6, relativeLayout.getId());
                $this$with.setRotation(0.0f);
                break;
            }
            case 3: {
                RelativeLayout relativeLayout = this.binding.balloonContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.balloonContent");
                params.addRule(5, relativeLayout.getId());
                $this$with.setRotation(-90.0f);
                break;
            }
            case 4: {
                RelativeLayout relativeLayout = this.binding.balloonContent;
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.balloonContent");
                params.addRule(7, relativeLayout.getId());
                $this$with.setRotation(90.0f);
            }
        }
        $this$with.setLayoutParams((ViewGroup.LayoutParams)params);
        $this$with.setAlpha(this.builder.alpha);
        Drawable drawable = this.builder.arrowDrawable;
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl4 = false;
            boolean bl5 = false;
            Drawable it = drawable2;
            boolean bl6 = false;
            $this$with.setImageDrawable(it);
        }
        $this$with.setPadding(this.builder.arrowLeftPadding, this.builder.arrowTopPadding, this.builder.arrowRightPadding, this.builder.arrowBottomPadding);
        if (this.builder.arrowColor != Integer.MIN_VALUE) {
            ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with), (ColorStateList)ColorStateList.valueOf((int)this.builder.arrowColor));
        } else {
            ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with), (ColorStateList)ColorStateList.valueOf((int)this.builder.backgroundColor));
        }
        this.binding.getRoot().post(new Runnable($this$with, this, anchor){
            final /* synthetic */ AppCompatImageView $this_with;
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ View $anchor$inlined;
            {
                this.$this_with = appCompatImageView;
                this.this$0 = balloon2;
                this.$anchor$inlined = view;
            }

            public final void run() {
                AppCompatImageView appCompatImageView = Balloon.access$getBinding$p((Balloon)this.this$0).balloonArrow;
                Intrinsics.checkExpressionValueIsNotNull((Object)appCompatImageView, (String)"binding.balloonArrow");
                ViewExtensionKt.visible((View)appCompatImageView, Balloon.access$getBuilder$p((Balloon)this.this$0).arrowVisible);
                OnBalloonInitializedListener onBalloonInitializedListener = this.this$0.getOnBalloonInitializedListener();
                if (onBalloonInitializedListener != null) {
                    onBalloonInitializedListener.onBalloonInitialized(this.this$0.getContentView());
                }
                switch (Balloon$WhenMappings.$EnumSwitchMapping$1[Balloon.access$getBuilder$p((Balloon)this.this$0).arrowOrientation.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.$this_with.setX(Balloon.access$getArrowConstraintPositionX(this.this$0, this.$anchor$inlined));
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.$this_with.setY(Balloon.access$getArrowConstraintPositionY(this.this$0, this.$anchor$inlined));
                    }
                }
            }
        });
    }

    private final float getMinArrowPosition() {
        return (float)this.builder.arrowSize * this.builder.arrowAlignAnchorPaddingRatio + (float)this.builder.arrowAlignAnchorPadding;
    }

    private final int[] getWindowBodyScreenLocation(View view) {
        int[] location = new int[]{0, 0};
        view.getLocationOnScreen(location);
        return location;
    }

    public final int getStatusBarHeight() {
        int n;
        Rect rectangle = new Rect();
        if (this.context instanceof Activity && this.builder.isStatusBarVisible) {
            Window window = ((Activity)this.context).getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"context.window");
            window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
            n = rectangle.top;
        } else {
            n = 0;
        }
        return n;
    }

    public final int getDoubleArrowSize() {
        return this.builder.arrowSize * 2;
    }

    private final float getArrowConstraintPositionX(View anchor) {
        float f;
        View view = this.bodyWindow.getContentView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bodyWindow.contentView");
        int balloonX = this.getWindowBodyScreenLocation(view)[0];
        int anchorX = this.getWindowBodyScreenLocation(anchor)[0];
        float minPosition = this.getMinArrowPosition();
        float maxPosition = (float)this.getMeasureWidth() - minPosition;
        float arrowHalfSize = (float)this.builder.arrowSize / 2.0f;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$2[this.builder.arrowConstraints.ordinal()]) {
            case 1: {
                RelativeLayout relativeLayout = this.binding.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.root");
                f = (float)relativeLayout.getWidth() * this.builder.arrowPosition - arrowHalfSize;
                break;
            }
            case 2: {
                if (anchorX + anchor.getWidth() < balloonX) {
                    f = minPosition;
                    break;
                }
                if (balloonX + this.getMeasureWidth() < anchorX) {
                    f = maxPosition;
                    break;
                }
                float position = (float)anchor.getWidth() * this.builder.arrowPosition + (float)anchorX - (float)balloonX - arrowHalfSize;
                if (position <= (float)this.getDoubleArrowSize()) {
                    f = minPosition;
                    break;
                }
                if (position > (float)(this.getMeasureWidth() - this.getDoubleArrowSize())) {
                    f = maxPosition;
                    break;
                }
                f = position;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private final float getArrowConstraintPositionY(View anchor) {
        float f;
        View view = this.bodyWindow.getContentView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bodyWindow.contentView");
        int balloonY = this.getWindowBodyScreenLocation(view)[1] - this.getStatusBarHeight();
        int anchorY = this.getWindowBodyScreenLocation(anchor)[1] - this.getStatusBarHeight();
        float minPosition = this.getMinArrowPosition();
        float maxPosition = (float)this.getMeasureHeight() - minPosition;
        int arrowHalfSize = this.builder.arrowSize / 2;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$3[this.builder.arrowConstraints.ordinal()]) {
            case 1: {
                RelativeLayout relativeLayout = this.binding.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.root");
                f = (float)relativeLayout.getHeight() * this.builder.arrowPosition - (float)arrowHalfSize;
                break;
            }
            case 2: {
                if (anchorY + anchor.getHeight() < balloonY) {
                    f = minPosition;
                    break;
                }
                if (balloonY + this.getMeasureHeight() < anchorY) {
                    f = maxPosition;
                    break;
                }
                float position = (float)anchor.getHeight() * this.builder.arrowPosition + (float)anchorY - (float)balloonY - (float)arrowHalfSize;
                if (position <= (float)this.getDoubleArrowSize()) {
                    f = minPosition;
                    break;
                }
                if (position > (float)(this.getMeasureHeight() - this.getDoubleArrowSize())) {
                    f = maxPosition;
                    break;
                }
                f = position;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private final void initializeBackground() {
        CardView cardView = this.binding.balloonCard;
        boolean bl = false;
        boolean bl2 = false;
        CardView $this$with = cardView;
        boolean bl3 = false;
        $this$with.setAlpha(this.builder.alpha);
        $this$with.setCardElevation(this.builder.elevation);
        if (this.builder.backgroundDrawable == null) {
            $this$with.setCardBackgroundColor(this.builder.backgroundColor);
            $this$with.setRadius(this.builder.cornerRadius);
        } else {
            $this$with.setBackground(this.builder.backgroundDrawable);
        }
    }

    @TargetApi(value=21)
    private final void initializeBalloonWindow() {
        PopupWindow popupWindow = this.bodyWindow;
        boolean bl = false;
        boolean bl2 = false;
        PopupWindow $this$with = popupWindow;
        boolean bl3 = false;
        $this$with.setFocusable(this.builder.isFocusable);
        $this$with.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        if (Build.VERSION.SDK_INT >= 21) {
            $this$with.setElevation(this.builder.elevation);
        }
    }

    private final void initializeBalloonListeners() {
        this.onBalloonClickListener = this.builder.onBalloonClickListener;
        this.onBalloonDismissListener = this.builder.onBalloonDismissListener;
        this.onBalloonInitializedListener = this.builder.onBalloonInitializedListener;
        this.onBalloonOutsideTouchListener = this.builder.onBalloonOutsideTouchListener;
        this.binding.getRoot().setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ Balloon this$0;

            public final void onClick(View it) {
                OnBalloonClickListener onBalloonClickListener = this.this$0.getOnBalloonClickListener();
                if (onBalloonClickListener != null) {
                    View view = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                    onBalloonClickListener.onBalloonClick(view);
                }
                if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenClicked) {
                    this.this$0.dismiss();
                }
            }
            {
                this.this$0 = balloon2;
            }
        });
        PopupWindow popupWindow = this.bodyWindow;
        boolean bl = false;
        boolean bl2 = false;
        PopupWindow $this$with = popupWindow;
        boolean bl3 = false;
        $this$with.setOutsideTouchable(this.builder.dismissWhenTouchOutside);
        $this$with.setOnDismissListener(new PopupWindow.OnDismissListener(this){
            final /* synthetic */ Balloon this$0;
            {
                this.this$0 = balloon2;
            }

            public final void onDismiss() {
                block0: {
                    this.this$0.dismiss();
                    OnBalloonDismissListener onBalloonDismissListener = this.this$0.getOnBalloonDismissListener();
                    if (onBalloonDismissListener == null) break block0;
                    onBalloonDismissListener.onBalloonDismiss();
                }
            }
        });
        $this$with.setTouchInterceptor(new View.OnTouchListener(this){
            final /* synthetic */ Balloon this$0;
            {
                this.this$0 = balloon2;
            }

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getAction() == 4) {
                    if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenTouchOutside) {
                        this.this$0.dismiss();
                    }
                    OnBalloonOutsideTouchListener onBalloonOutsideTouchListener = this.this$0.getOnBalloonOutsideTouchListener();
                    if (onBalloonOutsideTouchListener != null) {
                        onBalloonOutsideTouchListener.onBalloonOutsideTouch(view, event);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private final void initializeBalloonContent() {
        Object object = this.binding.balloonContent;
        boolean bl = false;
        boolean bl2 = false;
        RelativeLayout $this$with = object;
        boolean bl3 = false;
        $this$with.setPadding(this.builder.arrowSize - 2, this.builder.arrowSize - 2, this.builder.arrowSize - 2, this.builder.arrowSize - 2);
        object = this.binding.balloonText;
        bl = false;
        bl2 = false;
        $this$with = object;
        boolean bl4 = false;
        if (this.builder.padding != Integer.MIN_VALUE) {
            $this$with.setPadding(this.builder.padding, this.builder.padding, this.builder.padding, this.builder.padding);
        } else {
            $this$with.setPadding(this.builder.paddingLeft, this.builder.paddingTop, this.builder.paddingRight, this.builder.paddingBottom);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeIcon() {
        VectorTextView vectorTextView = this.binding.balloonText;
        boolean bl = false;
        boolean bl2 = false;
        VectorTextView $this$with = vectorTextView;
        boolean bl3 = false;
        IconForm iconForm = this.builder.iconForm;
        if (iconForm != null) {
            IconForm iconForm2 = iconForm;
            boolean bl4 = false;
            boolean bl5 = false;
            IconForm it = iconForm2;
            boolean bl6 = false;
            ImageViewExtensionKt.applyIconForm($this$with, it);
        } else {
            void context$iv;
            Context context = $this$with.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Context context2 = context;
            VectorTextView vectorTextView2 = $this$with;
            boolean $i$f$iconForm = false;
            IconForm.Builder builder = new IconForm.Builder((Context)context$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            IconForm.Builder $this$iconForm = builder;
            boolean bl9 = false;
            $this$iconForm.setDrawable(this.builder.iconDrawable);
            $this$iconForm.setIconSize(this.builder.iconSize);
            $this$iconForm.setIconColor(this.builder.iconColor);
            $this$iconForm.setIconSpace(this.builder.iconSpace);
            $this$iconForm.setDrawableGravity(this.builder.iconGravity);
            IconForm iconForm3 = builder.build();
            ImageViewExtensionKt.applyIconForm(vectorTextView2, iconForm3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeText() {
        TextForm textForm;
        VectorTextView vectorTextView = this.binding.balloonText;
        boolean bl = false;
        boolean bl2 = false;
        VectorTextView $this$with = vectorTextView;
        boolean bl3 = false;
        TextForm textForm2 = this.builder.textForm;
        if (textForm2 != null) {
            textForm = textForm2;
            boolean bl4 = false;
            boolean bl5 = false;
            TextForm it = textForm;
            boolean bl6 = false;
            TextViewExtensionKt.applyTextForm((TextView)$this$with, it);
        } else {
            void context$iv;
            TextView textView = (TextView)$this$with;
            Context context = $this$with.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            textForm = context;
            TextView textView2 = textView;
            boolean $i$f$textForm = false;
            TextForm.Builder builder = new TextForm.Builder((Context)context$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            TextForm.Builder $this$textForm = builder;
            boolean bl9 = false;
            $this$textForm.setText(this.builder.text);
            $this$textForm.setTextSize(this.builder.textSize);
            $this$textForm.setTextColor(this.builder.textColor);
            $this$textForm.setTextIsHtml(this.builder.textIsHtml);
            $this$textForm.setTextGravity(this.builder.textGravity);
            $this$textForm.setTextTypeface(this.builder.textTypeface);
            $this$textForm.setTextTypeface(this.builder.textTypefaceObject);
            TextForm textForm3 = builder.build();
            TextViewExtensionKt.applyTextForm(textView2, textForm3);
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        Context context = $this$with.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)ContextExtensionKt.displaySize((Context)context).y, (int)0);
        $this$with.measure(widthSpec, heightSpec);
        $this$with.getLayoutParams().width = this.getMeasureTextWidth($this$with.getMeasuredWidth());
    }

    private final void initializeCustomLayoutWithResource() {
        this.binding.balloonCard.removeAllViews();
        Object object = this.context.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        inflater.inflate(this.builder.layoutRes, (ViewGroup)this.binding.balloonCard);
    }

    private final void initializeCustomLayoutWithView() {
        this.binding.balloonCard.removeAllViews();
        this.binding.balloonCard.addView(this.builder.layout);
    }

    private final void applyBalloonAnimation() {
        if (this.builder.balloonAnimationStyle == Integer.MIN_VALUE) {
            switch (Balloon$WhenMappings.$EnumSwitchMapping$4[this.builder.balloonAnimation.ordinal()]) {
                case 1: {
                    this.bodyWindow.setAnimationStyle(R.style.Elastic);
                    break;
                }
                case 2: {
                    View view = this.bodyWindow.getContentView();
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bodyWindow.contentView");
                    ViewExtensionKt.circularRevealed(view, this.builder.circularDuration);
                    this.bodyWindow.setAnimationStyle(R.style.NormalDispose);
                    break;
                }
                case 3: {
                    this.bodyWindow.setAnimationStyle(R.style.Fade);
                    break;
                }
                case 4: {
                    this.bodyWindow.setAnimationStyle(R.style.Overshoot);
                    break;
                }
                default: {
                    this.bodyWindow.setAnimationStyle(R.style.Normal);
                    break;
                }
            }
        } else {
            this.bodyWindow.setAnimationStyle(this.builder.balloonAnimationStyle);
        }
    }

    @MainThread
    private final void show(View anchor, Function0<Unit> block) {
        int $i$f$show = 0;
        if (!this.isShowing() && !this.destroyed) {
            this.isShowing = true;
            String string = ((Balloon)this).builder.preferenceName;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (this.balloonPersistence.shouldShowUP(it, ((Balloon)this).builder.showTimes)) {
                    this.balloonPersistence.putIncrementedTimes(it);
                } else {
                    return;
                }
            }
            long dismissDelay = ((Balloon)this).builder.autoDismissDuration;
            if (dismissDelay != -1L) {
                this.dismissWithDelay(dismissDelay);
            }
            anchor.post(new Runnable(this, anchor, block){
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Function0 $block;

                public final void run() {
                    Balloon.access$getBinding$p(this.this$0).getRoot().measure(0, 0);
                    Balloon.access$getBodyWindow$p(this.this$0).setWidth(this.this$0.getMeasureWidth());
                    Balloon.access$getBodyWindow$p(this.this$0).setHeight(this.this$0.getMeasureHeight());
                    VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0).balloonText;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                    vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0);
                    this.$block.invoke();
                }
                {
                    this.this$0 = balloon2;
                    this.$anchor = view;
                    this.$block = function0;
                }
            });
        } else if (((Balloon)this).builder.dismissWhenShowAgain) {
            this.dismiss();
        }
    }

    @MainThread
    private final Balloon relay(Balloon balloon2, Function1<? super Balloon, Unit> block) {
        int $i$f$relay = 0;
        this.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this, block, balloon2){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Function1 $block;
            final /* synthetic */ Balloon $balloon;

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    this.$block.invoke((Object)this.$balloon);
                }
            }
            {
                this.this$0 = balloon2;
                this.$block = function1;
                this.$balloon = balloon3;
                super(0);
            }
        }));
        return balloon2;
    }

    public final void show(@NotNull View anchor) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getSupportRtlLayoutFactor$p(this.this$0) * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2), -this.this$0.getMeasureHeight() - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShow(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.show(this.$anchor$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void show(@NotNull View anchor, int xOff, int yOff) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShow(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.show(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAsDropDown(@NotNull View anchor) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAsDropDown(this.$anchor$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAsDropDown(@NotNull View anchor, int xOff, int yOff) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignTop(@NotNull View anchor) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getSupportRtlLayoutFactor$p(this.this$0) * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2), -this.this$0.getMeasureHeight() - this.$anchor$inlined.getMeasuredHeight());
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignTop(this.$anchor$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignTop(@NotNull View anchor, int xOff, int yOff) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getSupportRtlLayoutFactor$p(this.this$0) * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2 + this.$xOff$inlined), -this.this$0.getMeasureHeight() - this.$anchor$inlined.getMeasuredHeight() + this.$yOff$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignTop(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignBottom(@NotNull View anchor) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getSupportRtlLayoutFactor$p(this.this$0) * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2), 0);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignBottom(this.$anchor$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignBottom(@NotNull View anchor, int xOff, int yOff) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getSupportRtlLayoutFactor$p(this.this$0) * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2 + this.$xOff$inlined), this.$yOff$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignBottom(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignRight(@NotNull View anchor) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth(), -(this.this$0.getMeasureHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignRight(this.$anchor$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignRight(@NotNull View anchor, int xOff, int yOff) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() + this.$xOff$inlined, -(this.this$0.getMeasureHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignRight(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignLeft(@NotNull View anchor) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, -this.this$0.getMeasureWidth(), -(this.this$0.getMeasureHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignLeft(this.$anchor$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void showAlignLeft(@NotNull View anchor, int xOff, int yOff) {
        block6: {
            Balloon this_$iv;
            block4: {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing() || this_$iv.destroyed) break block4;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block5;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPersistence.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block6;
                    this_$iv.balloonPersistence.putIncrementedTimes(it$iv);
                }
                long dismissDelay$iv = ((Balloon)this_$iv).builder.autoDismissDuration;
                if (dismissDelay$iv != -1L) {
                    this_$iv.dismissWithDelay(dismissDelay$iv);
                }
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasureWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasureHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, -this.this$0.getMeasureWidth() + this.$xOff$inlined, -(this.this$0.getMeasureHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                    }
                });
                break block6;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)balloon2, (String)"balloon");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignLeft(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public final void update(@NotNull View anchor) {
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$update = false;
        if (this_$iv.isShowing()) {
            this_$iv.initializeArrow(anchor);
            boolean bl = false;
            this.bodyWindow.update(anchor, this.getMeasureWidth(), this.getMeasureHeight());
        }
    }

    public final void update(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$update = false;
        if (this_$iv.isShowing()) {
            this_$iv.initializeArrow(anchor);
            boolean bl = false;
            this.bodyWindow.update(anchor, xOff, yOff, this.getMeasureWidth(), this.getMeasureHeight());
        }
    }

    @MainThread
    private final void update(View anchor, Function0<Unit> block) {
        int $i$f$update = 0;
        if (this.isShowing()) {
            this.initializeArrow(anchor);
            block.invoke();
        }
    }

    public final void dismiss() {
        if (this.isShowing) {
            Function0 dismissWindow2 = (Function0)new Function0<Unit>(this){
                final /* synthetic */ Balloon this$0;

                public final void invoke() {
                    Balloon.access$setShowing$p(this.this$0, false);
                    Balloon.access$getBodyWindow$p(this.this$0).dismiss();
                }
                {
                    this.this$0 = balloon2;
                    super(0);
                }
            };
            if (this.builder.balloonAnimation == BalloonAnimation.CIRCULAR) {
                View view = this.bodyWindow.getContentView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"this.bodyWindow.contentView");
                ViewExtensionKt.circularUnRevealed(view, this.builder.circularDuration, (Function0<Unit>)((Function0)new Function0<Unit>(dismissWindow2){
                    final /* synthetic */ Function0 $dismissWindow;

                    public final void invoke() {
                        this.$dismissWindow.invoke();
                    }
                    {
                        this.$dismissWindow = function0;
                        super(0);
                    }
                }));
            } else {
                dismissWindow2.invoke();
            }
        }
    }

    public final void dismissWithDelay(long delay) {
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this){
            final /* synthetic */ Balloon this$0;

            public final void run() {
                this.this$0.dismiss();
            }
            {
                this.this$0 = balloon2;
            }
        }, delay);
    }

    public final void setOnBalloonClickListener(@NotNull Function1<? super View, Unit> unit) {
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        this.onBalloonClickListener = new OnBalloonClickListener(unit){
            final /* synthetic */ Function1 $unit;

            public void onBalloonClick(@NotNull View view) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                this.$unit.invoke((Object)view);
            }
            {
                this.$unit = $captured_local_variable$0;
            }
        };
    }

    public final void setOnBalloonDismissListener(@NotNull Function0<Unit> unit) {
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        this.onBalloonDismissListener = new OnBalloonDismissListener(unit){
            final /* synthetic */ Function0 $unit;

            public void onBalloonDismiss() {
                this.$unit.invoke();
            }
            {
                this.$unit = $captured_local_variable$0;
            }
        };
    }

    public final void setOnBalloonOutsideTouchListener(@NotNull Function2<? super View, ? super MotionEvent, Unit> unit) {
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        this.onBalloonOutsideTouchListener = new OnBalloonOutsideTouchListener(unit){
            final /* synthetic */ Function2 $unit;

            public void onBalloonOutsideTouch(@NotNull View view, @NotNull MotionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.$unit.invoke((Object)view, (Object)event);
            }
            {
                this.$unit = $captured_local_variable$0;
            }
        };
    }

    public final int getMeasureWidth() {
        int n;
        int displayWidth = ContextExtensionKt.displaySize((Context)this.context).x;
        if (this.builder.widthRatio != 0.0f) {
            n = (int)((float)displayWidth * this.builder.widthRatio - (float)this.builder.space);
        } else if (this.builder.width != Integer.MIN_VALUE && this.builder.width < displayWidth) {
            n = this.builder.width;
        } else {
            RelativeLayout relativeLayout = this.binding.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"binding.root");
            if (relativeLayout.getMeasuredWidth() > displayWidth) {
                n = displayWidth;
            } else {
                RelativeLayout relativeLayout2 = this.binding.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout2, (String)"this.binding.root");
                n = relativeLayout2.getMeasuredWidth();
            }
        }
        return n;
    }

    private final int getMeasureTextWidth(int measuredWidth) {
        int displayWidth = ContextExtensionKt.displaySize((Context)this.context).x;
        int spaces = this.builder.space + (this.builder.padding != Integer.MIN_VALUE ? this.builder.padding * 2 : this.builder.paddingLeft + this.builder.paddingRight) + ContextExtensionKt.dp2Px(this.context, 24) + (this.builder.iconDrawable != null ? this.builder.iconSize + this.builder.iconSpace : 0);
        return this.builder.widthRatio != 0.0f ? (int)((float)displayWidth * this.builder.widthRatio) - spaces : (this.builder.width != Integer.MIN_VALUE && this.builder.width <= displayWidth ? this.builder.width - spaces : (measuredWidth < displayWidth - spaces ? measuredWidth : (measuredWidth > displayWidth - spaces ? displayWidth - spaces : displayWidth - spaces)));
    }

    public final int getMeasureHeight() {
        if (this.builder.height != Integer.MIN_VALUE) {
            return this.builder.height;
        }
        RelativeLayout relativeLayout = this.binding.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"this.binding.root");
        return relativeLayout.getMeasuredHeight();
    }

    @NotNull
    public final View getContentView() {
        CardView cardView = this.binding.balloonCard;
        Intrinsics.checkExpressionValueIsNotNull((Object)cardView, (String)"binding.balloonCard");
        return (View)cardView;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public final void onPause() {
        if (this.builder.dismissWhenLifecycleOnPause) {
            this.dismiss();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void onDestroy() {
        this.destroyed = true;
        this.dismiss();
    }

    public Balloon(@NotNull Context context, @NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.context = context;
        this.builder = builder;
        LayoutBalloonBinding layoutBalloonBinding = LayoutBalloonBinding.inflate(LayoutInflater.from((Context)this.context), null, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)layoutBalloonBinding, (String)"LayoutBalloonBinding.inf\u2026om(context), null, false)");
        this.binding = layoutBalloonBinding;
        this.supportRtlLayoutFactor = DefinitionKt.unaryMinus(1, this.builder.isRtlSupport);
        this.balloonPersistence = BalloonPersistence.Companion.getInstance(this.context);
        this.bodyWindow = new PopupWindow((View)this.binding.getRoot(), -2, -2);
        this.createByBuilder();
    }

    public static final /* synthetic */ LayoutBalloonBinding access$getBinding$p(Balloon $this) {
        return $this.binding;
    }

    public static final /* synthetic */ float access$getArrowConstraintPositionX(Balloon $this, View anchor) {
        return $this.getArrowConstraintPositionX(anchor);
    }

    public static final /* synthetic */ float access$getArrowConstraintPositionY(Balloon $this, View anchor) {
        return $this.getArrowConstraintPositionY(anchor);
    }

    public static final /* synthetic */ boolean access$isShowing$p(Balloon $this) {
        return $this.isShowing;
    }

    public static final /* synthetic */ void access$setDestroyed$p(Balloon $this, boolean bl) {
        $this.destroyed = bl;
    }

    public static final /* synthetic */ void access$applyBalloonAnimation(Balloon $this) {
        $this.applyBalloonAnimation();
    }

    public static final /* synthetic */ int access$getSupportRtlLayoutFactor$p(Balloon $this) {
        return $this.supportRtlLayoutFactor;
    }

    public static final /* synthetic */ void access$setSupportRtlLayoutFactor$p(Balloon $this, int n) {
        $this.supportRtlLayoutFactor = n;
    }

    @BalloonDsl
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b4\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010V\u001a\u00020WJ\u000e\u00101\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u0010\u0010Y\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\u0006J\u0010\u0010Z\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010[\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0006J\u0010\u0010\\\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010]\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010^\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010_\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\rJ\u0010\u0010`\u001a\u00020\u00002\b\u0010X\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010a\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010b\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010c\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0012J\u0010\u0010d\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\u0006J\u0010\u0010e\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010f\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010g\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010h\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010i\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u000e\u0010j\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u001aJ\u0010\u0010k\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010l\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010m\u001a\u00020\u00002\b\u0010X\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010n\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010o\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u001eJ\u0010\u0010p\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010q\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u001aJ\u0010\u0010r\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\u0006J\u0010\u0010s\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010t\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u000e\u0010u\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u000e\u0010v\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u000e\u0010w\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u0012\u0010x\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bH\u0007J\u0012\u0010y\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bH\u0007J\u000e\u0010z\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u0010\u0010{\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010|\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010}\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010~\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0010\u0010\u007f\u001a\u00020\u00002\b\u0010X\u001a\u0004\u0018\u00010\u000fJ\u0011\u0010\u0080\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000f\u0010\u0081\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020+J\u000f\u0010\u0082\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020-J\u0011\u0010\u0083\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0084\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0085\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0086\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000f\u0010\u0087\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u000f\u0010\u0088\u0001\u001a\u00020\u00002\u0006\u00103\u001a\u000204J\u0011\u0010\u0088\u0001\u001a\u00020\u00002\b\b\u0001\u00105\u001a\u00020\bJ\u0011\u0010\u0089\u0001\u001a\u00020\u00002\b\u0010X\u001a\u0004\u0018\u000107J\u001e\u0010\u008a\u0001\u001a\u00020\u00002\u0015\u0010\u008b\u0001\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0005\u0012\u00030\u008d\u00010\u008c\u0001J\u000f\u0010\u008a\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u000209J\u0018\u0010\u008e\u0001\u001a\u00020\u00002\u000f\u0010\u008b\u0001\u001a\n\u0012\u0005\u0012\u00030\u008d\u00010\u008f\u0001J\u000f\u0010\u008e\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020;J\u001e\u0010\u0090\u0001\u001a\u00020\u00002\u0015\u0010\u008b\u0001\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0005\u0012\u00030\u008d\u00010\u008c\u0001J\u000f\u0010\u0090\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020=J%\u0010\u0091\u0001\u001a\u00020\u00002\u001c\u0010\u008b\u0001\u001a\u0017\u0012\u0004\u0012\u000204\u0012\u0005\u0012\u00030\u0093\u0001\u0012\u0005\u0012\u00030\u008d\u00010\u0092\u0001J\u000f\u0010\u0091\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020?J\u0011\u0010\u0094\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0095\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0096\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0097\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0098\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u0099\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000f\u0010\u009a\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020FJ\u000f\u0010\u009b\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\bJ\u0011\u0010\u009c\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u009d\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000f\u0010\u009e\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020JJ\u0011\u0010\u009f\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u00a0\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u000f\u0010\u00a1\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020MJ\u000f\u0010\u00a2\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\bJ\u000f\u0010\u00a3\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0018J\u0011\u0010\u00a4\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u00a5\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\u0006J\u000f\u0010\u00a6\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020SJ\u000f\u0010\u00a6\u0001\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\bJ\u0011\u0010\u00a7\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bJ\u0011\u0010\u00a8\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\u0006J\u0011\u0010\u00a9\u0001\u001a\u00020\u00002\b\b\u0001\u0010X\u001a\u00020\bR\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u0004\u0018\u00010+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010.\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00102\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u0004\u0018\u0001048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u0004\u0018\u0001078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\u0004\u0018\u0001098\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u0004\u0018\u00010;8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u0004\u0018\u00010=8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u0004\u0018\u00010?8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010@\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010A\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010B\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010C\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010D\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u0004\u0018\u00010F8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010G\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010H\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010I\u001a\u00020J8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010K\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\u0004\u0018\u00010M8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010N\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010O\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010P\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Q\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\u0004\u0018\u00010S8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010T\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010U\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00aa\u0001"}, d2={"Lcom/skydoves/balloon/Balloon$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alpha", "", "arrowAlignAnchorPadding", "", "arrowAlignAnchorPaddingRatio", "arrowBottomPadding", "arrowColor", "arrowConstraints", "Lcom/skydoves/balloon/ArrowConstraints;", "arrowDrawable", "Landroid/graphics/drawable/Drawable;", "arrowLeftPadding", "arrowOrientation", "Lcom/skydoves/balloon/ArrowOrientation;", "arrowPosition", "arrowRightPadding", "arrowSize", "arrowTopPadding", "arrowVisible", "", "autoDismissDuration", "", "backgroundColor", "backgroundDrawable", "balloonAnimation", "Lcom/skydoves/balloon/BalloonAnimation;", "balloonAnimationStyle", "circularDuration", "cornerRadius", "dismissWhenClicked", "dismissWhenLifecycleOnPause", "dismissWhenShowAgain", "dismissWhenTouchOutside", "elevation", "height", "iconColor", "iconDrawable", "iconForm", "Lcom/skydoves/balloon/IconForm;", "iconGravity", "Lcom/skydoves/balloon/IconGravity;", "iconSize", "iconSpace", "isFocusable", "isRtlSupport", "isStatusBarVisible", "layout", "Landroid/view/View;", "layoutRes", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "onBalloonInitializedListener", "Lcom/skydoves/balloon/OnBalloonInitializedListener;", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "padding", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "preferenceName", "", "showTimes", "space", "text", "", "textColor", "textForm", "Lcom/skydoves/balloon/TextForm;", "textGravity", "textIsHtml", "textSize", "textTypeface", "textTypefaceObject", "Landroid/graphics/Typeface;", "width", "widthRatio", "build", "Lcom/skydoves/balloon/Balloon;", "value", "setAlpha", "setArrowAlignAnchorPadding", "setArrowAlignAnchorPaddingRatio", "setArrowBottomPadding", "setArrowColor", "setArrowColorResource", "setArrowConstraints", "setArrowDrawable", "setArrowDrawableResource", "setArrowLeftPadding", "setArrowOrientation", "setArrowPosition", "setArrowRightPadding", "setArrowSize", "setArrowSizeResource", "setArrowTopPadding", "setArrowVisible", "setAutoDismissDuration", "setBackgroundColor", "setBackgroundColorResource", "setBackgroundDrawable", "setBackgroundDrawableResource", "setBalloonAnimation", "setBalloonAnimationStyle", "setCircularDuration", "setCornerRadius", "setCornerRadiusResource", "setDismissWhenClicked", "setDismissWhenLifecycleOnPause", "setDismissWhenShowAgain", "setDismissWhenTouchOutside", "setElevation", "setElevationResource", "setFocusable", "setHeight", "setHeightResource", "setIconColor", "setIconColorResource", "setIconDrawable", "setIconDrawableResource", "setIconForm", "setIconGravity", "setIconSize", "setIconSizeResource", "setIconSpace", "setIconSpaceResource", "setIsStatusBarVisible", "setLayout", "setLifecycleOwner", "setOnBalloonClickListener", "unit", "Lkotlin/Function1;", "", "setOnBalloonDismissListener", "Lkotlin/Function0;", "setOnBalloonInitializedListener", "setOnBalloonOutsideTouchListener", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "setPadding", "setPaddingBottom", "setPaddingLeft", "setPaddingResource", "setPaddingRight", "setPaddingTop", "setPreferenceName", "setShowTime", "setSpace", "setSpaceResource", "setText", "setTextColor", "setTextColorResource", "setTextForm", "setTextGravity", "setTextIsHtml", "setTextResource", "setTextSize", "setTextTypeface", "setWidth", "setWidthRatio", "setWidthResource", "balloon_release"})
    public static final class Builder {
        @JvmField
        @Px
        public int width;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float widthRatio;
        @JvmField
        @Px
        public int height;
        @JvmField
        @Px
        public int padding;
        @JvmField
        @Px
        public int paddingLeft;
        @JvmField
        @Px
        public int paddingTop;
        @JvmField
        @Px
        public int paddingRight;
        @JvmField
        @Px
        public int paddingBottom;
        @JvmField
        @Px
        public int space;
        @JvmField
        public boolean arrowVisible;
        @JvmField
        @ColorInt
        public int arrowColor;
        @JvmField
        @Px
        public int arrowSize;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float arrowPosition;
        @JvmField
        @NotNull
        public ArrowConstraints arrowConstraints;
        @JvmField
        @NotNull
        public ArrowOrientation arrowOrientation;
        @JvmField
        @Nullable
        public Drawable arrowDrawable;
        @JvmField
        public int arrowLeftPadding;
        @JvmField
        public int arrowRightPadding;
        @JvmField
        public int arrowTopPadding;
        @JvmField
        public int arrowBottomPadding;
        @JvmField
        public int arrowAlignAnchorPadding;
        @JvmField
        public float arrowAlignAnchorPaddingRatio;
        @JvmField
        @ColorInt
        public int backgroundColor;
        @JvmField
        @Nullable
        public Drawable backgroundDrawable;
        @JvmField
        @Px
        public float cornerRadius;
        @JvmField
        @NotNull
        public CharSequence text;
        @JvmField
        @ColorInt
        public int textColor;
        @JvmField
        public boolean textIsHtml;
        @JvmField
        @Sp
        public float textSize;
        @JvmField
        public int textTypeface;
        @JvmField
        @Nullable
        public Typeface textTypefaceObject;
        @JvmField
        public int textGravity;
        @JvmField
        @Nullable
        public TextForm textForm;
        @JvmField
        @Nullable
        public Drawable iconDrawable;
        @JvmField
        @NotNull
        public IconGravity iconGravity;
        @JvmField
        @Px
        public int iconSize;
        @JvmField
        @Px
        public int iconSpace;
        @JvmField
        @ColorInt
        public int iconColor;
        @JvmField
        @Nullable
        public IconForm iconForm;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float alpha;
        @JvmField
        public float elevation;
        @JvmField
        @Nullable
        public View layout;
        @JvmField
        @LayoutRes
        public int layoutRes;
        @JvmField
        @Nullable
        public OnBalloonClickListener onBalloonClickListener;
        @JvmField
        @Nullable
        public OnBalloonDismissListener onBalloonDismissListener;
        @JvmField
        @Nullable
        public OnBalloonInitializedListener onBalloonInitializedListener;
        @JvmField
        @Nullable
        public OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
        @JvmField
        public boolean dismissWhenTouchOutside;
        @JvmField
        public boolean dismissWhenShowAgain;
        @JvmField
        public boolean dismissWhenClicked;
        @JvmField
        public boolean dismissWhenLifecycleOnPause;
        @JvmField
        public long autoDismissDuration;
        @JvmField
        @Nullable
        public LifecycleOwner lifecycleOwner;
        @JvmField
        @StyleRes
        public int balloonAnimationStyle;
        @JvmField
        @NotNull
        public BalloonAnimation balloonAnimation;
        @JvmField
        public long circularDuration;
        @JvmField
        @Nullable
        public String preferenceName;
        @JvmField
        public int showTimes;
        @JvmField
        public boolean isRtlSupport;
        @JvmField
        public boolean isFocusable;
        @JvmField
        public boolean isStatusBarVisible;
        private final Context context;

        @NotNull
        public final Builder setWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = value2 > 0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "The width of the balloon must bigger than zero.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.width = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.width = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.widthRatio = value2;
            return builder;
        }

        @NotNull
        public final Builder setHeight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.height = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setHeightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.height = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.padding = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.padding = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingLeft(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingLeft = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingTop(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingTop = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingRight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingRight = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingBottom(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingBottom = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setSpace(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.space = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setSpaceResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.space = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowVisible(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowVisible = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowSize(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowSize = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowSize = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowPosition(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowPosition = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowConstraints(@NotNull ArrowConstraints value2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowConstraints = value2;
            return builder;
        }

        @NotNull
        public final Builder setIsStatusBarVisible(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isStatusBarVisible = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientation(@NotNull ArrowOrientation value2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowOrientation = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$apply.arrowDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            $this$apply.arrowDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setArrowLeftPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowLeftPadding = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowRightPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowRightPadding = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowTopPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowTopPadding = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowBottomPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowBottomPadding = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowAlignAnchorPadding = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPaddingRatio(float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowAlignAnchorPaddingRatio = value2;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$apply.backgroundDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            $this$apply.backgroundDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setCornerRadius(@Dp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cornerRadius = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setCornerRadiusResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cornerRadius = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull CharSequence value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.text = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextResource(@StringRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            String string = $this$apply.context.getString(value2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.getString(value)");
            $this$apply.text = string;
            return builder;
        }

        @NotNull
        public final Builder setTextColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setTextIsHtml(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textIsHtml = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextSize(@Sp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textSize = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypeface = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(@NotNull Typeface value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypefaceObject = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextGravity(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textGravity = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextForm(@NotNull TextForm value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textForm = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$apply.iconDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            $this$apply.iconDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setIconGravity(@NotNull IconGravity value2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconGravity = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconSize(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSize = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSize = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconColorResource(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSpace(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSpace = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSpaceResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSpace = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconForm(@NotNull IconForm value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconForm = value2;
            return builder;
        }

        @NotNull
        public final Builder setAlpha(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.alpha = value2;
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setElevation(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.elevation = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setElevationResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.elevation = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setLayout(@LayoutRes int layoutRes) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.layoutRes = layoutRes;
            return builder;
        }

        @NotNull
        public final Builder setLayout(@NotNull View layout2) {
            Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.layout = layout2;
            return builder;
        }

        @NotNull
        public final Builder setLifecycleOwner(@Nullable LifecycleOwner value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.lifecycleOwner = value2;
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimation(@NotNull BalloonAnimation value2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonAnimation = value2;
            if (value2 == BalloonAnimation.CIRCULAR) {
                $this$apply.setFocusable(false);
            }
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimationStyle(@StyleRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonAnimationStyle = value2;
            return builder;
        }

        @NotNull
        public final Builder setCircularDuration(long value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.circularDuration = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull OnBalloonClickListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull OnBalloonDismissListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonInitializedListener(@NotNull OnBalloonInitializedListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonInitializedListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull OnBalloonOutsideTouchListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull Function1<? super View, Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = new OnBalloonClickListener(unit){
                final /* synthetic */ Function1 $unit$inlined;
                {
                    this.$unit$inlined = function1;
                }

                public void onBalloonClick(@NotNull View view) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    this.$unit$inlined.invoke((Object)view);
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull Function0<Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = new OnBalloonDismissListener(unit){
                final /* synthetic */ Function0 $unit$inlined;
                {
                    this.$unit$inlined = function0;
                }

                public void onBalloonDismiss() {
                    this.$unit$inlined.invoke();
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonInitializedListener(@NotNull Function1<? super View, Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonInitializedListener = new OnBalloonInitializedListener(unit){
                final /* synthetic */ Function1 $unit$inlined;
                {
                    this.$unit$inlined = function1;
                }

                public void onBalloonInitialized(@NotNull View contentView) {
                    Intrinsics.checkParameterIsNotNull((Object)contentView, (String)"contentView");
                    this.$unit$inlined.invoke((Object)contentView);
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull Function2<? super View, ? super MotionEvent, Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = new OnBalloonOutsideTouchListener(unit){
                final /* synthetic */ Function2 $unit$inlined;
                {
                    this.$unit$inlined = function2;
                }

                public void onBalloonOutsideTouch(@NotNull View view, @NotNull MotionEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.$unit$inlined.invoke((Object)view, (Object)event);
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenTouchOutside(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenTouchOutside = value2;
            if (!value2) {
                $this$apply.setFocusable(value2);
            }
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenShowAgain(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenShowAgain = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenClicked(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenClicked = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenLifecycleOnPause(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenLifecycleOnPause = value2;
            return builder;
        }

        @NotNull
        public final Builder setAutoDismissDuration(long value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.autoDismissDuration = value2;
            return builder;
        }

        @NotNull
        public final Builder setPreferenceName(@NotNull String value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.preferenceName = value2;
            return builder;
        }

        @NotNull
        public final Builder setShowTime(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.showTimes = value2;
            return builder;
        }

        @NotNull
        public final Builder isRtlSupport(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isRtlSupport = value2;
            return builder;
        }

        @NotNull
        public final Builder setFocusable(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isFocusable = value2;
            return builder;
        }

        @NotNull
        public final Balloon build() {
            return new Balloon(this.context, this);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.width = Integer.MIN_VALUE;
            this.height = Integer.MIN_VALUE;
            this.padding = Integer.MIN_VALUE;
            this.arrowVisible = true;
            this.arrowColor = Integer.MIN_VALUE;
            this.arrowSize = ContextExtensionKt.dp2Px(this.context, 12);
            this.arrowPosition = 0.5f;
            this.arrowConstraints = ArrowConstraints.ALIGN_BALLOON;
            this.arrowOrientation = ArrowOrientation.BOTTOM;
            this.arrowAlignAnchorPaddingRatio = 2.5f;
            this.backgroundColor = -16777216;
            this.cornerRadius = ContextExtensionKt.dp2Px(this.context, 5);
            this.text = "";
            this.textColor = -1;
            this.textSize = 12.0f;
            this.textGravity = 17;
            this.iconGravity = IconGravity.LEFT;
            this.iconSize = ContextExtensionKt.dp2Px(this.context, 28);
            this.iconSpace = ContextExtensionKt.dp2Px(this.context, 8);
            this.iconColor = -1;
            this.alpha = 1.0f;
            this.elevation = ContextExtensionKt.dp2Px(this.context, 2.0f);
            this.layoutRes = Integer.MIN_VALUE;
            this.dismissWhenTouchOutside = true;
            this.autoDismissDuration = -1L;
            this.balloonAnimationStyle = Integer.MIN_VALUE;
            this.balloonAnimation = BalloonAnimation.FADE;
            this.circularDuration = 500L;
            this.showTimes = 1;
            this.isFocusable = true;
            this.isStatusBarVisible = true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/skydoves/balloon/Balloon$Factory;", "", "()V", "create", "Lcom/skydoves/balloon/Balloon;", "context", "Landroid/content/Context;", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "balloon_release"})
    public static abstract class Factory {
        @NotNull
        public abstract Balloon create(@NotNull Context var1, @Nullable LifecycleOwner var2);
    }
}

