/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.skydoves.balloon.ArrowOrientation;
import com.skydoves.balloon.Balloon$WhenMappings;
import com.skydoves.balloon.BalloonAnimation;
import com.skydoves.balloon.BalloonDsl;
import com.skydoves.balloon.BalloonPreferenceManager;
import com.skydoves.balloon.ContextExtensionKt;
import com.skydoves.balloon.IconForm;
import com.skydoves.balloon.ImageViewExtensionKt;
import com.skydoves.balloon.OnBalloonClickListener;
import com.skydoves.balloon.OnBalloonDismissListener;
import com.skydoves.balloon.OnBalloonOutsideTouchListener;
import com.skydoves.balloon.R;
import com.skydoves.balloon.TextForm;
import com.skydoves.balloon.TextViewExtensionKt;
import com.skydoves.balloon.ViewExtensionKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0006\u0010&\u001a\u00020$J\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020$H\u0002J\b\u0010-\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020$H\u0002J\b\u0010/\u001a\u00020$H\u0002J\b\u00100\u001a\u00020$H\u0002J\u0019\u00101\u001a\u00020$2\u000e\b\u0004\u00102\u001a\b\u0012\u0004\u0012\u00020$03H\u0082\bJ\u000e\u00101\u001a\u00020$2\u0006\u00104\u001a\u00020\nJ\u001e\u00101\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)J\u000e\u00107\u001a\u00020$2\u0006\u00104\u001a\u00020\nJ\u001e\u00107\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)J\u000e\u00108\u001a\u00020$2\u0006\u00104\u001a\u00020\nJ\u001e\u00108\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)J\u000e\u00109\u001a\u00020$2\u0006\u00104\u001a\u00020\nJ\u001e\u00109\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)J\u000e\u0010:\u001a\u00020$2\u0006\u00104\u001a\u00020\nJ\u001e\u0010:\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)J\u000e\u0010;\u001a\u00020$2\u0006\u00104\u001a\u00020\nJ\u001e\u0010;\u001a\u00020$2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006="}, d2={"Lcom/skydoves/balloon/Balloon;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "builder", "Lcom/skydoves/balloon/Balloon$Builder;", "(Landroid/content/Context;Lcom/skydoves/balloon/Balloon$Builder;)V", "balloonPreferenceManager", "Lcom/skydoves/balloon/BalloonPreferenceManager;", "bodyView", "Landroid/view/View;", "bodyWindow", "Landroid/widget/PopupWindow;", "<set-?>", "", "isShowing", "()Z", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "getOnBalloonClickListener", "()Lcom/skydoves/balloon/OnBalloonClickListener;", "setOnBalloonClickListener", "(Lcom/skydoves/balloon/OnBalloonClickListener;)V", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "getOnBalloonDismissListener", "()Lcom/skydoves/balloon/OnBalloonDismissListener;", "setOnBalloonDismissListener", "(Lcom/skydoves/balloon/OnBalloonDismissListener;)V", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "getOnBalloonOutsideTouchListener", "()Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "setOnBalloonOutsideTouchListener", "(Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;)V", "applyBalloonAnimation", "", "createByBuilder", "dismiss", "getContentView", "getMeasureWidth", "", "initializeArrow", "initializeBackground", "initializeBalloonContent", "initializeBalloonListeners", "initializeCustomLayout", "initializeIcon", "initializeText", "show", "block", "Lkotlin/Function0;", "anchor", "xOff", "yOff", "showAlignBottom", "showAlignLeft", "showAlignRight", "showAlignTop", "showAsDropDown", "Builder", "balloon_release"})
@SuppressLint(value={"InflateParams"})
public final class Balloon
implements LifecycleObserver {
    private final View bodyView;
    private final PopupWindow bodyWindow;
    private boolean isShowing;
    @Nullable
    private OnBalloonClickListener onBalloonClickListener;
    @Nullable
    private OnBalloonDismissListener onBalloonDismissListener;
    @Nullable
    private OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
    private final BalloonPreferenceManager balloonPreferenceManager;
    private final Context context;
    private final Builder builder;

    public final boolean isShowing() {
        return this.isShowing;
    }

    @Nullable
    public final OnBalloonClickListener getOnBalloonClickListener() {
        return this.onBalloonClickListener;
    }

    public final void setOnBalloonClickListener(@Nullable OnBalloonClickListener onBalloonClickListener) {
        this.onBalloonClickListener = onBalloonClickListener;
    }

    @Nullable
    public final OnBalloonDismissListener getOnBalloonDismissListener() {
        return this.onBalloonDismissListener;
    }

    public final void setOnBalloonDismissListener(@Nullable OnBalloonDismissListener onBalloonDismissListener) {
        this.onBalloonDismissListener = onBalloonDismissListener;
    }

    @Nullable
    public final OnBalloonOutsideTouchListener getOnBalloonOutsideTouchListener() {
        return this.onBalloonOutsideTouchListener;
    }

    public final void setOnBalloonOutsideTouchListener(@Nullable OnBalloonOutsideTouchListener onBalloonOutsideTouchListener) {
        this.onBalloonOutsideTouchListener = onBalloonOutsideTouchListener;
    }

    private final void createByBuilder() {
        block2: {
            LifecycleOwner lifecycleOwner;
            this.initializeArrow();
            this.initializeBackground();
            this.initializeBalloonListeners();
            if (this.builder.layout == -1) {
                this.initializeBalloonContent();
                this.initializeIcon();
                this.initializeText();
            } else {
                this.initializeCustomLayout();
            }
            if ((lifecycleOwner = this.builder.lifecycleOwner) == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null) break block2;
            lifecycleOwner.addObserver((LifecycleObserver)this);
        }
    }

    private final void initializeArrow() {
        ImageView imageView = (ImageView)this.bodyView.findViewById(R.id.balloon_arrow);
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$with = imageView;
        boolean bl3 = false;
        Drawable drawable = this.builder.arrowDrawable;
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl4 = false;
            boolean bl5 = false;
            Drawable it = drawable2;
            boolean bl6 = false;
            $this$with.setImageDrawable(it);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.builder.arrowSize, this.builder.arrowSize);
        switch (Balloon$WhenMappings.$EnumSwitchMapping$0[this.builder.arrowOrientation.ordinal()]) {
            case 1: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(8, relativeLayout.getId());
                $this$with.setRotation(180.0f);
                break;
            }
            case 2: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(6, relativeLayout.getId());
                $this$with.setRotation(0.0f);
                break;
            }
            case 3: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(5, relativeLayout.getId());
                $this$with.setRotation(-90.0f);
                break;
            }
            case 4: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(7, relativeLayout.getId());
                $this$with.setRotation(90.0f);
            }
        }
        switch (Balloon$WhenMappings.$EnumSwitchMapping$1[this.builder.arrowOrientation.ordinal()]) {
            case 1: 
            case 2: {
                $this$with.setX((float)this.bodyWindow.getWidth() * this.builder.arrowPosition - (float)(this.builder.arrowSize / 2));
                break;
            }
            case 3: 
            case 4: {
                $this$with.setY((float)this.bodyWindow.getHeight() * this.builder.arrowPosition - (float)(this.builder.arrowSize / 2));
            }
        }
        $this$with.setLayoutParams((ViewGroup.LayoutParams)params);
        $this$with.setAlpha(this.builder.getAlpha());
        ViewExtensionKt.visible((View)$this$with, this.builder.arrowVisible);
        ImageViewCompat.setImageTintList((ImageView)$this$with, (ColorStateList)ColorStateList.valueOf((int)this.builder.backgroundColor));
    }

    private final void initializeBackground() {
        LinearLayout linearLayout = (LinearLayout)this.bodyView.findViewById(R.id.balloon_background);
        boolean bl = false;
        boolean bl2 = false;
        LinearLayout $this$with = linearLayout;
        boolean bl3 = false;
        $this$with.setAlpha(this.builder.getAlpha());
        if (this.builder.backgroundDrawable == null) {
            Drawable drawable2 = ContextCompat.getDrawable((Context)$this$with.getContext(), (int)R.drawable.rectangle_layout);
            if (drawable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
            }
            GradientDrawable drawable3 = (GradientDrawable)drawable2;
            drawable3.setColor(this.builder.backgroundColor);
            drawable3.setCornerRadius(this.builder.cornerRadius);
            $this$with.setBackground((Drawable)drawable3);
        } else {
            $this$with.setBackground(this.builder.backgroundDrawable);
        }
        $this$with.setAlpha(this.builder.getAlpha());
    }

    private final void initializeBalloonListeners() {
        this.onBalloonClickListener = this.builder.onBalloonClickListener;
        this.onBalloonDismissListener = this.builder.onBalloonDismissListener;
        this.onBalloonOutsideTouchListener = this.builder.onBalloonOutsideTouchListener;
        this.bodyView.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ Balloon this$0;

            public final void onClick(View it) {
                block0: {
                    OnBalloonClickListener onBalloonClickListener = this.this$0.getOnBalloonClickListener();
                    if (onBalloonClickListener == null) break block0;
                    onBalloonClickListener.onBalloonClick();
                }
            }
            {
                this.this$0 = balloon2;
            }
        });
        this.bodyWindow.setOnDismissListener(new PopupWindow.OnDismissListener(this){
            final /* synthetic */ Balloon this$0;

            public final void onDismiss() {
                block0: {
                    OnBalloonDismissListener onBalloonDismissListener = this.this$0.getOnBalloonDismissListener();
                    if (onBalloonDismissListener == null) break block0;
                    onBalloonDismissListener.onBalloonDismiss();
                }
            }
            {
                this.this$0 = balloon2;
            }
        });
        this.bodyWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.bodyWindow.setOutsideTouchable(true);
        this.bodyWindow.setTouchInterceptor(new View.OnTouchListener(this){
            final /* synthetic */ Balloon this$0;

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenTouchOutside) {
                    this.this$0.dismiss();
                }
                if (event.getAction() == 4) {
                    OnBalloonOutsideTouchListener onBalloonOutsideTouchListener = this.this$0.getOnBalloonOutsideTouchListener();
                    if (onBalloonOutsideTouchListener != null) {
                        onBalloonOutsideTouchListener.onBalloonOutsideTouch();
                    }
                    return true;
                }
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initializeBalloonContent() {
        RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
        boolean bl = false;
        boolean bl2 = false;
        RelativeLayout $this$with = relativeLayout;
        boolean bl3 = false;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$2[this.builder.arrowOrientation.ordinal()]) {
            case 1: 
            case 2: {
                $this$with.setPadding(this.builder.arrowSize, this.builder.arrowSize, this.builder.arrowSize, this.builder.arrowSize);
                break;
            }
            case 3: 
            case 4: {
                $this$with.setPadding(this.builder.arrowSize, $this$with.getPaddingTop(), $this$with.getPaddingBottom(), this.builder.arrowSize);
            }
        }
    }

    private final void initializeIcon() {
        block1: {
            if (this.builder.iconDrawable == null) break block1;
            ImageView imageView = (ImageView)this.bodyView.findViewById(R.id.balloon_icon);
            boolean bl = false;
            boolean bl2 = false;
            ImageView $this$with = imageView;
            boolean bl3 = false;
            ViewExtensionKt.visible((View)$this$with, true);
            $this$with.setImageDrawable(this.builder.iconDrawable);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.builder.iconSize, this.builder.iconSize);
            params.setMargins(0, 0, this.builder.iconSpace, 0);
            $this$with.setLayoutParams((ViewGroup.LayoutParams)params);
            IconForm iconForm = this.builder.iconForm;
            if (iconForm != null) {
                IconForm iconForm2 = iconForm;
                boolean bl4 = false;
                boolean bl5 = false;
                IconForm it = iconForm2;
                boolean bl6 = false;
                ImageViewExtensionKt.applyIconForm($this$with, it);
            }
        }
    }

    private final void initializeText() {
        block0: {
            TextView textView = (TextView)this.bodyView.findViewById(R.id.balloon_text);
            boolean bl = false;
            boolean bl2 = false;
            TextView $this$with = textView;
            boolean bl3 = false;
            $this$with.setText((CharSequence)this.builder.text);
            $this$with.setTextSize(this.builder.textSize);
            $this$with.setTextColor(this.builder.textColor);
            $this$with.setTypeface($this$with.getTypeface(), this.builder.textTypeface);
            TextForm textForm = this.builder.textForm;
            if (textForm == null) break block0;
            TextForm textForm2 = textForm;
            boolean bl4 = false;
            boolean bl5 = false;
            TextForm it = textForm2;
            boolean bl6 = false;
            TextViewExtensionKt.applyTextForm($this$with, it);
        }
    }

    private final void initializeCustomLayout() {
        ((LinearLayout)this.bodyView.findViewById(R.id.balloon_detail)).removeAllViews();
        Object object = this.context.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        inflater.inflate(this.builder.layout, (ViewGroup)((LinearLayout)this.bodyView.findViewById(R.id.balloon_detail)));
    }

    private final void applyBalloonAnimation() {
        switch (Balloon$WhenMappings.$EnumSwitchMapping$3[this.builder.balloonAnimation.ordinal()]) {
            case 1: {
                this.bodyWindow.setAnimationStyle(R.style.Elastic);
                break;
            }
            case 2: {
                View view = this.bodyWindow.getContentView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bodyWindow.contentView");
                ViewExtensionKt.circularRevealed(view);
                this.bodyWindow.setAnimationStyle(R.style.NormalDispose);
                break;
            }
            case 3: {
                this.bodyWindow.setAnimationStyle(R.style.Fade);
                break;
            }
            default: {
                this.bodyWindow.setAnimationStyle(R.style.Normal);
            }
        }
    }

    private final void show(Function0<Unit> block) {
        int $i$f$show = 0;
        if (!this.isShowing()) {
            String string = ((Balloon)this).builder.preferenceName;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (this.balloonPreferenceManager.shouldShowUP(it, ((Balloon)this).builder.showTimes)) {
                    this.balloonPreferenceManager.putIncrementedTimes(it);
                } else {
                    return;
                }
            }
            this.applyBalloonAnimation();
            this.isShowing = true;
            block.invoke();
        }
    }

    public final void show(@NotNull View anchor) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, -(anchor.getMeasuredWidth() / 2), -((Balloon)this).builder.height - anchor.getMeasuredHeight() / 2);
        }
    }

    public final void show(@NotNull View anchor, int xOff, int yOff) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, xOff, yOff);
        }
    }

    public final void showAsDropDown(@NotNull View anchor) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor);
        }
    }

    public final void showAsDropDown(@NotNull View anchor, int xOff, int yOff) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, xOff, yOff);
        }
    }

    public final void showAlignTop(@NotNull View anchor) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 - this.getMeasureWidth() / 2, -((Balloon)this).builder.height - anchor.getMeasuredHeight());
        }
    }

    public final void showAlignTop(@NotNull View anchor, int xOff, int yOff) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 - this.getMeasureWidth() / 2 + xOff, -((Balloon)this).builder.height - anchor.getMeasuredHeight() + yOff);
        }
    }

    public final void showAlignBottom(@NotNull View anchor) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 - this.getMeasureWidth() / 2, 0);
        }
    }

    public final void showAlignBottom(@NotNull View anchor, int xOff, int yOff) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() / 2 - this.getMeasureWidth() / 2 + xOff, yOff);
        }
    }

    public final void showAlignRight(@NotNull View anchor) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, anchor.getMeasuredWidth(), -(((Balloon)this).builder.height / 2) - anchor.getMeasuredHeight() / 2);
        }
    }

    public final void showAlignRight(@NotNull View anchor, int xOff, int yOff) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, anchor.getMeasuredWidth() + xOff, -(((Balloon)this).builder.height / 2) - anchor.getMeasuredHeight() / 2 + yOff);
        }
    }

    public final void showAlignLeft(@NotNull View anchor) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, -this.getMeasureWidth(), -(((Balloon)this).builder.height / 2) - anchor.getMeasuredHeight() / 2);
        }
    }

    public final void showAlignLeft(@NotNull View anchor, int xOff, int yOff) {
        block2: {
            Balloon this_$iv;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                this_$iv = this;
                boolean $i$f$show = false;
                if (this_$iv.isShowing()) break block2;
                String string = ((Balloon)this_$iv).builder.preferenceName;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it$iv = string2;
                boolean bl3 = false;
                if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block2;
                this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
            }
            this_$iv.applyBalloonAnimation();
            this_$iv.isShowing = true;
            boolean bl = false;
            this.bodyWindow.showAsDropDown(anchor, -this.getMeasureWidth() + xOff, -(((Balloon)this).builder.height / 2) - anchor.getMeasuredHeight() / 2 + yOff);
        }
    }

    public final void dismiss() {
        if (this.isShowing) {
            this.bodyWindow.dismiss();
            this.isShowing = false;
        }
    }

    public final int getMeasureWidth() {
        if (this.builder.widthRatio != 0.0f) {
            return (int)((float)ContextExtensionKt.displaySize((Context)this.context).x * this.builder.widthRatio - (float)this.builder.space);
        }
        return this.builder.width - this.builder.space;
    }

    @NotNull
    public final View getContentView() {
        LinearLayout linearLayout = (LinearLayout)this.bodyView.findViewById(R.id.balloon_detail);
        Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"bodyView.balloon_detail");
        return (View)linearLayout;
    }

    public Balloon(@NotNull Context context, @NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.context = context;
        this.builder = builder;
        this.balloonPreferenceManager = new BalloonPreferenceManager(this.context).getInstance();
        Object object = this.context.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        View view = inflater.inflate(R.layout.layout_balloon, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"inflater.inflate(R.layout.layout_balloon, null)");
        this.bodyView = view;
        int width = this.getMeasureWidth();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, this.builder.height);
        this.bodyView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.bodyWindow = new PopupWindow(this.bodyView, width, this.builder.height);
        this.createByBuilder();
    }

    public static final /* synthetic */ boolean access$isShowing$p(Balloon $this) {
        return $this.isShowing;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @BalloonDsl
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00105\u001a\u000206J\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u00107\u001a\u00020\u0006J\u0010\u00108\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\fJ\u000e\u00109\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u000eJ\u0010\u0010:\u001a\u00020\u00002\b\b\u0001\u00107\u001a\u00020\u0006J\u000e\u0010;\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u000e\u0010<\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0013J\u000e\u0010=\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u0010\u0010>\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\fJ\u000e\u0010?\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0017J\u000e\u0010@\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0006J\u000e\u0010A\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0013J\u000e\u0010B\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u0010\u0010C\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\fJ\u000e\u0010D\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u001dJ\u000e\u0010E\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u000e\u0010F\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u0010\u0010G\u001a\u00020\u00002\b\b\u0001\u0010 \u001a\u00020\u0011J\u000e\u0010H\u001a\u00020\u00002\u0006\u00107\u001a\u00020\"J\u0014\u0010I\u001a\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KJ\u000e\u0010I\u001a\u00020\u00002\u0006\u00107\u001a\u00020$J\u0014\u0010M\u001a\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KJ\u000e\u0010M\u001a\u00020\u00002\u0006\u00107\u001a\u00020&J\u0014\u0010N\u001a\u00020\u00002\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0KJ\u000e\u0010N\u001a\u00020\u00002\u0006\u00107\u001a\u00020(J\u000e\u0010O\u001a\u00020\u00002\u0006\u00107\u001a\u00020*J\u000e\u0010P\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u000e\u0010Q\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u000e\u0010R\u001a\u00020\u00002\u0006\u00107\u001a\u00020*J\u000e\u0010S\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u000e\u0010T\u001a\u00020\u00002\u0006\u00107\u001a\u000200J\u000e\u0010U\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0006J\u000e\u0010V\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u000e\u0010W\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0011J\u0010\u0010X\u001a\u00020\u00002\b\b\u0001\u00107\u001a\u00020\u0006R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u0004\u0018\u00010\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u0004\u0018\u00010$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u0004\u0018\u00010&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u0004\u0018\u00010(8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u0004\u0018\u00010*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00020*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010.\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0004\u0018\u0001008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00102\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00103\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00104\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/skydoves/balloon/Balloon$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "arrowDrawable", "Landroid/graphics/drawable/Drawable;", "arrowOrientation", "Lcom/skydoves/balloon/ArrowOrientation;", "arrowPosition", "arrowSize", "", "arrowVisible", "", "backgroundColor", "backgroundDrawable", "balloonAnimation", "Lcom/skydoves/balloon/BalloonAnimation;", "cornerRadius", "dismissWhenTouchOutside", "height", "iconDrawable", "iconForm", "Lcom/skydoves/balloon/IconForm;", "iconSize", "iconSpace", "layout", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "preferenceName", "", "showTimes", "space", "text", "textColor", "textForm", "Lcom/skydoves/balloon/TextForm;", "textSize", "textTypeface", "width", "widthRatio", "build", "Lcom/skydoves/balloon/Balloon;", "value", "setArrowDrawable", "setArrowOrientation", "setArrowPosition", "setArrowSize", "setArrowVisible", "setBackgroundColor", "setBackgroundDrawable", "setBalloonAnimation", "setCornerRadius", "setDismissWhenTouchOutside", "setHeight", "setIconDrawable", "setIconForm", "setIconSize", "setIconSpace", "setLayout", "setLifecycleOwner", "setOnBalloonClickListener", "unit", "Lkotlin/Function0;", "", "setOnBalloonDismissListener", "setOnBalloonOutsideTouchListener", "setPreferenceName", "setShowTime", "setSpace", "setText", "setTextColor", "setTextForm", "setTextSize", "setTextTypeface", "setWidth", "setWidthRatio", "balloon_release"})
    public static final class Builder {
        @JvmField
        public int width;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float widthRatio;
        @JvmField
        public int height;
        @JvmField
        public int space;
        @JvmField
        public boolean arrowVisible;
        @JvmField
        public int arrowSize;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float arrowPosition;
        @JvmField
        @NotNull
        public ArrowOrientation arrowOrientation;
        @JvmField
        @Nullable
        public Drawable arrowDrawable;
        @JvmField
        public int backgroundColor;
        @JvmField
        @Nullable
        public Drawable backgroundDrawable;
        @JvmField
        public float cornerRadius;
        @JvmField
        @NotNull
        public String text;
        @JvmField
        public int textColor;
        @JvmField
        public float textSize;
        @JvmField
        public int textTypeface;
        @JvmField
        @Nullable
        public TextForm textForm;
        @JvmField
        @Nullable
        public Drawable iconDrawable;
        @JvmField
        public int iconSize;
        @JvmField
        public int iconSpace;
        @JvmField
        @Nullable
        public IconForm iconForm;
        @FloatRange(from=0.0, to=1.0)
        private float alpha;
        @JvmField
        @LayoutRes
        public int layout;
        @JvmField
        @Nullable
        public OnBalloonClickListener onBalloonClickListener;
        @JvmField
        @Nullable
        public OnBalloonDismissListener onBalloonDismissListener;
        @JvmField
        @Nullable
        public OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
        @JvmField
        public boolean dismissWhenTouchOutside;
        @JvmField
        @Nullable
        public LifecycleOwner lifecycleOwner;
        @JvmField
        @NotNull
        public BalloonAnimation balloonAnimation;
        @JvmField
        @Nullable
        public String preferenceName;
        @JvmField
        public int showTimes;
        private final Context context;

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        @NotNull
        public final Builder setWidth(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.width = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setWidthRatio(@FloatRange(from=0.0, to=1.0) float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.widthRatio = value;
            return builder;
        }

        @NotNull
        public final Builder setHeight(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.height = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setSpace(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.space = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setArrowVisible(boolean value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowVisible = value;
            return builder;
        }

        @NotNull
        public final Builder setArrowSize(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowSize = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setArrowPosition(@FloatRange(from=0.0, to=1.0) float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowPosition = value;
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientation(@NotNull ArrowOrientation value) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowOrientation = value;
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawable(@Nullable Drawable value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowDrawable = value;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColor(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = value;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawable(@Nullable Drawable value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundDrawable = value;
            return builder;
        }

        @NotNull
        public final Builder setCornerRadius(float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cornerRadius = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.text = value;
            return builder;
        }

        @NotNull
        public final Builder setTextColor(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = value;
            return builder;
        }

        @NotNull
        public final Builder setTextSize(float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textSize = value;
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypeface = value;
            return builder;
        }

        @NotNull
        public final Builder setTextForm(@NotNull TextForm value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textForm = value;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawable(@Nullable Drawable value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconDrawable = value;
            return builder;
        }

        @NotNull
        public final Builder setIconSize(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSize = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setIconSpace(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSpace = ContextExtensionKt.dp2Px($this$apply.context, value);
            return builder;
        }

        @NotNull
        public final Builder setIconForm(@NotNull IconForm value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconForm = value;
            return builder;
        }

        @NotNull
        public final Builder setAlpha(@FloatRange(from=0.0, to=1.0) float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.alpha = value;
            return builder;
        }

        @NotNull
        public final Builder setLayout(@LayoutRes int layout) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.layout = layout;
            return builder;
        }

        @NotNull
        public final Builder setLifecycleOwner(@NotNull LifecycleOwner value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.lifecycleOwner = value;
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimation(@NotNull BalloonAnimation value) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonAnimation = value;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull OnBalloonClickListener value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = value;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull OnBalloonDismissListener value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = value;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull OnBalloonOutsideTouchListener value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = value;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull Function0<Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = new OnBalloonClickListener(unit){
                final /* synthetic */ Function0 $unit$inlined;
                {
                    this.$unit$inlined = function0;
                }

                public void onBalloonClick() {
                    this.$unit$inlined.invoke();
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull Function0<Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = new OnBalloonDismissListener(unit){
                final /* synthetic */ Function0 $unit$inlined;
                {
                    this.$unit$inlined = function0;
                }

                public void onBalloonDismiss() {
                    this.$unit$inlined.invoke();
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull Function0<Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = new OnBalloonOutsideTouchListener(unit){
                final /* synthetic */ Function0 $unit$inlined;
                {
                    this.$unit$inlined = function0;
                }

                public void onBalloonOutsideTouch() {
                    this.$unit$inlined.invoke();
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenTouchOutside(boolean value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenTouchOutside = value;
            return builder;
        }

        @NotNull
        public final Builder setPreferenceName(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.preferenceName = value;
            return builder;
        }

        @NotNull
        public final Builder setShowTime(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.showTimes = value;
            return builder;
        }

        @NotNull
        public final Balloon build() {
            return new Balloon(this.context, this);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.width = ContextExtensionKt.displaySize((Context)this.context).x;
            this.height = ContextExtensionKt.dp2Px(this.context, 60);
            this.arrowVisible = true;
            this.arrowSize = ContextExtensionKt.dp2Px(this.context, 15);
            this.arrowPosition = 0.5f;
            this.arrowOrientation = ArrowOrientation.BOTTOM;
            this.backgroundColor = -16777216;
            this.cornerRadius = ContextExtensionKt.dp2Px(this.context, 5);
            this.text = "";
            this.textColor = -1;
            this.textSize = 12.0f;
            this.iconSize = ContextExtensionKt.dp2Px(this.context, 28);
            this.iconSpace = ContextExtensionKt.dp2Px(this.context, 8);
            this.alpha = 1.0f;
            this.layout = -1;
            this.balloonAnimation = BalloonAnimation.FADE;
            this.showTimes = 1;
        }
    }
}

