/*
 * Decompiled with CFR 0.152.
 */
package com.skjolberg.mockito.soap;

import com.skjolberg.mockito.soap.SoapServiceProxy;
import com.skjolberg.mockito.soap.SoapServiceRule;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;

public class SoapServerRule
extends SoapServiceRule {
    private Map<String, Server> servers = new HashMap<String, Server>();

    public static SoapServerRule newInstance() {
        return new SoapServerRule();
    }

    @Override
    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations) {
        if (target == null) {
            throw new IllegalArgumentException("Expected proxy target");
        }
        if (port == null) {
            throw new IllegalArgumentException("Expect port class");
        }
        if (address == null) {
            throw new IllegalArgumentException("Expected address");
        }
        try {
            new URL(address);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Expected valid address: " + address, e);
        }
        if (this.servers.containsKey(address)) {
            throw new IllegalArgumentException("Server " + address + " already exists");
        }
        T serviceInterface = SoapServiceProxy.newInstance(target);
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setServiceClass(port);
        svrFactory.setAddress(address);
        svrFactory.setServiceBean(serviceInterface);
        if (wsdlLocation != null || schemaLocations != null) {
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("schema-validation-enabled", true);
            svrFactory.setProperties(properties);
            if (wsdlLocation != null) {
                svrFactory.setWsdlLocation(wsdlLocation);
            }
            if (schemaLocations != null) {
                svrFactory.setSchemaLocations(schemaLocations);
            }
        }
        Server server = svrFactory.create();
        this.servers.put(address, server);
        server.start();
    }

    protected void before() throws Throwable {
        super.before();
    }

    protected void after() {
        this.reset();
    }

    public void destroy() {
        this.reset();
    }

    @Override
    public void stop() {
        for (Map.Entry<String, Server> entry : this.servers.entrySet()) {
            entry.getValue().stop();
        }
    }

    @Override
    public void start() {
        for (Map.Entry<String, Server> entry : this.servers.entrySet()) {
            entry.getValue().start();
        }
    }

    public void reset() {
        for (Map.Entry<String, Server> entry : this.servers.entrySet()) {
            entry.getValue().getDestination().shutdown();
            entry.getValue().destroy();
        }
        this.servers.clear();
    }
}

