/*
 * Decompiled with CFR 0.152.
 */
package com.skjolberg.mockito.soap;

import com.skjolberg.mockito.soap.SoapServiceProxy;
import com.skjolberg.mockito.soap.SoapServiceRule;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ServerSocketFactory;
import javax.xml.ws.spi.Provider;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.mockito.Mockito;

public class SoapEndpointRule
extends SoapServiceRule {
    private static final int PORT_RANGE_MAX = 65535;
    private static final int PORT_RANGE_START = 1025;
    private static final int PORT_RANGE_END = 65535;
    private Map<String, EndpointImpl> endpoints = new HashMap<String, EndpointImpl>();
    private List<PortReservation> reservations = new ArrayList<PortReservation>();
    private final int portRangeStart;
    private final int portRangeEnd;

    protected static boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static SoapEndpointRule newInstance() {
        return new SoapEndpointRule();
    }

    public static SoapEndpointRule newInstance(String ... portNames) {
        return new SoapEndpointRule(portNames);
    }

    public static SoapEndpointRule newInstance(int portRangeStart, int portRangeEnd, String ... portNames) {
        return new SoapEndpointRule(portRangeStart, portRangeEnd, portNames);
    }

    public SoapEndpointRule() {
        this(1025, 65535, new String[0]);
    }

    public SoapEndpointRule(String ... portNames) {
        this(1025, 65535, portNames);
    }

    public SoapEndpointRule(int portRangeStart, int portRangeEnd, String ... portNames) {
        if (portRangeStart <= 0) {
            throw new IllegalArgumentException("Port range start must be greater than 0.");
        }
        if (portRangeEnd < portRangeStart) {
            throw new IllegalArgumentException("Port range end must not be lower than port range end.");
        }
        if (portRangeEnd > 65535) {
            throw new IllegalArgumentException("Port range end must not be larger than 65535.");
        }
        if (portNames != null && portNames.length > portRangeEnd - portRangeStart + 1) {
            throw new IllegalArgumentException("Cannot reserve " + portNames.length + " in range " + portRangeStart + "-" + portRangeEnd + ".");
        }
        this.portRangeStart = portRangeStart;
        this.portRangeEnd = portRangeEnd;
        if (portNames != null) {
            for (String portName : portNames) {
                this.reservations.add(new PortReservation(portName));
            }
        }
    }

    public Map<String, Integer> getPorts() {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        for (PortReservation portReservation : this.reservations) {
            ports.put(portReservation.getPropertyName(), portReservation.getPort());
        }
        return ports;
    }

    public int getPort(String name) {
        for (PortReservation portReservation : this.reservations) {
            if (!name.equals(portReservation.getPropertyName())) continue;
            return portReservation.getPort();
        }
        throw new IllegalArgumentException("No reserved port for '" + name + "'.");
    }

    private Destination reservePort(int port) throws IOException, EndpointException {
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = new JaxWsServiceFactoryBean();
        JaxWsServerFactoryBean serverFactoryBean = new JaxWsServerFactoryBean(jaxWsServiceFactoryBean);
        serverFactoryBean.setAddress("http://localhost:" + port);
        Bus bus = serverFactoryBean.getBus();
        DestinationFactory destinationFactory = ((DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class)).getDestinationFactoryForUri(serverFactoryBean.getAddress());
        EndpointInfo ei = new EndpointInfo(null, Integer.toString(port));
        ei.setAddress(serverFactoryBean.getAddress());
        Destination destination = destinationFactory.getDestination(ei, serverFactoryBean.getBus());
        ServiceImpl serviceImpl = new ServiceImpl();
        org.apache.cxf.endpoint.EndpointImpl endpoint = new org.apache.cxf.endpoint.EndpointImpl(bus, (Service)serviceImpl, ei);
        destination.setMessageObserver((MessageObserver)new ChainInitiationObserver((Endpoint)endpoint, bus));
        return destination;
    }

    @Override
    public <T> void proxy(T target, Class<T> port, String address, String wsdlLocation, List<String> schemaLocations) {
        URL url;
        if (target == null) {
            throw new IllegalArgumentException("Expected proxy target");
        }
        if (port == null) {
            throw new IllegalArgumentException("Expect port class");
        }
        if (address == null) {
            throw new IllegalArgumentException("Expected address");
        }
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Expected valid address: " + address, e);
        }
        if (this.endpoints.containsKey(address)) {
            throw new IllegalArgumentException("Endpoint " + address + " already exists");
        }
        T serviceInterface = SoapServiceProxy.newInstance(target);
        Destination destination = this.getDestination(url.getPort());
        EndpointImpl endpoint = (EndpointImpl)Provider.provider().createEndpoint(null, serviceInterface);
        if (wsdlLocation != null || schemaLocations != null) {
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("schema-validation-enabled", true);
            endpoint.setProperties(properties);
            if (wsdlLocation != null) {
                endpoint.setWsdlLocation(wsdlLocation);
            }
            if (schemaLocations != null) {
                endpoint.setSchemaLocations(schemaLocations);
            }
        }
        if (destination != null) {
            ServerImpl server = endpoint.getServer();
            server.setDestination(destination);
        }
        endpoint.publish(address);
        this.endpoints.put(address, endpoint);
    }

    private Destination getDestination(int port) {
        for (PortReservation reservation : this.reservations) {
            if (reservation.getPort() != port) continue;
            return reservation.getDestination();
        }
        return null;
    }

    @Override
    public <T> T mock(Class<T> port, String address) {
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, null, null);
        return (T)mock;
    }

    @Override
    public <T> T mock(Class<T> port, String address, String wsdlLocation) {
        if (wsdlLocation == null || wsdlLocation.isEmpty()) {
            throw new IllegalArgumentException("Expected wsdl location");
        }
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, wsdlLocation, null);
        return (T)mock;
    }

    @Override
    public <T> T mock(Class<T> port, String address, List<String> schemaLocations) {
        if (schemaLocations == null || schemaLocations.isEmpty()) {
            throw new IllegalArgumentException("Expected schema locations");
        }
        Object mock = Mockito.mock(port);
        this.proxy(mock, port, address, null, schemaLocations);
        return (T)mock;
    }

    protected void before() throws Throwable {
        for (PortReservation reservation : this.reservations) {
            reservation.start();
        }
    }

    protected void after() {
        this.destroy();
    }

    public void clear() {
        for (Map.Entry<String, EndpointImpl> entry : this.endpoints.entrySet()) {
            entry.getValue().stop();
        }
        this.endpoints.clear();
    }

    public void destroy() {
        for (Map.Entry<String, EndpointImpl> entry : this.endpoints.entrySet()) {
            entry.getValue().getServer().stop();
            entry.getValue().stop();
        }
        for (PortReservation reservation : this.reservations) {
            reservation.stop();
        }
    }

    @Override
    public void stop() {
        for (Map.Entry<String, EndpointImpl> entry : this.endpoints.entrySet()) {
            entry.getValue().getServer().stop();
        }
    }

    @Override
    public void start() {
        for (Map.Entry<String, EndpointImpl> entry : this.endpoints.entrySet()) {
            entry.getValue().getServer().start();
        }
    }

    private class PortReservation {
        private final String propertyName;
        private Destination destination;
        private int port = -1;

        public PortReservation(String portName) {
            this.propertyName = portName;
        }

        public void reserved(int port, Destination destination) {
            this.port = port;
            this.destination = destination;
            System.setProperty(this.propertyName, Integer.toString(port));
        }

        public void stop() {
            if (this.destination != null) {
                this.destination.shutdown();
                System.clearProperty(this.propertyName);
                this.port = -1;
            }
        }

        public void start() {
            int portRange = SoapEndpointRule.this.portRangeEnd - SoapEndpointRule.this.portRangeStart + 1;
            int offset = new Random().nextInt(portRange);
            for (int i = 0; i < portRange; ++i) {
                try {
                    int candidatePort = SoapEndpointRule.this.portRangeStart + (offset + portRange) % portRange;
                    if (!SoapEndpointRule.isPortAvailable(candidatePort)) continue;
                    Destination destination = SoapEndpointRule.this.reservePort(candidatePort);
                    this.reserved(candidatePort, destination);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Unable to reserve port for " + this.propertyName);
        }

        public Destination getDestination() {
            return this.destination;
        }

        public int getPort() {
            return this.port;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

