/*
 * Decompiled with CFR 0.152.
 */
package kankan.wheel.widget.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import kankan.wheel.R;
import kankan.wheel.widget.adapters.AbstractWheelTextAdapter;

public class DaysAdapter
extends AbstractWheelTextAdapter {
    private static final int DEFAULT_DAY_COUNTS = 20;
    private Calendar mCalendar;
    private int mDayCount;

    public DaysAdapter(Context context, Calendar calendar, int dayCount) {
        super(context, R.layout.v4_view_wheel_day, R.id.text);
        if (dayCount < 20) {
            dayCount = 20;
        }
        this.mCalendar = calendar;
        this.mDayCount = dayCount;
    }

    @Override
    public View getItem(int index, View cachedView, ViewGroup parent) {
        int day = -this.mDayCount / 2 + index;
        Calendar newCalendar = (Calendar)this.mCalendar.clone();
        newCalendar.roll(6, day);
        Calendar todayCalendar = Calendar.getInstance();
        int todayDoY = todayCalendar.get(6);
        int afterRollDoY = newCalendar.get(6);
        TextView itemView = (TextView)super.getItem(index, cachedView, parent);
        if (todayDoY == afterRollDoY) {
            itemView.setText((CharSequence)"Today");
        } else {
            itemView.setText(this.getItemText(index));
        }
        return itemView;
    }

    @Override
    public int getItemsCount() {
        return this.mDayCount + 1;
    }

    @Override
    public CharSequence getItemText(int index) {
        int day = -this.mDayCount / 2 + index;
        Calendar newCalendar = (Calendar)this.mCalendar.clone();
        newCalendar.roll(6, day);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EE MMM dd");
        return dateFormat.format(newCalendar.getTime());
    }

    public long getItemValue(int index) {
        int day = -this.mDayCount / 2 + index;
        Calendar newCalendar = (Calendar)this.mCalendar.clone();
        newCalendar.roll(6, day);
        newCalendar.get(6);
        return newCalendar.getTime().getTime();
    }
}

