/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.BranchNode;
import com.github.sisyphsu.retree.CharSingleNode;
import com.github.sisyphsu.retree.CharSliceNode;
import com.github.sisyphsu.retree.CurlyNode;
import com.github.sisyphsu.retree.EndNode;
import com.github.sisyphsu.retree.GroupNode;
import com.github.sisyphsu.retree.LoopNode;
import com.github.sisyphsu.retree.Node;
import com.github.sisyphsu.retree.ReCompiler;
import java.util.ArrayList;
import java.util.List;

public final class ReTree {
    private static final int F_LOOP = 2;
    private static final int F_CHAR = 4;
    private static final int F_ANON = 8;
    final int localVarCount;
    final int groupVarCount;
    final Node root;

    public ReTree(String ... exps) {
        ArrayList<Node> nodes = new ArrayList<Node>(exps.length);
        for (String exp : exps) {
            Node node = ReCompiler.compile((String)exp).root;
            node = this.optimizeGroup(node);
            node = this.optimizeLoop(node);
            nodes.add(node);
        }
        int loopVarCount = 0;
        int groupVarCount = 0;
        for (Node node : nodes) {
            EndNode endNode = this.findEndNode(node);
            loopVarCount = Math.max(loopVarCount, endNode.localCount);
            groupVarCount = Math.max(groupVarCount, endNode.groupCount);
        }
        Node treeRoot = this.buildTree(nodes);
        if ((treeRoot = this.optimizeCharSlice(treeRoot)) != null) {
            treeRoot.study();
        }
        this.root = treeRoot;
        this.localVarCount = loopVarCount;
        this.groupVarCount = groupVarCount;
    }

    private Node buildTree(List<Node> nodes) {
        ArrayList<Node> branches = new ArrayList<Node>();
        ArrayList<Node> nexts = new ArrayList<Node>();
        while (nodes.size() > 0) {
            Node curr = nodes.get(0);
            nodes.removeIf(node -> {
                if (node == curr || node.alike(curr)) {
                    if (node.next != null) {
                        nexts.add(node.next);
                    }
                    return true;
                }
                return false;
            });
            if (nexts.size() > 0) {
                curr.next = this.buildTree(nexts);
            }
            branches.add(curr);
            nexts.clear();
        }
        if (branches.size() == 0) {
            throw new IllegalArgumentException("node can't be empty or null");
        }
        if (branches.size() == 1) {
            return (Node)branches.get(0);
        }
        return new BranchNode(branches);
    }

    private Node optimizeGroup(Node node) {
        GroupNode.Tail tail;
        if (node == null) {
            return null;
        }
        if ((node.flag & 8) > 0) {
            return node;
        }
        node.flag |= 8;
        if (node instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)node;
            for (int i = 0; i < branchNode.branches.size(); ++i) {
                branchNode.branches.set(i, this.optimizeGroup(branchNode.branches.get(i)));
            }
        } else if (node instanceof LoopNode) {
            LoopNode loop = (LoopNode)node;
            loop.body = this.optimizeGroup(loop.body);
        } else if (node instanceof GroupNode) {
            GroupNode groupNode = (GroupNode)node;
            if (groupNode.isAnonymous()) {
                return this.optimizeGroup(groupNode.next);
            }
        } else if (node instanceof GroupNode.Tail && (tail = (GroupNode.Tail)node).isAnonymous()) {
            return this.optimizeGroup(tail.next);
        }
        node.next = this.optimizeGroup(node.next);
        return node;
    }

    private Node optimizeLoop(Node node) {
        if (node == null) {
            return null;
        }
        if ((node.flag & 2) > 0) {
            return node;
        }
        node.flag |= 2;
        if (node instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)node;
            for (int i = 0; i < branchNode.branches.size(); ++i) {
                branchNode.branches.set(i, this.optimizeLoop(branchNode.branches.get(i)));
            }
            branchNode.next = this.optimizeLoop(branchNode.next);
        } else if (node instanceof LoopNode) {
            LoopNode loop = (LoopNode)node;
            loop.next = this.optimizeLoop(loop.next);
            Node body = loop.body = this.optimizeLoop(loop.body);
            while (!(body == null || body instanceof BranchNode || body instanceof LoopNode || body instanceof CurlyNode)) {
                if (body.next == loop) {
                    node = new CurlyNode(loop.type, loop.minTimes, loop.maxTimes, loop.body, loop.next);
                    body.next = null;
                    break;
                }
                body = body.next;
            }
        } else {
            node.next = this.optimizeLoop(node.next);
        }
        return node;
    }

    private Node optimizeCharSlice(Node node) {
        if (node == null) {
            return null;
        }
        if ((node.flag & 4) > 0) {
            return node;
        }
        node.flag |= 4;
        if (node instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)node;
            for (int i2 = 0; i2 < branchNode.branches.size(); ++i2) {
                branchNode.branches.set(i2, this.optimizeCharSlice(branchNode.branches.get(i2)));
            }
        } else if (node instanceof LoopNode) {
            LoopNode loopNode = (LoopNode)node;
            loopNode.body = this.optimizeCharSlice(loopNode.body);
        } else if (node instanceof CurlyNode) {
            CurlyNode curlyNode = (CurlyNode)node;
            curlyNode.body = this.optimizeCharSlice(curlyNode.body);
        } else if (node instanceof CharSingleNode) {
            Node next = node;
            ArrayList<Integer> chars = new ArrayList<Integer>();
            while (next instanceof CharSingleNode) {
                chars.add(((CharSingleNode)next).ch);
                next = next.next;
            }
            if (chars.size() > 1) {
                node = new CharSliceNode(chars.stream().mapToInt(i -> i).toArray());
                node.next = next;
            }
        }
        node.next = this.optimizeCharSlice(node.next);
        return node;
    }

    private EndNode findEndNode(Node node) {
        if (node instanceof EndNode) {
            return (EndNode)node;
        }
        return this.findEndNode(node.next);
    }
}

