/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.retree;

import com.github.sisyphsu.retree.EndNode;
import com.github.sisyphsu.retree.ReTree;
import java.util.Arrays;
import java.util.regex.MatchResult;

public final class ReMatcher
implements MatchResult {
    final int[] groupVars;
    final long[] loopVars;
    int[] backs = new int[4];
    int from;
    int to;
    CharSequence input;
    int stop;
    int last;
    private boolean hitEnd;
    private final ReTree tree;
    EndNode endNode;

    public ReMatcher(String ... res) {
        this(new ReTree(res), (CharSequence)"");
    }

    public ReMatcher(ReTree tree, CharSequence input) {
        this.tree = tree;
        this.loopVars = new long[tree.localVarCount];
        this.groupVars = new int[tree.groupVarCount * 2];
        this.reset(input);
        Arrays.fill(this.loopVars, -1L);
    }

    public ReMatcher reset(CharSequence input) {
        this.input = input;
        this.from = 0;
        this.to = input.length();
        this.last = 0;
        return this;
    }

    public boolean matches() {
        this.stop = 0;
        this.hitEnd = true;
        return this.search(0);
    }

    public boolean matches(CharSequence input) {
        this.reset(input);
        return this.matches();
    }

    public boolean find() {
        this.stop = this.to - this.tree.root.minInput;
        this.hitEnd = false;
        int offset = this.last;
        boolean succ = this.search(offset);
        if (succ && offset > 0 && offset < this.stop && offset == this.groupVars[1]) {
            succ = false;
        }
        if (succ) {
            this.last = this.groupVars[1];
        }
        return succ;
    }

    public boolean find(int offset) {
        this.stop = offset;
        this.hitEnd = false;
        return this.search(offset);
    }

    private boolean search(int from) {
        for (int i = 0; i < this.groupVars.length; ++i) {
            this.groupVars[i] = -1;
        }
        boolean success = this.tree.root.match(this, this.input, from);
        if (success && this.hitEnd && this.groupVars[1] != this.to) {
            success = false;
        }
        return success;
    }

    @Override
    public int start() {
        return this.start(0);
    }

    @Override
    public int start(int groupIndex) {
        if (this.endNode != null) {
            return this.groupVars[groupIndex * 2];
        }
        throw new IllegalStateException("Invalid MatchResult");
    }

    @Override
    public int end() {
        return this.end(0);
    }

    @Override
    public int end(int groupIndex) {
        if (this.endNode != null) {
            return this.groupVars[groupIndex * 2 + 1];
        }
        throw new IllegalStateException("Invalid MatchResult");
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int groupIndex) {
        if (this.endNode != null) {
            return this.input.subSequence(this.start(groupIndex), this.end(groupIndex)).toString();
        }
        throw new IllegalStateException("Invalid MatchResult");
    }

    @Override
    public int groupCount() {
        if (this.endNode != null) {
            return this.endNode.groupCount - 1;
        }
        throw new IllegalStateException("Invalid MatchResult");
    }

    public CharSequence group(String groupName) {
        if (this.endNode != null) {
            Integer groupIndex = this.endNode.groupNameMap.get(groupName);
            if (groupIndex == null) {
                throw new IllegalArgumentException("groupName is invalid: " + groupName);
            }
            return this.group(groupIndex);
        }
        throw new IllegalStateException("Invalid MatchResult");
    }

    public String re() {
        if (this.endNode != null) {
            return this.endNode.re;
        }
        throw new IllegalStateException("Invalid MatchResult");
    }

    public String groupName(int groupIndex) {
        if (this.endNode != null) {
            return this.endNode.groupNames.get(groupIndex);
        }
        throw new IllegalStateException("Invalid MatchResult");
    }
}

